/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.CopyResourceContext;
import org.apache.geronimo.deployment.DeploymentConfigurationManager;
import org.apache.geronimo.deployment.InPlaceResourceContext;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;

public class DeploymentContext {
    private final File baseDir;
    private final File inPlaceConfigurationDir;
    private final ResourceContext resourceContext;
    private final byte[] buffer = new byte[4096];
    private final Map childConfigurationDatas = new LinkedHashMap();
    private final ConfigurationManager configurationManager;
    private final Configuration configuration;
    private final Naming naming;
    private final List additionalDeployment = new ArrayList();
    protected final AbstractName moduleName;

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection repositories) throws DeploymentException {
        this(baseDir, inPlaceConfigurationDir, environment, moduleName, moduleType, naming, DeploymentContext.createConfigurationManager(configurationManager, repositories));
    }

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager) throws DeploymentException {
        if (baseDir == null) {
            throw new NullPointerException("baseDir is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (moduleType == null) {
            throw new NullPointerException("type is null");
        }
        if (configurationManager == null) {
            throw new NullPointerException("configurationManager is null");
        }
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        this.baseDir = baseDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
        this.moduleName = moduleName;
        this.naming = naming;
        this.configuration = DeploymentContext.createTempConfiguration(environment, moduleType, baseDir, inPlaceConfigurationDir, configurationManager, naming);
        this.configurationManager = configurationManager;
        this.resourceContext = null == inPlaceConfigurationDir ? new CopyResourceContext(this.configuration, baseDir) : new InPlaceResourceContext(this.configuration, inPlaceConfigurationDir);
    }

    private static ConfigurationManager createConfigurationManager(ConfigurationManager configurationManager, Collection repositories) {
        return new DeploymentConfigurationManager(configurationManager, repositories);
    }

    private static Configuration createTempConfiguration(Environment environment, ConfigurationModuleType moduleType, File baseDir, File inPlaceConfigurationDir, ConfigurationManager configurationManager, Naming naming) throws DeploymentException {
        try {
            configurationManager.loadConfiguration(new ConfigurationData(moduleType, null, null, null, environment, baseDir, inPlaceConfigurationDir, naming));
            return configurationManager.getConfiguration(environment.getConfigId());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to create configuration for deployment", (Throwable)e);
        }
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Artifact getConfigID() {
        return this.configuration.getId();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getInPlaceConfigurationDir() {
        return this.inPlaceConfigurationDir;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo) throws GBeanAlreadyExistsException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanInfo == null) {
            throw new NullPointerException("gbean is null");
        }
        GBeanData gbean = new GBeanData(gbeanInfo);
        this.configuration.addGBean(name, gbean);
        return gbean;
    }

    public void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (gbean == null) {
            throw new NullPointerException("gbean is null");
        }
        if (gbean.getAbstractName() == null) {
            throw new NullPointerException("gbean.getAbstractName() is null");
        }
        this.configuration.addGBean(gbean);
    }

    public void removeGBean(AbstractName name) throws GBeanNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.configuration.removeGBean(name);
    }

    public Set getGBeanNames() {
        return new HashSet(this.configuration.getGBeans().keySet());
    }

    public Set listGBeans(AbstractNameQuery pattern) {
        return this.findGBeans(pattern);
    }

    public AbstractName findGBean(AbstractNameQuery pattern) throws GBeanNotFoundException {
        return this.configuration.findGBean(pattern);
    }

    public AbstractName findGBean(Set patterns) throws GBeanNotFoundException {
        return this.configuration.findGBean(patterns);
    }

    public LinkedHashSet findGBeans(AbstractNameQuery pattern) {
        return this.configuration.findGBeans(pattern);
    }

    public LinkedHashSet findGBeans(Set patterns) {
        return this.configuration.findGBeans(patterns);
    }

    public GBeanData getGBeanInstance(AbstractName name) throws GBeanNotFoundException {
        Map gbeans = this.configuration.getGBeans();
        GBeanData gbeanData = (GBeanData)gbeans.get(name);
        if (gbeanData == null) {
            throw new GBeanNotFoundException(name);
        }
        return gbeanData;
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        this.resourceContext.addIncludeAsPackedJar(targetPath, jarFile);
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addInclude(targetPath, zipFile, zipEntry);
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri) throws DeploymentException {
        Manifest manifest;
        try {
            manifest = moduleFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + moduleBaseUri);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: module=" + moduleBaseUri + ", path=" + path);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): module=" + moduleBaseUri);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): moduel=" + moduleBaseUri);
            }
            try {
                URI targetUri = moduleBaseUri.resolve(pathUri);
                if (targetUri.getPath().endsWith("/")) {
                    throw new IllegalStateException("target path must not end with a '/' character: " + targetUri);
                }
                this.configuration.addToClassPath(targetUri.toString());
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public void addClass(URI targetPath, String fqcn, byte[] bytes) throws IOException, URISyntaxException {
        if (!targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must end with a '/' character: " + targetPath);
        }
        String classFileName = fqcn.replace('.', '/') + ".class";
        File targetFile = this.getTargetFile(new URI(targetPath.toString() + classFileName));
        this.addFile(targetFile, new ByteArrayInputStream(bytes));
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addFile(targetPath, zipFile, zipEntry);
    }

    public void addFile(URI targetPath, URL source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, File source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, String source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, InputStream source) throws IOException {
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int count;
            out = new FileOutputStream(targetFile);
            while ((count = source.read(this.buffer)) > 0) {
                ((OutputStream)out).write(this.buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(out);
            throw throwable;
        }
        DeploymentUtil.close(out);
    }

    public File getTargetFile(URI targetPath) {
        return this.resourceContext.getTargetFile(targetPath);
    }

    public ClassLoader getClassLoader() throws DeploymentException {
        return this.configuration.getConfigurationClassLoader();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void flush() throws IOException {
        this.resourceContext.flush();
    }

    public void close() throws IOException, DeploymentException {
        if (this.configurationManager != null) {
            try {
                this.configurationManager.unloadConfiguration(this.configuration.getId());
            }
            catch (NoSuchConfigException noSuchConfigException) {
                // empty catch block
            }
        }
    }

    public void addChildConfiguration(String moduleName, ConfigurationData configurationData) {
        this.childConfigurationDatas.put(moduleName, configurationData);
    }

    public ConfigurationData getConfigurationData() throws DeploymentException {
        List failures = this.verify();
        if (!failures.isEmpty()) {
            StringBuffer message = new StringBuffer();
            Iterator iterator = failures.iterator();
            while (iterator.hasNext()) {
                String failure = (String)iterator.next();
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(failure);
            }
            throw new DeploymentException(message.toString());
        }
        ArrayList gbeans = new ArrayList(this.configuration.getGBeans().values());
        Collections.sort(gbeans, new GBeanData.PriorityComparator());
        ConfigurationData configurationData = new ConfigurationData(this.configuration.getModuleType(), new LinkedHashSet(this.configuration.getClassPath()), gbeans, this.childConfigurationDatas, this.configuration.getEnvironment(), this.baseDir, this.inPlaceConfigurationDir, this.naming);
        Iterator iterator = this.additionalDeployment.iterator();
        while (iterator.hasNext()) {
            ConfigurationData ownedConfiguration = (ConfigurationData)iterator.next();
            configurationData.addOwnedConfigurations(ownedConfiguration.getId());
        }
        return configurationData;
    }

    public void addAdditionalDeployment(ConfigurationData configurationData) {
        this.additionalDeployment.add(configurationData);
    }

    public List getAdditionalDeployment() {
        return this.additionalDeployment;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public List verify() throws DeploymentException {
        ArrayList<String> failures = new ArrayList<String>();
        Iterator iterator = this.configuration.getGBeans().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AbstractName name = (AbstractName)entry.getKey();
            GBeanData gbean = (GBeanData)entry.getValue();
            Iterator iterator1 = gbean.getReferences().entrySet().iterator();
            while (iterator1.hasNext()) {
                ReferencePatterns referencePatterns;
                Map.Entry referenceEntry = iterator1.next();
                String referenceName = (String)referenceEntry.getKey();
                String failure = this.verifyReference(gbean, referenceName, referencePatterns = (ReferencePatterns)referenceEntry.getValue());
                if (failure == null) continue;
                failures.add(failure);
            }
            iterator1 = gbean.getDependencies().iterator();
            while (iterator1.hasNext()) {
                ReferencePatterns referencePatterns = (ReferencePatterns)iterator1.next();
                String failure = this.verifyDependency(name, referencePatterns);
                if (failure == null) continue;
                failures.add(failure);
            }
        }
        return failures;
    }

    private String verifyReference(GBeanData gbean, String referenceName, ReferencePatterns referencePatterns) {
        GReferenceInfo referenceInfo = gbean.getGBeanInfo().getReference(referenceName);
        if (referenceInfo == null) {
            return null;
        }
        if (referenceInfo.getProxyType().equals(Collection.class.getName())) {
            return null;
        }
        if (!this.isVerifyReference(referencePatterns)) {
            return "Unable to resolve reference \"" + referenceName + "\" in gbean " + gbean.getAbstractName() + " to a gbean matching the pattern " + referencePatterns.getPatterns();
        }
        return null;
    }

    private String verifyDependency(AbstractName name, ReferencePatterns referencePatterns) {
        if (!this.isVerifyReference(referencePatterns)) {
            return "Unable to resolve dependency in gbean " + name + " to a gbean matching the pattern " + referencePatterns.getPatterns();
        }
        return null;
    }

    private boolean isVerifyReference(ReferencePatterns referencePatterns) {
        if (referencePatterns.isResolved()) {
            return true;
        }
        Set patterns = referencePatterns.getPatterns();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            AbstractNameQuery query = (AbstractNameQuery)iterator.next();
            if (query.getArtifact() == null) continue;
            return true;
        }
        try {
            this.findGBean(patterns);
            return true;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }
}

