/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.util.SimpleEncryption;

public class CommandLogin
extends AbstractCommand {
    public CommandLogin() {
        super("login", "1. Common Commands", "", "Saves the username and password for this connection to the file .geronimo-deployer in the current user's home directory.  Future connections to the same server will try to use this saved authentication information instead of prompting where possible.  This information is saved separately per connection URL, so you can specify --url or --host and/or --port on the command line to save a login to a different server.\nWARNING: while the login information is not saved in clear text, it is not secure either.  If you want to save the authentication securely, you should change the .geronimo-deployer file in your home directory so that nobody else can read or write it.");
    }

    public CommandLogin(String command, String group, String helpArgumentList, String helpText) {
        super(command, group, helpArgumentList, helpText);
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        try {
            File authFile = new File(System.getProperty("user.home"), ".geronimo-deployer");
            if (!authFile.exists() && !authFile.createNewFile()) {
                throw new DeploymentException("Unable to create " + authFile.getAbsolutePath() + " to hold saved logins");
            }
            if (!authFile.canRead() || !authFile.canWrite()) {
                throw new DeploymentException("Saved login file " + authFile.getAbsolutePath() + " is not readable or not writable");
            }
            Properties props = new Properties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(authFile));
            props.load(in);
            ((InputStream)in).close();
            props.setProperty("login." + connection.getServerURI(), "{Standard}" + SimpleEncryption.encrypt((Serializable)connection.getAuthentication()));
            BufferedOutputStream save = new BufferedOutputStream(new FileOutputStream(authFile));
            props.store(save, "Saved authentication information to connect to Geronimo servers");
            ((OutputStream)save).flush();
            ((OutputStream)save).close();
            System.out.print(DeployUtils.reformat("Saved login for: " + connection.getServerURI(), 4, 72));
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to save authentication to login file", (Throwable)e);
        }
    }
}

