/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisconnectedDeploymentManager
implements DeploymentManager {
    private static final Log log = LogFactory.getLog((Class)DisconnectedDeploymentManager.class);

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        if (!dObj.getType().equals(ModuleType.CAR) && !dObj.getType().equals(ModuleType.EAR)) {
            if (dObj.getType().equals(ModuleType.EJB)) {
                try {
                    Class<?> cls = Class.forName("org.apache.openejb.deployment.EJBConfigurer");
                    return (DeploymentConfiguration)cls.getMethod("createConfiguration", DeployableObject.class).invoke(cls.newInstance(), dObj);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to invoke EJB deployer", (Throwable)e);
                }
            } else if (dObj.getType().equals(ModuleType.RAR) || dObj.getType().equals(ModuleType.WAR)) {
                // empty if block
            }
        }
        throw new InvalidModuleException("Not supported");
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{this.getDefaultLocale()};
    }

    public Locale getCurrentLocale() {
        return this.getDefaultLocale();
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.getDefaultLocale().equals(locale);
    }

    public void setLocale(Locale locale) {
        if (this.isLocaleSupported(locale)) {
            throw new UnsupportedOperationException("Unsupported Locale");
        }
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return DConfigBeanVersionType.V1_4.equals(version);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(version)) {
            throw new DConfigBeanVersionUnsupportedException("Version not supported " + version);
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targets) throws TargetException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targets) throws TargetException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targets) throws TargetException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject distribute(Target[] targets, File file, File file1) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject distribute(Target[] targets, InputStream inputStream, InputStream inputStream1) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, InputStream inputStream, InputStream inputStream1) throws UnsupportedOperationException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public void release() {
        throw new IllegalStateException("Disconnected");
    }
}

