/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.io.IOException;
import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFCatalogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CXFCatalogUtils.class);

    private CXFCatalogUtils() {
    }

    public static void loadOASISCatalog(Bus bus, URL catalogURL) {
        OASISCatalogManager catalog = new OASISCatalogManager();
        try {
            catalog.loadCatalog(catalogURL);
            LOG.debug("Loaded " + catalogURL + " catalog.");
            bus.setExtension((Object)catalog, OASISCatalogManager.class);
        }
        catch (IOException e) {
            LOG.warn("Failed to load catalog file: " + catalogURL, (Throwable)e);
        }
    }
}

