/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.ejb;

import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.w3c.dom.Element;

public class EJBMessageContext
extends WrappedMessageContext
implements AddressingSupport {
    public EJBMessageContext(Message m, MessageContext.Scope defScope) {
        super(m, defScope);
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        Message msg = this.getWrappedMessage();
        Endpoint ep = (Endpoint)msg.getExchange().get(Endpoint.class);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(ep.getEndpointInfo().getAddress());
        builder.serviceName(ep.getService().getName());
        builder.endpointName(ep.getEndpointInfo().getName());
        if (referenceParameters != null) {
            for (Element referenceParameter : referenceParameters) {
                builder.referenceParameter(referenceParameter);
            }
        }
        return builder.build();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (W3CEndpointReference.class.isAssignableFrom(clazz)) {
            return (T)((EndpointReference)clazz.cast(this.getEndpointReference(referenceParameters)));
        }
        throw new WebServiceException("Endpoint reference type not supported: " + clazz);
    }
}

