/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.ejb;

import java.lang.reflect.Method;
import java.util.List;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Binding;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.interceptor.ServiceInvokerInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.geronimo.cxf.ejb.EJBEndpoint;
import org.apache.geronimo.cxf.ejb.EJBMethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EJBInterceptor.class);
    private Exchange exchange;
    private Bus bus;
    private EJBEndpoint ejbEndpoint;
    private List<Object> params;
    private Method method;

    public EJBInterceptor(List<Object> params, Method method, EJBEndpoint endpoint, Bus bus, Exchange exchange) {
        this.params = params;
        this.method = method;
        this.ejbEndpoint = endpoint;
        this.bus = bus;
        this.exchange = exchange;
    }

    private static void copyDataBindingInterceptors(PhaseInterceptorChain newChain, InterceptorChain oldChain) {
        for (Interceptor interceptor : oldChain) {
            if (!(interceptor instanceof AbstractInDatabindingInterceptor)) continue;
            LOG.debug("Added data binding interceptor: " + interceptor);
            newChain.add(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Endpoint endpoint = (Endpoint)this.exchange.get(Endpoint.class);
        Service service = endpoint.getService();
        Binding binding = ((JaxWsEndpointImpl)endpoint).getJaxwsBinding();
        this.exchange.put(InvocationContext.class, (Object)context);
        if (binding.getHandlerChain() == null || binding.getHandlerChain().isEmpty()) {
            LOG.debug("No handlers found.");
            EJBMethodInvoker invoker = (EJBMethodInvoker)service.getInvoker();
            return invoker.directEjbInvoke(this.exchange, this.method, this.params);
        }
        LOG.debug("Handlers found.");
        this.ejbEndpoint.injectHandlers();
        Message inMessage = this.exchange.getInMessage();
        PhaseInterceptorChain chain = new PhaseInterceptorChain(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases());
        chain.setFaultObserver(endpoint.getOutFaultObserver());
        if (inMessage instanceof SoapMessage) {
            try {
                this.reserialize((SoapMessage)inMessage);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to reserialize soap message", e);
            }
        }
        chain.add((Interceptor)new ServiceInvokerInterceptor());
        chain.add((Interceptor)new OutgoingChainInterceptor());
        chain.add((Interceptor)new WrapperClassInInterceptor());
        chain.add((Interceptor)new HolderInInterceptor());
        chain.add((Interceptor)new MustUnderstandInterceptor());
        chain.add((Interceptor)new LogicalHandlerInInterceptor(binding));
        chain.add((Interceptor)new SOAPHandlerInterceptor(binding));
        EJBInterceptor.copyDataBindingInterceptors(chain, inMessage.getInterceptorChain());
        InterceptorChain oldChain = inMessage.getInterceptorChain();
        inMessage.setInterceptorChain((InterceptorChain)chain);
        try {
            chain.doIntercept(inMessage);
        }
        finally {
            inMessage.setInterceptorChain(oldChain);
        }
        Object result = this.getResult();
        return result;
    }

    private Object getResult() {
        Message outMessage = this.exchange.getOutMessage();
        if (outMessage == null) {
            return null;
        }
        List result = (List)outMessage.getContent(List.class);
        if (result == null) {
            return outMessage.get(Object.class);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    private void reserialize(SoapMessage message) throws Exception {
        SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
        if (soapMessage == null) {
            return;
        }
        DOMSource bodySource = new DOMSource((Node)soapMessage.getSOAPPart());
        XMLStreamReader xmlReader = StaxUtils.createXMLStreamReader((Source)bodySource);
        message.setContent(XMLStreamReader.class, (Object)xmlReader);
    }
}

