/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.ejb;

import java.net.URL;
import javax.naming.Context;
import org.apache.cxf.Bus;
import org.apache.geronimo.cxf.CXFCatalogUtils;
import org.apache.geronimo.cxf.CXFWebServiceContainer;
import org.apache.geronimo.cxf.ejb.EJBWebServiceContainer;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.ServerJNDIResolver;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.openejb.DeploymentInfo;

public class EJBWebServiceGBean
implements GBeanLifecycle {
    private SoapHandler soapHandler;
    private String location;
    private EJBWebServiceContainer container;
    public static final GBeanInfo GBEAN_INFO;

    public EJBWebServiceGBean(EjbDeployment ejbDeploymentContext, PortInfo portInfo, Kernel kernel, URL configurationBaseUrl, SoapHandler soapHandler, String securityRealmName, String realmName, String transportGuarantee, String authMethod, String[] virtualHosts) throws Exception {
        if (ejbDeploymentContext == null || soapHandler == null || portInfo == null) {
            return;
        }
        this.soapHandler = soapHandler;
        this.location = portInfo.getLocation();
        assert (this.location != null) : "null location received";
        Class beanClass = ejbDeploymentContext.getBeanClass();
        Context context = ejbDeploymentContext.getComponentContext();
        Bus bus = CXFWebServiceContainer.getBus();
        bus.setExtension((Object)new ServerJNDIResolver(context), JNDIResolver.class);
        bus.setExtension((Object)portInfo, PortInfo.class);
        bus.setExtension((Object)ejbDeploymentContext.getDeploymentInfo(), DeploymentInfo.class);
        CXFCatalogUtils.loadOASISCatalog((Bus)bus, (URL)configurationBaseUrl, (String)"META-INF/jax-ws-catalog.xml");
        this.container = new EJBWebServiceContainer(bus, configurationBaseUrl, beanClass);
        ClassLoader classLoader = ejbDeploymentContext.getClassLoader();
        if (soapHandler != null) {
            soapHandler.addWebService(this.location, virtualHosts, (WebServiceContainer)this.container, securityRealmName, realmName, transportGuarantee, authMethod, classLoader);
        }
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        if (this.soapHandler != null) {
            this.soapHandler.removeWebService(this.location);
        }
        if (this.container != null) {
            this.container.destroy();
        }
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EJBWebServiceGBean.class, EJBWebServiceGBean.class, (String)"WSLink");
        infoFactory.addReference("EjbDeployment", EjbDeployment.class);
        infoFactory.addAttribute("portInfo", PortInfo.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("configurationBaseUrl", URL.class, true);
        infoFactory.addAttribute("securityRealmName", String.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("transportGuarantee", String.class, true);
        infoFactory.addAttribute("authMethod", String.class, true);
        infoFactory.addAttribute("virtualHosts", String[].class, true);
        infoFactory.addReference("WebServiceContainer", SoapHandler.class);
        infoFactory.setConstructor(new String[]{"EjbDeployment", "portInfo", "kernel", "configurationBaseUrl", "WebServiceContainer", "securityRealmName", "realmName", "transportGuarantee", "authMethod", "virtualHosts"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

