/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.builder;

import java.util.Collection;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.cxf.pojo.POJOWebServiceContainerFactoryGBean;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.JAXWSBuilderUtils;
import org.apache.geronimo.jaxws.builder.JAXWSServiceBuilder;
import org.apache.geronimo.jaxws.builder.WARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.wsdl.WsdlGenerator;
import org.apache.geronimo.jaxws.builder.wsdl.WsdlGeneratorOptions;
import org.apache.geronimo.kernel.repository.Environment;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFBuilder
extends JAXWSServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CXFBuilder.class);
    private static final boolean ignoreEmptyWebServiceProviderWSDL = Boolean.getBoolean("org.apache.geronimo.webservice.provider.wsdl.ignore");
    private static final String USE_WSGEN_PROPERTY = "org.apache.geronimo.cxf.use.wsgen";
    protected Collection<WsdlGenerator> wsdlGenerators;
    public static final GBeanInfo GBEAN_INFO;

    public CXFBuilder() {
        super(null);
    }

    public CXFBuilder(Environment defaultEnvironment, Collection<WsdlGenerator> wsdlGenerators) {
        super(defaultEnvironment);
        this.wsdlGenerators = wsdlGenerators;
        this.webServiceFinder = new WARWebServiceFinder();
    }

    protected GBeanInfo getContainerFactoryGBeanInfo() {
        return POJOWebServiceContainerFactoryGBean.GBEAN_INFO;
    }

    protected void initialize(GBeanData targetGBean, Class serviceClass, PortInfo portInfo, Module module, Bundle bundle) throws DeploymentException {
        if (Boolean.getBoolean(USE_WSGEN_PROPERTY)) {
            this.generateWSDL(serviceClass, portInfo, module, bundle);
        }
    }

    protected WsdlGenerator getWsdlGenerator() throws DeploymentException {
        if (this.wsdlGenerators == null || this.wsdlGenerators.isEmpty()) {
            throw new DeploymentException("Wsdl generator not found");
        }
        return this.wsdlGenerators.iterator().next();
    }

    private void generateWSDL(Class serviceClass, PortInfo portInfo, Module module, Bundle bundle) throws DeploymentException {
        String serviceName = portInfo.getServiceName() == null ? serviceClass.getName() : portInfo.getServiceName();
        String wsdlFile = portInfo.getWsdlFile();
        if (this.isWsdlSet(portInfo, serviceClass, bundle)) {
            portInfo.setWsdlFile(JAXWSBuilderUtils.normalizeWsdlPath((Module)module, (String)wsdlFile));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service " + serviceName + " has WSDL.");
            }
            return;
        }
        if (this.isHTTPBinding(portInfo, serviceClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service " + serviceName + " has HTTPBinding.");
            }
            return;
        }
        if (JAXWSUtils.isWebServiceProvider((Class)serviceClass)) {
            if (ignoreEmptyWebServiceProviderWSDL) {
                LOG.warn("WSDL is not specified for @WebServiceProvider service " + serviceName);
                return;
            }
            throw new DeploymentException("WSDL must be specified for @WebServiceProvider service " + serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service " + serviceName + " does not have WSDL. Generating WSDL...");
        }
        WsdlGenerator wsdlGenerator = this.getWsdlGenerator();
        WsdlGeneratorOptions options = new WsdlGeneratorOptions();
        options.setSAAJ(WsdlGeneratorOptions.SAAJ.SUN);
        JaxWsImplementorInfo serviceInfo = new JaxWsImplementorInfo(serviceClass);
        if (portInfo.getWsdlService() == null) {
            options.setWsdlService(serviceInfo.getServiceName());
        } else {
            options.setWsdlService(portInfo.getWsdlService());
        }
        if (portInfo.getWsdlPort() != null) {
            options.setWsdlPort(portInfo.getWsdlPort());
        }
        wsdlFile = wsdlGenerator.generateWsdl(module, serviceClass.getName(), (DeploymentContext)module.getEarContext(), options);
        portInfo.setWsdlFile(wsdlFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + wsdlFile + " for service " + serviceName);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(CXFBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(WebServiceBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addReference("WsdlGenerator", WsdlGenerator.class, "GBean");
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "WsdlGenerator"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

