/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.builder;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.cxf.jaxws.javaee.PortComponentType;
import org.apache.cxf.jaxws.javaee.ServiceImplBeanType;
import org.apache.cxf.jaxws.javaee.WebserviceDescriptionType;
import org.apache.cxf.jaxws.javaee.WebservicesType;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.cxf.pojo.POJOWebServiceContainerFactoryGBean;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.JAXWSServiceBuilder;
import org.apache.geronimo.jaxws.builder.WARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.WsdlGenerator;
import org.apache.geronimo.kernel.repository.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFBuilder
extends JAXWSServiceBuilder {
    private static final Log LOG = LogFactory.getLog(CXFBuilder.class);
    private static final String USE_WSGEN_PROPERTY = "org.apache.geronimo.cxf.use.wsgen";
    public static final GBeanInfo GBEAN_INFO;

    public CXFBuilder() {
        super(null);
    }

    public CXFBuilder(Environment defaultEnvironment) {
        super(defaultEnvironment);
        this.webServiceFinder = new WARWebServiceFinder();
    }

    protected GBeanInfo getContainerFactoryGBeanInfo() {
        return POJOWebServiceContainerFactoryGBean.GBEAN_INFO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, PortInfo> parseWebServiceDescriptor(InputStream in, URL wsDDUrl, JarFile moduleFile, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        LOG.debug((Object)("Parsing descriptor " + wsDDUrl));
        HashMap<String, PortInfo> map = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{WebservicesType.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            Object obj = unmarshaller.unmarshal((Source)new StreamSource(in), WebservicesType.class);
            if (obj instanceof JAXBElement) {
                obj = obj.getValue();
            }
            if (!(obj instanceof WebservicesType)) {
                HashMap<String, PortInfo> hashMap2 = map;
                return hashMap2;
            }
            WebservicesType wst = (WebservicesType)obj;
            for (WebserviceDescriptionType desc : wst.getWebserviceDescription()) {
                String wsdlFile = null;
                if (desc.getWsdlFile() != null) {
                    wsdlFile = CXFBuilder.getString(desc.getWsdlFile().getValue());
                }
                String serviceName = desc.getWebserviceDescriptionName().getValue();
                for (PortComponentType port : desc.getPortComponent()) {
                    PortInfo portInfo = new PortInfo();
                    String serviceLink = null;
                    ServiceImplBeanType beanType = port.getServiceImplBean();
                    if (beanType.getEjbLink() != null) {
                        serviceLink = beanType.getEjbLink().getValue();
                    } else if (beanType.getServletLink().getValue() != null) {
                        serviceLink = beanType.getServletLink().getValue();
                    }
                    portInfo.setServiceLink(serviceLink);
                    if (port.getServiceEndpointInterface() != null) {
                        String sei = port.getServiceEndpointInterface().getValue();
                        portInfo.setServiceEndpointInterfaceName(sei);
                    }
                    String portName = port.getPortComponentName().getValue();
                    portInfo.setPortName(portName);
                    portInfo.setProtocolBinding(port.getProtocolBinding());
                    portInfo.setServiceName(serviceName);
                    portInfo.setWsdlFile(wsdlFile);
                    if (port.getEnableMtom() != null) {
                        portInfo.setEnableMTOM(port.getEnableMtom().isValue());
                    }
                    portInfo.setHandlers(HandlerChainsType.class, (Object)port.getHandlerChains());
                    if (port.getWsdlPort() != null) {
                        portInfo.setWsdlPort(port.getWsdlPort().getValue());
                    }
                    if (port.getWsdlService() != null) {
                        portInfo.setWsdlService(port.getWsdlService().getValue());
                    }
                    String location = (String)correctedPortLocations.get(serviceLink);
                    portInfo.setLocation(location);
                    if (map == null) {
                        map = new HashMap<String, PortInfo>();
                    }
                    map.put(serviceLink, portInfo);
                }
            }
            HashMap<String, PortInfo> hashMap = map;
            return hashMap;
        }
        catch (FileNotFoundException e) {
            Map<String, PortInfo> map2 = Collections.emptyMap();
            return map2;
        }
        catch (IOException ex) {
            throw new DeploymentException("Unable to read " + wsDDUrl, (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new DeploymentException("Unable to parse " + wsDDUrl, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new DeploymentException("Unknown deployment error", (Throwable)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    private static String getString(String in) {
        if (in != null && (in = in.trim()).length() == 0) {
            return null;
        }
        return in;
    }

    protected void initialize(GBeanData targetGBean, Class serviceClass, PortInfo portInfo, Module module) throws DeploymentException {
        if (Boolean.getBoolean(USE_WSGEN_PROPERTY)) {
            this.generateWSDL(serviceClass, portInfo, module);
        }
    }

    private void generateWSDL(Class serviceClass, PortInfo portInfo, Module module) throws DeploymentException {
        String serviceName;
        String string = serviceName = portInfo.getServiceName() == null ? serviceClass.getName() : portInfo.getServiceName();
        if (this.isWsdlSet(portInfo, serviceClass)) {
            LOG.debug((Object)("Service " + serviceName + " has WSDL."));
            return;
        }
        if (this.isHTTPBinding(portInfo, serviceClass)) {
            LOG.debug((Object)("Service " + serviceName + " has HTTPBinding."));
            return;
        }
        if (JAXWSUtils.isWebServiceProvider((Class)serviceClass)) {
            throw new DeploymentException("WSDL must be specified for @WebServiceProvider service " + serviceName);
        }
        LOG.debug((Object)("Service " + serviceName + " does not have WSDL. Generating WSDL..."));
        WsdlGenerator generator = new WsdlGenerator();
        generator.setSunSAAJ();
        JaxWsImplementorInfo serviceInfo = new JaxWsImplementorInfo(serviceClass);
        if (portInfo.getWsdlService() == null) {
            generator.setWsdlService(serviceInfo.getServiceName());
        } else {
            generator.setWsdlService(portInfo.getWsdlService());
        }
        if (portInfo.getWsdlPort() != null) {
            generator.setWsdlPort(portInfo.getWsdlPort());
        }
        String wsdlFile = generator.generateWsdl(module, serviceClass.getName(), (DeploymentContext)module.getEarContext(), portInfo);
        portInfo.setWsdlFile(wsdlFile);
        LOG.debug((Object)("Generated " + wsdlFile + " for service " + serviceName));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(CXFBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(WebServiceBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

