/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.converter.jboss;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.converter.AbstractDatabasePool;
import org.apache.geronimo.converter.DOMUtils;
import org.apache.geronimo.converter.DatabaseConversionStatus;
import org.apache.geronimo.converter.JDBCPool;
import org.apache.geronimo.converter.XADatabasePool;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBoss4DatabaseConverter
extends DOMUtils {
    public static DatabaseConversionStatus convert(Reader dsXml) throws IOException {
        ArrayList status = new ArrayList();
        ArrayList noTx = new ArrayList();
        ArrayList local = new ArrayList();
        ArrayList xa = new ArrayList();
        DocumentBuilderFactory factory = XmlUtil.newDocumentBuilderFactory();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(dsXml));
            dsXml.close();
            JBoss4DatabaseConverter.parseDocument(doc, status, noTx, local, xa);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        DatabaseConversionStatus result = new DatabaseConversionStatus();
        result.setMessages(status.toArray(new String[status.size()]));
        result.setNoTXPools(noTx.toArray(new JDBCPool[noTx.size()]));
        result.setJdbcPools(local.toArray(new JDBCPool[noTx.size()]));
        result.setXaPools(xa.toArray(new XADatabasePool[xa.size()]));
        return result;
    }

    private static void parseDocument(Document doc, List status, List noTx, List local, List xa) {
        Element datasources = doc.getDocumentElement();
        if (!datasources.getNodeName().equalsIgnoreCase("datasources")) {
            if (datasources.getNodeName().equals("connection-factories")) {
                status.add("ERROR: Geronimo cannot parse a JBoss data source configured using conection-factories.  This typically means a custom RAR file is required.");
                return;
            }
            status.add("ERROR: Unrecognized file beginning with " + datasources.getNodeName() + " element.  Expected a JBoss *-ds.xml file.");
            return;
        }
        NodeList list = datasources.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.equalsIgnoreCase("no-tx-datasource")) {
                JBoss4DatabaseConverter.addJDBCDataSource((Element)node, status, noTx);
                continue;
            }
            if (name.equalsIgnoreCase("local-tx-datasource")) {
                JBoss4DatabaseConverter.addJDBCDataSource((Element)node, status, local);
                continue;
            }
            if (name.equalsIgnoreCase("xa-datasource")) {
                JBoss4DatabaseConverter.addXADataSource((Element)node, status, xa);
                continue;
            }
            if (name.equalsIgnoreCase("mbean")) {
                status.add("Skipping MBean element");
                continue;
            }
            status.add("WARN: Skipped element " + name);
        }
    }

    private static void addDataSourceCommon(Element root, AbstractDatabasePool pool, List status) {
        String test;
        pool.setJndiName(JBoss4DatabaseConverter.getChildText(root, "jndi-name"));
        pool.setName(pool.getJndiName());
        if (pool.getJndiName() != null && pool.getJndiName().indexOf(47) > -1) {
            status.add("NOTE: pool will use name '" + pool.getJndiName() + "' though Geronimo doesn't put it in JNDI");
        }
        if ((test = JBoss4DatabaseConverter.getChildText(root, "min-pool-size")) != null && !test.equals("")) {
            pool.setMinSize(new Integer(test));
        }
        if ((test = JBoss4DatabaseConverter.getChildText(root, "max-pool-size")) != null && !test.equals("")) {
            pool.setMaxSize(new Integer(test));
        }
        if ((test = JBoss4DatabaseConverter.getChildText(root, "blocking-timeout-millis")) != null && !test.equals("")) {
            pool.setBlockingTimeoutMillis(new Integer(test));
        }
        if ((test = JBoss4DatabaseConverter.getChildText(root, "idle-timeout-minutes")) != null && !test.equals("")) {
            pool.setIdleTimeoutMillis(new Integer(Integer.parseInt(test) * 60 * 1000));
        }
        pool.setNewConnectionSQL(JBoss4DatabaseConverter.getChildText(root, "new-connection-sql"));
        pool.setTestConnectionSQL(JBoss4DatabaseConverter.getChildText(root, "check-valid-connection-sql"));
        String sorter = JBoss4DatabaseConverter.getChildText(root, "exception-sorter-class-name");
        if (sorter != null) {
            if (sorter.indexOf("Oracle") > -1) {
                pool.setVendor("Oracle");
            }
            if (sorter.indexOf("MySQL") > -1) {
                pool.setVendor("MySQL");
            }
            if (sorter.indexOf("Sybase") > -1) {
                pool.setVendor("Sybase");
            }
            if (sorter.indexOf("Informix") > -1) {
                pool.setVendor("Informix");
            }
        }
        if ((test = JBoss4DatabaseConverter.getChildText(root, "prepared-statement-cache-size")) != null && !test.equals("")) {
            pool.setStatementCacheSize(new Integer(test));
        }
    }

    private static void addJDBCDataSource(Element root, List status, List results) {
        JDBCPool pool = new JDBCPool();
        JBoss4DatabaseConverter.addDataSourceCommon(root, pool, status);
        pool.setJdbcURL(JBoss4DatabaseConverter.getChildText(root, "connection-url"));
        pool.setDriverClass(JBoss4DatabaseConverter.getChildText(root, "driver-class"));
        NodeList list = root.getElementsByTagName("connection-property");
        for (int i = 0; i < list.getLength(); ++i) {
            Element prop = (Element)list.item(i);
            pool.getConnectionProperties().setProperty(prop.getAttribute("name"), JBoss4DatabaseConverter.getText(prop));
        }
        pool.setUsername(JBoss4DatabaseConverter.getChildText(root, "user-name"));
        pool.setPassword(JBoss4DatabaseConverter.getChildText(root, "password"));
        if (pool.getName() != null && !pool.getName().equals("")) {
            results.add(pool);
        } else {
            status.add("WARN: Ignoring pool with no JNDI name");
        }
    }

    private static void addXADataSource(Element root, List status, List results) {
        XADatabasePool pool = new XADatabasePool();
        JBoss4DatabaseConverter.addDataSourceCommon(root, pool, status);
        pool.setXaDataSourceClass(JBoss4DatabaseConverter.getChildText(root, "xa-datasource-class"));
        NodeList list = root.getElementsByTagName("xa-datasource-property");
        for (int i = 0; i < list.getLength(); ++i) {
            Element prop = (Element)list.item(i);
            pool.getProperties().setProperty(prop.getAttribute("name"), JBoss4DatabaseConverter.getText(prop));
        }
        if (pool.getName() != null && !pool.getName().equals("")) {
            results.add(pool);
        } else {
            status.add("WARN: Ignoring pool with no JNDI name");
        }
    }
}

