/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.thread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.concurrent.ManagedContext;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactory;
import org.apache.geronimo.concurrent.impl.thread.TrackingManagedThreadFactory;
import org.apache.geronimo.concurrent.thread.ManagedRunnable;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;

public class StandaloneManagedThreadFactory
extends TrackingManagedThreadFactory {
    private ManagedContextHandler contextHandler;
    private ModuleLifecycleListener moduleLifecyleListener;
    private ManagedContext managedContext;

    public StandaloneManagedThreadFactory(GeronimoManagedThreadFactory threadFactory, ManagedContextHandler contextHandler, AbstractName moduleName) {
        super(threadFactory);
        this.contextHandler = contextHandler;
        this.moduleLifecyleListener = ModuleLifecycleListener.getModuleLifecycleListener(moduleName);
        this.moduleLifecyleListener.addThreadFactory(this);
        this.managedContext = ManagedContext.captureContext((ManagedContextHandler)this.contextHandler);
    }

    public Thread newThread(Runnable runnable) {
        if (!this.isRunning()) {
            throw new IllegalArgumentException("Component that created this thread factory is no longer running");
        }
        ManagedRunnable managedRunnable = new ManagedRunnable(runnable, this.managedContext, true);
        Thread thread = super.newThread((Runnable)managedRunnable);
        return thread;
    }

    protected boolean isRunning() {
        return this.moduleLifecyleListener.isRunning();
    }

    protected void shutdown() {
        this.interruptThreads();
    }

    private static class ModuleLifecycleListener
    implements LifecycleListener {
        private static final Map<AbstractName, ModuleLifecycleListener> listeners = new HashMap<AbstractName, ModuleLifecycleListener>();
        private final AbstractName moduleName;
        private boolean running;
        private final List<StandaloneManagedThreadFactory> threadFactories = new ArrayList<StandaloneManagedThreadFactory>();

        public ModuleLifecycleListener(AbstractName moduleName) {
            this.moduleName = moduleName;
            this.running = true;
        }

        public synchronized void addThreadFactory(StandaloneManagedThreadFactory threadFactory) {
            if (this.running) {
                this.threadFactories.add(threadFactory);
            }
        }

        public synchronized void shutdown() {
            for (StandaloneManagedThreadFactory threadFactory : this.threadFactories) {
                try {
                    threadFactory.shutdown();
                }
                catch (Exception exception) {}
            }
            this.threadFactories.clear();
        }

        public boolean isRunning() {
            return this.running;
        }

        public AbstractName getModuleName() {
            return this.moduleName;
        }

        public void failed(AbstractName arg0) {
            this.running = false;
        }

        public void loaded(AbstractName arg0) {
            this.running = false;
        }

        public void running(AbstractName arg0) {
            this.running = true;
        }

        public void starting(AbstractName arg0) {
            this.running = false;
        }

        public void stopped(AbstractName arg0) {
            this.running = false;
        }

        public void stopping(AbstractName arg0) {
            this.running = false;
            this.shutdown();
        }

        public void unloaded(AbstractName arg0) {
            this.running = false;
            this.shutdown();
            ModuleLifecycleListener.removeModuleLifecycleListener(this.moduleName);
        }

        private static synchronized ModuleLifecycleListener getModuleLifecycleListener(AbstractName moduleName) {
            ModuleLifecycleListener listener = listeners.get(moduleName);
            if (listener == null) {
                listener = new ModuleLifecycleListener(moduleName);
                AbstractNameQuery query = new AbstractNameQuery(moduleName);
                Kernel kernel = KernelRegistry.getSingleKernel();
                kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)listener, query);
                listeners.put(moduleName, listener);
            }
            return listener;
        }

        private static synchronized void removeModuleLifecycleListener(AbstractName moduleName) {
            listeners.remove(moduleName);
        }
    }
}

