/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.handlers;

import java.util.Map;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.impl.handlers.UserTransactionContext;
import org.apache.geronimo.naming.java.RootContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingContextHandler
implements ManagedContextHandler {
    private static final Log LOG = LogFactory.getLog(NamingContextHandler.class);
    private static final String OLD_CONTEXT = NamingContextHandler.class.getName() + ".oldContext";
    private static final String NEW_CONTEXT = NamingContextHandler.class.getName() + ".newContext";

    public void saveContext(Map<String, Object> context) {
        LOG.debug((Object)"saveContext");
        Object componentContext = RootContext.getComponentContext();
        if (!UserTransactionContext.hasUserTransaction(componentContext)) {
            componentContext = new UserTransactionContext((Context)componentContext);
            LOG.debug((Object)"java:comp/UserTransaction not found. Using UserTransactionContext");
        }
        context.put(NEW_CONTEXT, componentContext);
    }

    public void setContext(Map<String, Object> threadContext) {
        LOG.debug((Object)"setContext");
        threadContext.put(OLD_CONTEXT, RootContext.getComponentContext());
        Context context = (Context)threadContext.get(NEW_CONTEXT);
        RootContext.setComponentContext((Context)context);
    }

    public void unsetContext(Map<String, Object> threadContext) {
        LOG.debug((Object)"unsetContext");
        Context context = (Context)threadContext.get(OLD_CONTEXT);
        RootContext.setComponentContext((Context)context);
    }
}

