/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.io.Serializable;
import java.net.URI;

public class WADISessionManagerConfigInfo
implements Serializable {
    private final URI serviceSpaceURI;
    private final int sweepInterval;
    private final int numPartitions;
    private final int sessionTimeoutSeconds;

    public WADISessionManagerConfigInfo(URI serviceSpaceURI, int sweepInterval, int numPartitions, int sessionTimeoutSeconds) {
        if (null == serviceSpaceURI) {
            throw new IllegalArgumentException("serviceSpaceURI is required");
        }
        if (1 > sweepInterval) {
            throw new IllegalArgumentException("sweepInterval must be greater than 0");
        }
        if (1 > numPartitions) {
            throw new IllegalArgumentException("numPartitions must be greater than 0");
        }
        if (1 > sessionTimeoutSeconds) {
            throw new IllegalArgumentException("sessionTimeoutSeconds must be greater than 0");
        }
        this.serviceSpaceURI = serviceSpaceURI;
        this.sweepInterval = sweepInterval;
        this.numPartitions = numPartitions;
        this.sessionTimeoutSeconds = sessionTimeoutSeconds;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public URI getServiceSpaceURI() {
        return this.serviceSpaceURI;
    }

    public int getSessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public int getSweepInterval() {
        return this.sweepInterval;
    }
}

