/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.apache.geronimo.client.AppClientContainer;
import org.apache.geronimo.client.StaticJndiContextPlugin;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.PatternType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.CorbaGBeanNameSource;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilderCollection;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApplicationClient;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.j2ee.management.impl.J2EEAppClientModuleImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.SubjectInfo;
import org.apache.geronimo.xbeans.connector.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientDocument;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientType;
import org.apache.geronimo.xbeans.geronimo.client.GerResourceType;
import org.apache.geronimo.xbeans.geronimo.security.GerSubjectInfoType;
import org.apache.geronimo.xbeans.javaee6.ApplicationClientDocument;
import org.apache.geronimo.xbeans.javaee6.ApplicationClientType;
import org.apache.geronimo.xbeans.javaee6.FullyQualifiedClassType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppClientModuleBuilder
implements ModuleBuilder,
CorbaGBeanNameSource,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(AppClientModuleBuilder.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String GERAPPCLIENT_NAMESPACE = GerApplicationClientDocument.type.getDocumentElementName().getNamespaceURI();
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private final Environment defaultClientEnvironment;
    private final Environment defaultServerEnvironment;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery credentialStoreName;
    private final SingleElementCollection connectorModuleBuilder;
    private final NamespaceDrivenBuilderCollection serviceBuilder;
    private final NamingBuilderCollection namingBuilders;
    private final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private final Collection<Repository> repositories;
    private final ArtifactResolver clientArtifactResolver;
    public static final GBeanInfo GBEAN_INFO;

    public AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, AbstractNameQuery credentialStoreName, Collection<Repository> repositories, ModuleBuilder connectorModuleBuilder, NamespaceDrivenBuilder serviceBuilder, Collection<NamingBuilder> namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ArtifactResolver clientArtifactResolver) {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, credentialStoreName, repositories, (SingleElementCollection<ModuleBuilder>)new SingleElementCollection((Object)connectorModuleBuilder), serviceBuilder == null ? Collections.emptySet() : Collections.singleton(serviceBuilder), namingBuilders == null ? Collections.emptySet() : namingBuilders, moduleBuilderExtensions, clientArtifactResolver);
    }

    public AppClientModuleBuilder(AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, AbstractNameQuery credentialStoreName, Collection<Repository> repositories, Collection<ModuleBuilder> connectorModuleBuilder, Collection<NamespaceDrivenBuilder> serviceBuilder, Collection<NamingBuilder> namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ArtifactResolver clientArtifactResolver, Environment defaultClientEnvironment, Environment defaultServerEnvironment) {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, credentialStoreName, repositories, (SingleElementCollection<ModuleBuilder>)new SingleElementCollection(connectorModuleBuilder), serviceBuilder, namingBuilders, moduleBuilderExtensions, clientArtifactResolver);
    }

    private AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, AbstractNameQuery credentialStoreName, Collection<Repository> repositories, SingleElementCollection<ModuleBuilder> connectorModuleBuilder, Collection<NamespaceDrivenBuilder> serviceBuilder, Collection<NamingBuilder> namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ArtifactResolver clientArtifactResolver) {
        this.defaultClientEnvironment = defaultClientEnvironment;
        this.defaultServerEnvironment = defaultServerEnvironment;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.credentialStoreName = credentialStoreName;
        this.repositories = repositories;
        this.connectorModuleBuilder = connectorModuleBuilder;
        this.serviceBuilder = new NamespaceDrivenBuilderCollection(serviceBuilder);
        this.namingBuilders = new NamingBuilderCollection(namingBuilders);
        this.moduleBuilderExtensions = moduleBuilderExtensions;
        this.clientArtifactResolver = clientArtifactResolver;
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    public AbstractNameQuery getCorbaGBeanName() {
        return this.corbaGBeanObjectName;
    }

    private ModuleBuilder getConnectorModuleBuilder() {
        return (ModuleBuilder)this.connectorModuleBuilder.getElement();
    }

    public Module createModule(Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return null;
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, "app-client.jar", null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, earName, naming, idBuilder);
    }

    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        GerResourceType[] resources;
        ApplicationClientDocument appClientDoc;
        String specDD;
        String mainClass;
        assert (moduleFile != null) : "moduleFile is null";
        assert (targetPath != null) : "targetPath is null";
        assert (!targetPath.endsWith("/")) : "targetPath must not end with a '/'";
        assert (earName == null == (earEnvironment == null)) : "if earName is not null you must supply earEnvironment as well";
        boolean standAlone = earEnvironment == null;
        try {
            Manifest manifest = moduleFile.getManifest();
            if (manifest == null) {
                return null;
            }
            mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (mainClass == null) {
                return null;
            }
            String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (standAlone && classPath != null) {
                throw new DeploymentException("Manifest class path entry is not allowed in a standalone jar (JAVAEE 5 Section 8.2)");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not get manifest from app client module: " + moduleFile.getName(), (Throwable)e);
        }
        ApplicationClientType appClient = null;
        try {
            if (specDDUrl == null) {
                specDDUrl = JarUtils.createJarURL((JarFile)moduleFile, (String)"META-INF/application-client.xml");
            }
            specDD = JarUtils.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            appClientDoc = ApplicationClientDocument.Factory.newInstance();
            appClientDoc.addNewApplicationClient();
            appClient = appClientDoc.getApplicationClient();
            specDD = appClientDoc.xmlText();
        }
        if (appClient == null) {
            try {
                XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
                appClientDoc = AppClientModuleBuilder.convertToApplicationClientSchema(xmlObject);
                appClient = appClientDoc.getApplicationClient();
            }
            catch (XmlException e) {
                throw new DeploymentException("Unable to parse application-client.xml", (Throwable)e);
            }
        }
        GerApplicationClientType gerAppClient = this.getGeronimoAppClient(plan, moduleFile, standAlone, targetPath, appClient, earEnvironment);
        EnvironmentType clientEnvironmentType = gerAppClient.getClientEnvironment();
        Environment clientEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)clientEnvironmentType, (Environment)this.defaultClientEnvironment);
        if (standAlone) {
            String name = new File(moduleFile.getName()).getName();
            idBuilder.resolve(clientEnvironment, name + "_" + name, "car");
        } else {
            Artifact earConfigId = earEnvironment.getConfigId();
            idBuilder.resolve(clientEnvironment, earConfigId.getArtifactId() + "_" + targetPath, "car");
        }
        EnvironmentType serverEnvironmentType = gerAppClient.getServerEnvironment();
        Environment serverEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)serverEnvironmentType, (Environment)this.defaultServerEnvironment);
        if (!standAlone) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)serverEnvironment);
            serverEnvironment = earEnvironment;
            if (!serverEnvironment.getConfigId().isResolved()) {
                throw new IllegalStateException("Server environment module ID should be fully resolved (not " + serverEnvironment.getConfigId() + ")");
            }
        } else {
            idBuilder.resolve(serverEnvironment, new File(moduleFile.getName()).getName(), "car");
        }
        if (earName == null) {
            earName = naming.createRootName(serverEnvironment.getConfigId(), "null", "J2EEApplication");
        }
        AbstractName moduleName = naming.createChildName(earName, clientEnvironment.getConfigId().toString(), "AppClientModule");
        AbstractName clientBaseName = naming.createRootName(clientEnvironment.getConfigId(), clientEnvironment.getConfigId().toString(), "J2EEApplication");
        ArrayList<ConnectorModule> resourceModules = new ArrayList<ConnectorModule>();
        for (GerResourceType resource : resources = gerAppClient.getResourceArray()) {
            String path;
            Object connectorFile;
            if (resource.isSetExternalRar()) {
                PatternType externalRar = resource.getExternalRar();
                String groupId = this.trim(externalRar.getGroupId());
                String artifactId = this.trim(externalRar.getArtifactId());
                String version = this.trim(externalRar.getVersion());
                String type = this.trim(externalRar.getType());
                Artifact artifact = new Artifact(groupId, artifactId, version, type);
                try {
                    artifact = this.clientArtifactResolver.resolveInClassLoader(artifact);
                }
                catch (MissingDependencyException e) {
                    throw new DeploymentException("Could not resolve external rar location in repository: " + artifact, (Throwable)e);
                }
                File file = null;
                for (Repository repository : this.repositories) {
                    if (!repository.contains(artifact)) continue;
                    file = repository.getLocation(artifact);
                    break;
                }
                if (file == null) {
                    throw new DeploymentException("Missing external rar in repositories: " + artifact);
                }
                try {
                    connectorFile = new JarFile(file);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access external rar contents for artifact: " + artifact, (Throwable)e);
                }
                path = artifact.toString();
            } else {
                path = resource.getInternalRar();
                try {
                    connectorFile = new NestedJarFile(moduleFile, path);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not locate connector inside ear", (Throwable)e);
                }
            }
            GerConnectorType connectorPlan = resource.getConnector();
            ConnectorModule connectorModule = (ConnectorModule)this.getConnectorModuleBuilder().createModule((Object)connectorPlan, (JarFile)connectorFile, path, null, clientEnvironment, null, clientBaseName, naming, idBuilder);
            resourceModules.add(connectorModule);
        }
        AnnotatedApplicationClient annotatedApplicationClient = new AnnotatedApplicationClient(appClient, mainClass);
        String name = null;
        name = appClient.isSetModuleName() ? appClient.getModuleName().getStringValue().trim() : (standAlone ? FileUtils.removeExtension((String)new File(moduleFile.getName()).getName(), (String)".jar") : FileUtils.removeExtension((String)targetPath, (String)".jar"));
        AppClientModule module = new AppClientModule(standAlone, moduleName, name, clientBaseName, serverEnvironment, clientEnvironment, moduleFile, targetPath, (XmlObject)appClient, mainClass, (XmlObject)gerAppClient, specDD, resourceModules, annotatedApplicationClient);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, clientEnvironment, null, earName, naming, idBuilder);
        }
        if (standAlone) {
            ApplicationInfo appInfo = new ApplicationInfo(ConfigurationModuleType.CAR, serverEnvironment, earName, name, null, null, null, new LinkedHashSet<AppClientModule>(Collections.singleton(module)), new ModuleList(), null);
            return appInfo;
        }
        return module;
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    GerApplicationClientType getGeronimoAppClient(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, ApplicationClientType appClient, Environment environment) throws DeploymentException {
        GerApplicationClientType gerAppClient;
        XmlObject rawPlan = null;
        try {
            Object path;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((File)((File)plan));
                } else {
                    path = JarUtils.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-application-client.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (rawPlan != null) {
                gerAppClient = (GerApplicationClientType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)GerApplicationClientDocument.type.getDocumentElementName(), (SchemaType)GerApplicationClientType.type);
            } else {
                path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                gerAppClient = this.createDefaultPlan((String)path, appClient, standAlone, environment);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException("Unable to parse application plan", (Throwable)e);
        }
        return gerAppClient;
    }

    private GerApplicationClientType createDefaultPlan(String name, ApplicationClientType appClient, boolean standAlone, Environment environment) {
        String id;
        String string = id = appClient == null ? null : appClient.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        GerApplicationClientType geronimoAppClient = GerApplicationClientType.Factory.newInstance();
        EnvironmentType clientEnvironmentType = geronimoAppClient.addNewClientEnvironment();
        EnvironmentType serverEnvironmentType = geronimoAppClient.addNewServerEnvironment();
        return geronimoAppClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApplicationClientDocument convertToApplicationClientSchema(XmlObject xmlObject) throws XmlException {
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/javaee/application-client_6.xsd";
        String version = "6";
        try {
            cursor.toStartDoc();
            cursor.toFirstChild();
            if ("http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI())) {
                SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                XmlObject result = xmlObject.changeType(ApplicationClientDocument.type);
                XmlBeansUtil.validateDD((XmlObject)result);
                ApplicationClientDocument applicationClientDocument = (ApplicationClientDocument)result;
                return applicationClientDocument;
            }
            if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                XmlObject result = xmlObject.changeType(ApplicationClientDocument.type);
                XmlBeansUtil.validateDD((XmlObject)result);
                ApplicationClientDocument applicationClientDocument = (ApplicationClientDocument)result;
                return applicationClientDocument;
            }
            SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
            cursor.toStartDoc();
            cursor.toChild("http://java.sun.com/xml/ns/javaee", "application-client");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
            XmlObject result = xmlObject.changeType(ApplicationClientDocument.type);
            if (result != null) {
                XmlBeansUtil.validateDD((XmlObject)result);
                ApplicationClientDocument applicationClientDocument = (ApplicationClientDocument)result;
                return applicationClientDocument;
            }
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
            ApplicationClientDocument applicationClientDocument = (ApplicationClientDocument)xmlObject;
            return applicationClientDocument;
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        EARContext appClientDeploymentContext;
        File appClientDir;
        JarFile moduleFile = module.getModuleFile();
        try {
            earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName(), (Throwable)e);
        }
        AppClientModule appClientModule = (AppClientModule)module;
        appClientModule.setEarFile(earFile);
        Environment clientEnvironment = appClientModule.getEnvironment();
        try {
            appClientDir = targetConfigurationStore.createNewConfigurationDir(clientEnvironment.getConfigId());
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException("Unable to create configuration directory for " + clientEnvironment.getConfigId(), (Throwable)e);
        }
        try {
            appClientDeploymentContext = new EARContext(appClientDir, null, clientEnvironment, ConfigurationModuleType.CAR, appClientModule.getAppClientName(), this.transactionManagerObjectName, this.connectionTrackerObjectName, this.corbaGBeanObjectName, earContext);
            appClientModule.setEarContext(appClientDeploymentContext);
            appClientModule.setRootEarContext(appClientDeploymentContext);
            try {
                appClientDeploymentContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName(), (Throwable)e);
            }
            ClassPathList libClasspath = (ClassPathList)EARContext.CLASS_PATH_LIST_KEY.get(earContext.getGeneralData());
            if (libClasspath != null) {
                for (String libEntryPath : libClasspath) {
                    try {
                        NestedJarFile library = new NestedJarFile(earFile, libEntryPath);
                        appClientDeploymentContext.addIncludeAsPackedJar(URI.create(libEntryPath), (JarFile)library);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Could not add to app client library classpath: " + libEntryPath, (Throwable)e);
                    }
                }
            }
        }
        catch (DeploymentException e) {
            this.cleanupAppClientDir(appClientDir);
            throw e;
        }
        for (ConnectorModule connectorModule : appClientModule.getResourceModules()) {
            this.getConnectorModuleBuilder().installModule(connectorModule.getModuleFile(), appClientDeploymentContext, (Module)connectorModule, configurationStores, targetConfigurationStore, repositories);
        }
        Iterator<Object> i$ = this.moduleBuilderExtensions.iterator();
        while (i$.hasNext()) {
            ModuleBuilderExtension mbe = (ModuleBuilderExtension)i$.next();
            mbe.installModule(module.getModuleFile(), appClientDeploymentContext, module, configurationStores, targetConfigurationStore, repositories);
        }
        return;
    }

    public void initContext(EARContext earContext, Module clientModule, Bundle bundle) throws DeploymentException {
        AppClientModule appClientModule = (AppClientModule)clientModule;
        this.namingBuilders.buildEnvironment((XmlObject)appClientModule.getSpecDD(), (XmlObject)appClientModule.getVendorDD(), clientModule.getEnvironment());
        for (ConnectorModule connectorModule : appClientModule.getResourceModules()) {
            this.getConnectorModuleBuilder().initContext(appClientModule.getEarContext(), (Module)connectorModule, bundle);
        }
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.initContext(earContext, clientModule, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGBeans(EARContext earContext, Module module, Bundle earBundle, Collection repositories) throws DeploymentException {
        AppClientModule appClientModule = (AppClientModule)module;
        JarFile moduleFile = module.getModuleFile();
        ApplicationClientType appClient = (ApplicationClientType)appClientModule.getSpecDD();
        GerApplicationClientType geronimoAppClient = (GerApplicationClientType)appClientModule.getVendorDD();
        AbstractName appClientModuleName = appClientModule.getModuleName();
        GBeanData appClientModuleGBeanData = new GBeanData(appClientModuleName, J2EEAppClientModuleImpl.class);
        try {
            appClientModuleGBeanData.setReferencePattern("J2EEServer", earContext.getServerName());
            if (!module.isStandAlone()) {
                appClientModuleGBeanData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
        }
        try {
            earContext.addGBean(appClientModuleGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add application client module gbean to configuration", (Throwable)e);
        }
        EARContext appClientDeploymentContext = appClientModule.getEarContext();
        Map generalData = earContext.getGeneralData();
        for (Map.Entry entry : generalData.entrySet()) {
            EARContext.Key key = (EARContext.Key)entry.getKey();
            if (!key.getClass().getName().startsWith("org.apache.geronimo.openejb.deployment.EjbModuleBuilder$EarData")) continue;
            appClientDeploymentContext.getGeneralData().put(key, entry.getValue());
            break;
        }
        ModuleIDBuilder idBuilder = new ModuleIDBuilder();
        idBuilder.setDefaultGroup(appClientModule.getEnvironment().getConfigId().getGroupId());
        idBuilder.setDefaultVersion(appClientModule.getEnvironment().getConfigId().getVersion());
        try {
            try {
                Object holder;
                this.namingBuilders.initContext((XmlObject)appClient, (XmlObject)geronimoAppClient, (Module)appClientModule);
                URI moduleBase = new URI(appClientModule.getTargetPath());
                try {
                    appClientDeploymentContext.addIncludeAsPackedJar(moduleBase, moduleFile);
                }
                catch (IOException e) {
                    throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName(), (Throwable)e);
                }
                this.addManifestClassPath((DeploymentContext)appClientDeploymentContext, appClientModule.getEarFile(), moduleFile, moduleBase);
                Bundle appClientClassBundle = appClientDeploymentContext.getDeploymentBundle();
                if (geronimoAppClient != null) {
                    this.serviceBuilder.build((XmlObject)geronimoAppClient, (DeploymentContext)appClientDeploymentContext, (DeploymentContext)appClientDeploymentContext);
                    for (ConnectorModule connectorModule : appClientModule.getResourceModules()) {
                        this.getConnectorModuleBuilder().addGBeans(appClientDeploymentContext, (Module)connectorModule, appClientClassBundle, repositories);
                    }
                }
                AbstractName jndiContextName = earContext.getNaming().createChildName(appClientDeploymentContext.getModuleName(), "StaticJndiContext", "StaticJndiContext");
                GBeanData jndiContextGBeanData = new GBeanData(jndiContextName, StaticJndiContextPlugin.class);
                try {
                    HashMap<EARContext.Key, Object> buildingContext = new HashMap<EARContext.Key, Object>();
                    buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, jndiContextName);
                    Configuration localConfiguration = appClientDeploymentContext.getConfiguration();
                    Configuration remoteConfiguration = earContext.getConfiguration();
                    if (!appClient.getMetadataComplete()) {
                        appClientModule.setClassFinder(this.createAppClientClassFinder(appClient, appClientModule));
                    }
                    Map contexts = (Map)NamingBuilder.JNDI_KEY.get(earContext.getGeneralData());
                    HashMap<JndiKey, Map<String, Object>> clientContexts = new HashMap<JndiKey, Map<String, Object>>(contexts);
                    AppClientModuleBuilder.getJndiContext(clientContexts, JndiScope.module).put("module/ModuleName", module.getName());
                    buildingContext.put(NamingBuilder.JNDI_KEY, clientContexts);
                    this.namingBuilders.buildNaming((XmlObject)appClient, (XmlObject)geronimoAppClient, (Module)appClientModule, buildingContext);
                    if (!appClient.getMetadataComplete()) {
                        appClient.setMetadataComplete(true);
                        module.setOriginalSpecDD(module.getSpecDD().toString());
                    }
                    appClientModuleGBeanData.setAttribute("deploymentDescriptor", (Object)appClientModule.getOriginalSpecDD());
                    holder = NamingBuilder.INJECTION_KEY.get(buildingContext);
                    jndiContextGBeanData.setAttribute("context", NamingBuilder.JNDI_KEY.get(buildingContext));
                }
                catch (DeploymentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to construct jndi context for AppClientModule GBean " + appClientModule.getName(), (Throwable)e);
                }
                appClientDeploymentContext.addGBean(jndiContextGBeanData);
                AbstractName appClientContainerName = appClientDeploymentContext.getModuleName();
                GBeanData appClientContainerGBeanData = new GBeanData(appClientContainerName, AppClientContainer.class);
                try {
                    appClientContainerGBeanData.setAttribute("mainClassName", (Object)appClientModule.getMainClassName());
                    appClientContainerGBeanData.setAttribute("appClientModuleName", (Object)appClientModuleName);
                    String callbackHandlerClassName = null;
                    if (appClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = appClient.getCallbackHandler().getStringValue().trim();
                    }
                    if (geronimoAppClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = geronimoAppClient.getCallbackHandler().trim();
                    }
                    String realmName = null;
                    if (geronimoAppClient.isSetRealmName()) {
                        realmName = geronimoAppClient.getRealmName().trim();
                    }
                    if (callbackHandlerClassName != null && realmName == null) {
                        throw new DeploymentException("You must specify a realm name with the callback handler");
                    }
                    if (realmName != null) {
                        appClientContainerGBeanData.setAttribute("realmName", (Object)realmName);
                        appClientContainerGBeanData.setAttribute("callbackHandlerClassName", (Object)callbackHandlerClassName);
                    } else if (geronimoAppClient.isSetDefaultSubject()) {
                        GerSubjectInfoType subjectInfoType = geronimoAppClient.getDefaultSubject();
                        SubjectInfo subjectInfo = this.buildSubjectInfo(subjectInfoType);
                        appClientContainerGBeanData.setAttribute("defaultSubject", (Object)subjectInfo);
                        appClientContainerGBeanData.setReferencePattern("CredentialStore", this.credentialStoreName);
                    } else if (earContext.getSecurityConfiguration() != null) {
                        log.warn("Configuration of app client default subject from ear security configuration no longer supported.");
                    }
                    appClientContainerGBeanData.setReferencePattern("JNDIContext", jndiContextName);
                    appClientContainerGBeanData.setAttribute("holder", holder);
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
                }
                appClientDeploymentContext.addGBean(appClientContainerGBeanData);
                for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                    mbe.addGBeans(appClientDeploymentContext, (Module)appClientModule, appClientClassBundle, repositories);
                }
                earContext.addAdditionalDeployment(appClientDeploymentContext.getConfigurationData());
            }
            finally {
                if (appClientDeploymentContext != null) {
                    try {
                        appClientDeploymentContext.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Throwable e) {
            File appClientDir = appClientDeploymentContext.getBaseDir();
            this.cleanupAppClientDir(appClientDir);
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof Exception) {
                throw new DeploymentException(e);
            }
            throw new Error(e);
        }
    }

    private static Map<String, Object> getJndiContext(Map<JndiKey, Map<String, Object>> contexts, JndiScope scope) {
        Map<String, Object> context = contexts.get(scope);
        if (context == null) {
            context = new HashMap<String, Object>();
            contexts.put((JndiKey)scope, context);
        }
        return context;
    }

    private ClassFinder createAppClientClassFinder(ApplicationClientType appClient, AppClientModule appClientModule) throws DeploymentException {
        ArrayList<Class> classes = new ArrayList<Class>();
        Bundle bundle = appClientModule.getEarContext().getDeploymentBundle();
        String mainClass = appClientModule.getMainClassName();
        try {
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("AppClientModuleBuilder: Could not load main class: " + mainClass, (Throwable)e);
        }
        for (Class mainClas = bundle.loadClass(mainClass); mainClas != null && mainClas != Object.class; mainClas = mainClas.getSuperclass()) {
            classes.add(mainClas);
        }
        if (appClient.isSetCallbackHandler()) {
            Class clas;
            FullyQualifiedClassType cls = appClient.getCallbackHandler();
            try {
                clas = bundle.loadClass(cls.getStringValue().trim());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AppClientModuleBuilder: Could not load callback-handler class: " + cls.getStringValue(), (Throwable)e);
            }
            classes.add(clas);
        }
        return new ClassFinder(classes);
    }

    private SubjectInfo buildSubjectInfo(GerSubjectInfoType defaultSubject) {
        String realmName = defaultSubject.getRealm().trim();
        String id = defaultSubject.getId().trim();
        return new SubjectInfo(realmName, id);
    }

    public String getSchemaNamespace() {
        return GERAPPCLIENT_NAMESPACE;
    }

    public void addManifestClassPath(DeploymentContext deploymentContext, JarFile earFile, JarFile jarFile, URI jarFileLocation) throws DeploymentException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + jarFileLocation, (Throwable)e);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            JarFile classPathJarFile;
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (JAVAEE 5 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (JAVAEE 5 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            URI classPathJarLocation = jarFileLocation.resolve(pathUri);
            File classPathFile = deploymentContext.getTargetFile(classPathJarLocation);
            if (classPathFile.exists()) continue;
            ZipEntry entry = earFile.getEntry(classPathJarLocation.getPath());
            if (entry == null) {
                throw new DeploymentException("Cound not find manifest class path entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            try {
                deploymentContext.addFile(classPathJarLocation, (ZipFile)earFile, entry);
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not copy manifest class path entry into configuration: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            try {
                classPathJarFile = new JarFile(classPathFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Manifest class path entries must be a valid jar file (JAVAEE 5 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            this.addManifestClassPath(deploymentContext, earFile, classPathJarFile, classPathJarLocation);
        }
    }

    private boolean cleanupAppClientDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!FileUtils.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : ""));
            return false;
        }
        return true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client", "http://geronimo.apache.org/xml/ns/j2ee/application-client-2.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client-1.1", "http://geronimo.apache.org/xml/ns/j2ee/application-client-2.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client-1.2", "http://geronimo.apache.org/xml/ns/j2ee/application-client-2.0");
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(AppClientModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultClientEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultServerEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("transactionManagerObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("connectionTrackerObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("corbaGBeanObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("credentialStoreName", AbstractNameQuery.class, true);
        infoBuilder.addReference("Repositories", Repository.class, "Repository");
        infoBuilder.addReference("ConnectorModuleBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ModuleBuilderExtensions", ModuleBuilderExtension.class, "ModuleBuilder");
        infoBuilder.addReference("ClientArtifactResolver", ArtifactResolver.class, "ArtifactResolver");
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"transactionManagerObjectName", "connectionTrackerObjectName", "corbaGBeanObjectName", "credentialStoreName", "Repositories", "ConnectorModuleBuilder", "ServiceBuilders", "NamingBuilders", "ModuleBuilderExtensions", "ClientArtifactResolver", "defaultClientEnvironment", "defaultServerEnvironment"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

