/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.client.AppClientContainer;
import org.apache.geronimo.client.StaticJndiContextPlugin;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.CorbaGBeanNameSource;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilderCollection;
import org.apache.geronimo.j2ee.deployment.SecurityBuilder;
import org.apache.geronimo.j2ee.management.impl.J2EEAppClientModuleImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientDocument;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientType;
import org.apache.geronimo.xbeans.geronimo.client.GerResourceType;
import org.apache.geronimo.xbeans.geronimo.naming.GerAbstractNamingEntryDocument;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientDocument;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class AppClientModuleBuilder
implements ModuleBuilder,
CorbaGBeanNameSource {
    private static final Log log;
    private static final String LINE_SEP;
    private final Environment defaultClientEnvironment;
    private final Environment defaultServerEnvironment;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final SingleElementCollection connectorModuleBuilder;
    private final SingleElementCollection securityBuilder;
    private final NamespaceDrivenBuilderCollection serviceBuilder;
    private final NamingBuilderCollection namingBuilders;
    private final Collection repositories;
    private static final String GERAPPCLIENT_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Collection repositories, ModuleBuilder connectorModuleBuilder, NamespaceDrivenBuilder securityBuilder, NamespaceDrivenBuilder serviceBuilder, Collection namingBuilders) {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, repositories, new SingleElementCollection((Object)connectorModuleBuilder), new SingleElementCollection((Object)securityBuilder), serviceBuilder == null ? Collections.EMPTY_SET : Collections.singleton(serviceBuilder), namingBuilders == null ? Collections.EMPTY_SET : namingBuilders);
    }

    public AppClientModuleBuilder(AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Collection repositories, Collection connectorModuleBuilder, Collection securityBuilder, Collection serviceBuilder, Collection namingBuilders, Environment defaultClientEnvironment, Environment defaultServerEnvironment) {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, repositories, new SingleElementCollection(connectorModuleBuilder), new SingleElementCollection(securityBuilder), serviceBuilder, namingBuilders);
    }

    private AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Collection repositories, SingleElementCollection connectorModuleBuilder, SingleElementCollection securityBuilder, Collection serviceBuilder, Collection namingBuilders) {
        this.defaultClientEnvironment = defaultClientEnvironment;
        this.defaultServerEnvironment = defaultServerEnvironment;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.repositories = repositories;
        this.connectorModuleBuilder = connectorModuleBuilder;
        this.securityBuilder = securityBuilder;
        this.serviceBuilder = new NamespaceDrivenBuilderCollection(serviceBuilder, GBeanBuilder.SERVICE_QNAME);
        this.namingBuilders = new NamingBuilderCollection(namingBuilders, GerAbstractNamingEntryDocument.type.getDocumentElementName());
    }

    public AbstractNameQuery getCorbaGBeanName() {
        return this.corbaGBeanObjectName;
    }

    private ModuleBuilder getConnectorModuleBuilder() {
        return (ModuleBuilder)this.connectorModuleBuilder.getElement();
    }

    private SecurityBuilder getSecurityBuilder() {
        return (SecurityBuilder)this.securityBuilder.getElement();
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, "app-client", null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, earName, naming, idBuilder);
    }

    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        ApplicationClientType appClient;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        if (!$assertionsDisabled && earName == null != (earEnvironment == null)) {
            throw new AssertionError((Object)"if earName is not null you must supply earEnvironment as well");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/application-client.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
            ApplicationClientDocument appClientDoc = AppClientModuleBuilder.convertToApplicationClientSchema(xmlObject);
            appClient = appClientDoc.getApplicationClient();
        }
        catch (XmlException e) {
            throw new DeploymentException("Unable to parse application-client.xml", (Throwable)e);
        }
        boolean standAlone = earEnvironment == null;
        GerApplicationClientType gerAppClient = this.getGeronimoAppClient(plan, moduleFile, standAlone, targetPath, appClient, earEnvironment);
        EnvironmentType clientEnvironmentType = gerAppClient.getClientEnvironment();
        Environment clientEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)clientEnvironmentType, (Environment)this.defaultClientEnvironment);
        if (standAlone) {
            String name = new File(moduleFile.getName()).getName();
            idBuilder.resolve(clientEnvironment, name + "_" + name, "jar");
        } else {
            Artifact earConfigId = earEnvironment.getConfigId();
            idBuilder.resolve(clientEnvironment, earConfigId.getArtifactId() + "_" + targetPath, "jar");
        }
        EnvironmentType serverEnvironmentType = gerAppClient.getServerEnvironment();
        Environment serverEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)serverEnvironmentType, (Environment)this.defaultServerEnvironment);
        if (!standAlone) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)serverEnvironment);
            serverEnvironment = earEnvironment;
            if (!serverEnvironment.getConfigId().isResolved()) {
                throw new IllegalStateException("Server environment module ID should be fully resolved (not " + serverEnvironment.getConfigId() + ")");
            }
        } else {
            idBuilder.resolve(serverEnvironment, new File(moduleFile.getName()).getName(), "jar");
        }
        this.namingBuilders.buildEnvironment((XmlObject)appClient, (XmlObject)gerAppClient, clientEnvironment);
        if (earName == null) {
            earName = naming.createRootName(earEnvironment.getConfigId(), "null", "J2EEApplication");
        }
        AbstractName moduleName = naming.createChildName(earName, clientEnvironment.getConfigId().toString(), "AppClientModule");
        AbstractName clientBaseName = naming.createRootName(clientEnvironment.getConfigId(), clientEnvironment.getConfigId().toString(), "J2EEApplication");
        ArrayList<Module> resourceModules = new ArrayList<Module>();
        GerResourceType[] resources = gerAppClient.getResourceArray();
        for (int i = 0; i < resources.length; ++i) {
            Object connectorFile;
            String path;
            GerResourceType resource = resources[i];
            if (resource.isSetExternalRar()) {
                path = resource.getExternalRar().trim();
                Artifact artifact = Artifact.create((String)path);
                File file = null;
                Iterator iterator = this.repositories.iterator();
                while (iterator.hasNext()) {
                    Repository repository = (Repository)iterator.next();
                    if (!repository.contains(artifact)) continue;
                    file = repository.getLocation(artifact);
                    break;
                }
                if (file == null) {
                    throw new DeploymentException("Missing rar in repositories: " + path);
                }
                try {
                    connectorFile = new JarFile(file);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access rar contents", (Throwable)e);
                }
            }
            path = resource.getInternalRar();
            try {
                connectorFile = new NestedJarFile(moduleFile, path);
            }
            catch (IOException e) {
                throw new DeploymentException("Could not locate connector inside ear", (Throwable)e);
            }
            GerConnectorType connectorPlan = resource.getConnector();
            Module connectorModule = this.getConnectorModuleBuilder().createModule((Object)connectorPlan, (JarFile)connectorFile, path, null, clientEnvironment, null, clientBaseName, naming, idBuilder);
            resourceModules.add(connectorModule);
        }
        return new AppClientModule(standAlone, moduleName, clientBaseName, serverEnvironment, clientEnvironment, moduleFile, targetPath, (XmlObject)appClient, (XmlObject)gerAppClient, specDD, resourceModules);
    }

    GerApplicationClientType getGeronimoAppClient(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, ApplicationClientType appClient, Environment environment) throws DeploymentException {
        GerApplicationClientType gerAppClient;
        XmlObject rawPlan = null;
        try {
            Object path;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((File)((File)plan));
                } else {
                    path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-application-client.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (rawPlan != null) {
                gerAppClient = (GerApplicationClientType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)GerApplicationClientDocument.type.getDocumentElementName(), (SchemaType)GerApplicationClientType.type);
            } else {
                path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                gerAppClient = this.createDefaultPlan((String)path, appClient, standAlone, environment);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        return gerAppClient;
    }

    private GerApplicationClientType createDefaultPlan(String name, ApplicationClientType appClient, boolean standAlone, Environment environment) {
        String id = appClient.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        GerApplicationClientType geronimoAppClient = GerApplicationClientType.Factory.newInstance();
        EnvironmentType clientEnvironmentType = geronimoAppClient.addNewClientEnvironment();
        EnvironmentType serverEnvironmentType = geronimoAppClient.addNewServerEnvironment();
        return geronimoAppClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApplicationClientDocument convertToApplicationClientSchema(XmlObject xmlObject) throws XmlException {
        if (ApplicationClientDocument.type.equals(xmlObject.schemaType())) {
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
            return (ApplicationClientDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd";
        String version = "1.4";
        try {
            SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/j2ee", (String)schemaLocationURL, (String)version);
            cursor.toStartDoc();
            cursor.toChild("http://java.sun.com/xml/ns/j2ee", "application-client");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(ApplicationClientDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (ApplicationClientDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (ApplicationClientDocument)xmlObject;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        EARContext appClientDeploymentContext;
        File appClientDir;
        JarFile moduleFile = module.getModuleFile();
        try {
            earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName());
        }
        AppClientModule appClientModule = (AppClientModule)module;
        appClientModule.setEarFile(earFile);
        Environment clientEnvironment = appClientModule.getClientEnvironment();
        try {
            appClientDir = targetConfigurationStore.createNewConfigurationDir(clientEnvironment.getConfigId());
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
        try {
            appClientDeploymentContext = new EARContext(appClientDir, null, clientEnvironment, ConfigurationModuleType.CAR, earContext.getNaming(), earContext.getConfigurationManager(), null, appClientModule.getAppClientName(), this.transactionManagerObjectName, this.connectionTrackerObjectName, null, null, this.corbaGBeanObjectName);
            appClientModule.setEarContext(appClientDeploymentContext);
            appClientModule.setRootEarContext(earContext);
        }
        catch (DeploymentException e) {
            this.cleanupAppClientDir(appClientDir);
            throw e;
        }
        Iterator resources = appClientModule.getResourceModules().iterator();
        while (resources.hasNext()) {
            ConnectorModule connectorModule = (ConnectorModule)resources.next();
            this.getConnectorModuleBuilder().installModule(connectorModule.getModuleFile(), appClientDeploymentContext, (Module)connectorModule, configurationStores, targetConfigurationStore, repositories);
        }
    }

    public void initContext(EARContext earContext, Module clientModule, ClassLoader cl) throws DeploymentException {
        AppClientModule appClientModule = (AppClientModule)clientModule;
        Iterator resources = appClientModule.getResourceModules().iterator();
        while (resources.hasNext()) {
            ConnectorModule connectorModule = (ConnectorModule)resources.next();
            this.getConnectorModuleBuilder().initContext(appClientModule.getEarContext(), (Module)connectorModule, cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGBeans(EARContext earContext, Module module, ClassLoader earClassLoader, Collection repositories) throws DeploymentException {
        String mainClasss;
        AppClientModule appClientModule = (AppClientModule)module;
        ApplicationClientType appClient = (ApplicationClientType)appClientModule.getSpecDD();
        GerApplicationClientType geronimoAppClient = (GerApplicationClientType)appClientModule.getVendorDD();
        JarFile moduleFile = module.getModuleFile();
        try {
            Manifest manifest = moduleFile.getManifest();
            if (manifest == null) {
                throw new DeploymentException("App client module jar does not contain a manifest: " + moduleFile.getName());
            }
            mainClasss = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (mainClasss == null) {
                throw new DeploymentException("App client module jar does not have Main-Class defined in the manifest: " + moduleFile.getName());
            }
            String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (module.isStandAlone() && classPath != null) {
                throw new DeploymentException("Manifest class path entry is not allowed in a standalone jar (J2EE 1.4 Section 8.2)");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not get manifest from app client module: " + moduleFile.getName());
        }
        AbstractName appClientModuleName = appClientModule.getModuleName();
        GBeanData appClientModuleGBeanData = new GBeanData(appClientModuleName, J2EEAppClientModuleImpl.GBEAN_INFO);
        try {
            appClientModuleGBeanData.setReferencePattern("J2EEServer", earContext.getServerName());
            if (!module.isStandAlone()) {
                appClientModuleGBeanData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
            appClientModuleGBeanData.setAttribute("deploymentDescriptor", (Object)appClientModule.getOriginalSpecDD());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
        }
        try {
            earContext.addGBean(appClientModuleGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add application client module gbean to configuration", (Throwable)e);
        }
        EARContext appClientDeploymentContext = appClientModule.getEarContext();
        ModuleIDBuilder idBuilder = new ModuleIDBuilder();
        idBuilder.setDefaultGroup(appClientModule.getClientEnvironment().getConfigId().getGroupId());
        idBuilder.setDefaultVersion(appClientModule.getClientEnvironment().getConfigId().getVersion());
        try {
            try {
                this.namingBuilders.initContext((XmlObject)appClient, (XmlObject)geronimoAppClient, appClientDeploymentContext.getConfiguration(), earContext.getConfiguration(), (Module)appClientModule);
                URI moduleBase = new URI(appClientModule.getTargetPath());
                try {
                    appClientDeploymentContext.addIncludeAsPackedJar(moduleBase, moduleFile);
                }
                catch (IOException e) {
                    throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName());
                }
                this.addManifestClassPath((DeploymentContext)appClientDeploymentContext, appClientModule.getEarFile(), moduleFile, moduleBase);
                ClassLoader appClientClassLoader = appClientDeploymentContext.getClassLoader();
                if (geronimoAppClient != null) {
                    this.serviceBuilder.build((XmlObject)geronimoAppClient, (DeploymentContext)appClientDeploymentContext, (DeploymentContext)appClientDeploymentContext);
                    Iterator resources = appClientModule.getResourceModules().iterator();
                    while (resources.hasNext()) {
                        ConnectorModule connectorModule = (ConnectorModule)resources.next();
                        this.getConnectorModuleBuilder().addGBeans(appClientDeploymentContext, (Module)connectorModule, appClientClassLoader, repositories);
                    }
                }
                AbstractName jndiContextName = earContext.getNaming().createChildName(appClientDeploymentContext.getModuleName(), "StaticJndiContext", "StaticJndiContext");
                GBeanData jndiContextGBeanData = new GBeanData(jndiContextName, StaticJndiContextPlugin.GBEAN_INFO);
                try {
                    HashMap buildingContext = new HashMap();
                    buildingContext.put("JNDI_COMPONENT_CONTEXT", new HashMap());
                    buildingContext.put("GBEAN_NAME", jndiContextName);
                    Configuration localConfiguration = appClientDeploymentContext.getConfiguration();
                    Configuration remoteConfiguration = earContext.getConfiguration();
                    this.namingBuilders.buildNaming((XmlObject)appClient, (XmlObject)geronimoAppClient, localConfiguration, remoteConfiguration, (Module)appClientModule, buildingContext);
                    jndiContextGBeanData.setAttribute("context", buildingContext.get("JNDI_COMPONENT_CONTEXT"));
                }
                catch (DeploymentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to construct jndi context for AppClientModule GBean", (Throwable)e);
                }
                appClientDeploymentContext.addGBean(jndiContextGBeanData);
                AbstractName appClientContainerName = appClientDeploymentContext.getModuleName();
                GBeanData appClientContainerGBeanData = new GBeanData(appClientContainerName, AppClientContainer.GBEAN_INFO);
                try {
                    appClientContainerGBeanData.setAttribute("mainClassName", (Object)mainClasss);
                    appClientContainerGBeanData.setAttribute("appClientModuleName", (Object)appClientModuleName);
                    String callbackHandlerClassName = null;
                    if (appClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = appClient.getCallbackHandler().getStringValue().trim();
                    }
                    if (geronimoAppClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = geronimoAppClient.getCallbackHandler().trim();
                    }
                    String realmName = null;
                    if (geronimoAppClient.isSetRealmName()) {
                        realmName = geronimoAppClient.getRealmName().trim();
                    }
                    if (callbackHandlerClassName != null && realmName == null) {
                        throw new DeploymentException("You must specify a realm name with the callback handler");
                    }
                    if (realmName != null) {
                        appClientContainerGBeanData.setAttribute("realmName", (Object)realmName);
                        appClientContainerGBeanData.setAttribute("callbackHandlerClassName", (Object)callbackHandlerClassName);
                    } else if (geronimoAppClient.isSetDefaultPrincipal()) {
                        DefaultPrincipal defaultPrincipal = this.getSecurityBuilder().buildDefaultPrincipal((XmlObject)geronimoAppClient.getDefaultPrincipal());
                        appClientContainerGBeanData.setAttribute("defaultPrincipal", (Object)defaultPrincipal);
                    }
                    appClientContainerGBeanData.setReferencePattern("JNDIContext", jndiContextName);
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
                }
                appClientDeploymentContext.addGBean(appClientContainerGBeanData);
                earContext.addAdditionalDeployment(appClientDeploymentContext.getConfigurationData());
            }
            finally {
                if (appClientDeploymentContext != null) {
                    try {
                        appClientDeploymentContext.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Throwable e) {
            File appClientDir = appClientDeploymentContext.getBaseDir();
            this.cleanupAppClientDir(appClientDir);
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof Exception) {
                throw new DeploymentException(e);
            }
            throw new Error(e);
        }
    }

    public String getSchemaNamespace() {
        return GERAPPCLIENT_NAMESPACE;
    }

    public void addManifestClassPath(DeploymentContext deploymentContext, JarFile earFile, JarFile jarFile, URI jarFileLocation) throws DeploymentException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + jarFileLocation);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            JarFile classPathJarFile;
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            URI classPathJarLocation = jarFileLocation.resolve(pathUri);
            File classPathFile = deploymentContext.getTargetFile(classPathJarLocation);
            if (classPathFile.exists()) continue;
            ZipEntry entry = earFile.getEntry(classPathJarLocation.getPath());
            if (entry == null) {
                throw new DeploymentException("Cound not find manifest class path entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            try {
                deploymentContext.addFile(classPathJarLocation, (ZipFile)earFile, entry);
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not copy manifest class path entry into configuration: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            try {
                classPathJarFile = new JarFile(classPathFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Manifest class path entries must be a valid jar file (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            this.addManifestClassPath(deploymentContext, earFile, classPathJarFile, classPathJarLocation);
        }
    }

    private boolean cleanupAppClientDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !AppClientModuleBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)AppClientModuleBuilder.class);
        LINE_SEP = System.getProperty("line.separator");
        GERAPPCLIENT_NAMESPACE = GerApplicationClientDocument.type.getDocumentElementName().getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)AppClientModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultClientEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultServerEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("transactionManagerObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("connectionTrackerObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("corbaGBeanObjectName", AbstractNameQuery.class, true);
        infoBuilder.addReference("Repositories", Repository.class, "Repository");
        infoBuilder.addReference("ConnectorModuleBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("SecurityBuilder", SecurityBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"transactionManagerObjectName", "connectionTrackerObjectName", "corbaGBeanObjectName", "Repositories", "ConnectorModuleBuilder", "SecurityBuilder", "ServiceBuilders", "NamingBuilders", "defaultClientEnvironment", "defaultServerEnvironment"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

