/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.client;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.impl.DescriptionFactoryImpl;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.apache.geronimo.axis2.client.Axis2ClientConfigurationFactory;
import org.apache.geronimo.axis2.osgi.Axis2ModuleRegistry;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="Axis2ConfigGBean")
public class Axis2ConfigGBean
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(Axis2ConfigGBean.class);
    private AbstractName moduleName;
    private ClassLoader classLoder;
    private Axis2ModuleRegistry axis2ModuleRegistry;

    public Axis2ConfigGBean(@ParamAttribute(name="moduleName") AbstractName moduleName, @ParamReference(name="Axis2ModuleRegistry") Axis2ModuleRegistry axis2ModuleRegistry, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) {
        this.moduleName = moduleName;
        this.classLoder = classLoader;
        this.axis2ModuleRegistry = axis2ModuleRegistry;
    }

    public static synchronized Axis2ClientConfigurationFactory registerClientConfigurationFactory(Axis2ModuleRegistry axis2ModuleRegistry) {
        ClientConfigurationFactory factory = (ClientConfigurationFactory)MetadataFactoryRegistry.getFactory(ClientConfigurationFactory.class);
        if (factory instanceof Axis2ClientConfigurationFactory) {
            return (Axis2ClientConfigurationFactory)factory;
        }
        factory = new Axis2ClientConfigurationFactory(axis2ModuleRegistry, false);
        MetadataFactoryRegistry.setFactory(ClientConfigurationFactory.class, (Object)factory);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered client configuration factory: " + factory);
        }
        if (factory != DescriptionFactoryImpl.getClientConfigurationFactory()) {
            throw new RuntimeException("Client configuration factory was registered too late");
        }
        return (Axis2ClientConfigurationFactory)factory;
    }

    public void doStart() throws Exception {
        Axis2ConfigGBean.registerClientConfigurationFactory(this.axis2ModuleRegistry);
    }

    public void doStop() throws Exception {
        ConfigurationContext configContext = Axis2ConfigGBean.registerClientConfigurationFactory(this.axis2ModuleRegistry).clearCache(this.classLoder);
        DescriptionFactoryImpl.clearServiceDescriptionCache((ConfigurationContext)configContext);
    }

    public void doFail() {
    }
}

