/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.client;

import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.geronimo.axis2.GeronimoConfigurator;
import org.apache.geronimo.axis2.osgi.Axis2ModuleRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axis2ClientConfigurationFactory
extends ClientConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Axis2ClientConfigurationFactory.class);
    private Map<ClassLoader, ConfigurationContext> contextCache = new Hashtable<ClassLoader, ConfigurationContext>();
    private boolean reuseConfigurationContext;
    private Axis2ModuleRegistry axis2ModuleRegistry;

    public Axis2ClientConfigurationFactory(Axis2ModuleRegistry axis2ModuleRegistry, boolean reuse) {
        this.reuseConfigurationContext = reuse;
        this.axis2ModuleRegistry = axis2ModuleRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationContext getClientConfigurationContext() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            if (this.reuseConfigurationContext) {
                cl = ClientConfigurationFactory.class.getClassLoader();
            } else {
                return this.createConfigurationContext();
            }
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return this.getConfigurationContext(cl);
        }
    }

    private ConfigurationContext getConfigurationContext(ClassLoader cl) {
        ConfigurationContext context = this.contextCache.get(cl);
        if (context == null) {
            context = this.createConfigurationContext();
            this.axis2ModuleRegistry.configureModules(context);
            this.contextCache.put(cl, context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created new configuration context " + context + "  for " + cl);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Configuration context " + context + " reused for " + cl);
        }
        return context;
    }

    private ConfigurationContext removeConfigurationContext(ClassLoader cl) {
        return this.contextCache.remove(cl);
    }

    public void clearCache() {
        this.contextCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationContext clearCache(ClassLoader cl) {
        ConfigurationContext context = null;
        if (cl != null) {
            ClassLoader classLoader = cl;
            synchronized (classLoader) {
                context = this.removeConfigurationContext(cl);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed configuration context " + context + " for " + cl);
            }
        }
        return context;
    }

    private ConfigurationContext createConfigurationContext() {
        try {
            GeronimoConfigurator configurator = new GeronimoConfigurator("META-INF/geronimo-axis2.xml");
            return ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)configurator);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

