/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.osgi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
@OsgiService
public class NeethiAssertionBuilderRegistry
implements BundleListener,
GBeanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(NeethiAssertionBuilderRegistry.class);
    private BundleContext bundleContext;

    public NeethiAssertionBuilderRegistry(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        int bundleState = bundle.getState();
        if (bundleState == 4) {
            this.registerAssertionBuilder(bundle);
        }
    }

    public void doStart() throws Exception {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!BundleUtils.isResolved((Bundle)bundle)) continue;
            this.registerAssertionBuilder(bundle);
        }
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void doStop() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void registerAssertionBuilder(Bundle bundle) {
        URL url = bundle.getEntry("META-INF/services/" + AssertionBuilder.class.getName());
        if (url == null) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            String currLine = null;
            while ((currLine = reader.readLine()) != null) {
                int commentIndex = currLine.indexOf("#");
                if (commentIndex != -1) {
                    currLine = currLine.substring(0, commentIndex);
                }
                if ((currLine = currLine.trim()).length() <= 0) continue;
                try {
                    Class cls = bundle.loadClass(currLine);
                    Object instance = cls.newInstance();
                    if (instance instanceof AssertionBuilder) {
                        AssertionBuilder assertionBuilder = (AssertionBuilder)instance;
                        for (QName supportedQName : assertionBuilder.getKnownElements()) {
                            PolicyEngine.registerBuilder((QName)supportedQName, (AssertionBuilder)assertionBuilder);
                        }
                        continue;
                    }
                    logger.warn(currLine + " in the META-INF/services/ org.apache.neethi.builders.AssertionBuilder from bundle " + bundle.getSymbolicName() + " is not of type AssertionBuilder, it will be ignored");
                }
                catch (Exception e) {
                    logger.warn(currLine + " in the META-INF/services/ org.apache.neethi.builders.AssertionBuilder from bundle " + bundle.getSymbolicName() + " could not be registered to PolicyEngine, it will be ignored", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            IOUtils.close(reader);
            catch (Throwable throwable) {
                IOUtils.close(reader);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)reader);
    }
}

