/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.catalog.impl.OASISCatalogManager;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.builder.WsdlGenerator;
import org.apache.axis2.jaxws.description.builder.converter.JavaClassToDBCConverter;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisServiceGenerator {
    private static final Logger log = LoggerFactory.getLogger(AxisServiceGenerator.class);
    private MessageReceiver messageReceiver = new JAXWSMessageReceiver();
    private ConfigurationContext configurationContext;
    private String catalogName;

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public AxisService getServiceFromClass(Class endpointClass) throws Exception {
        ServiceDescription serviceDescription = DescriptionFactory.createServiceDescription((Class)endpointClass);
        EndpointDescription[] edArray = serviceDescription.getEndpointDescriptions();
        AxisService service = edArray[0].getAxisService();
        if (service.getNameSpacesMap() == null) {
            NamespaceMap map = new NamespaceMap();
            map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
            map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            service.setNameSpacesMap(map);
        }
        String endpointClassName = endpointClass.getName();
        ClassLoader classLoader = endpointClass.getClassLoader();
        service.addParameter(new Parameter("ServiceClass", (Object)endpointClassName));
        service.setClassLoader(classLoader);
        Iterator opIterator = service.getOperations();
        while (opIterator.hasNext()) {
            AxisOperation operation = (AxisOperation)opIterator.next();
            operation.setMessageReceiver(this.messageReceiver);
        }
        Parameter serviceDescriptionParam = new Parameter("org.apache.axis2.jaxws.description.EndpointDescription", (Object)edArray[0]);
        service.addParameter(serviceDescriptionParam);
        return service;
    }

    public AxisService getServiceFromWSDL(PortInfo portInfo, Class endpointClass, URL configurationBaseUrl) throws Exception {
        URL wsdlURL;
        WSDL4JWrapper wsdlWrapper;
        Definition wsdlDefinition;
        Service wsdlService;
        QName portQName;
        String wsdlFile = portInfo.getWsdlFile();
        if (wsdlFile == null || wsdlFile.equals("")) {
            throw new Exception("WSDL file is required.");
        }
        String endpointClassName = endpointClass.getName();
        ClassLoader classLoader = endpointClass.getClassLoader();
        QName serviceQName = portInfo.getWsdlService();
        if (serviceQName == null) {
            serviceQName = JAXWSUtils.getServiceQName((Class)endpointClass);
        }
        if ((portQName = portInfo.getWsdlPort()) == null) {
            portQName = JAXWSUtils.getPortQName((Class)endpointClass);
        }
        OASISCatalogManager catalogManager = new OASISCatalogManager();
        URL catalogURL = JAXWSUtils.getOASISCatalogURL((URL)configurationBaseUrl, (ClassLoader)classLoader, (String)this.catalogName);
        if (catalogURL != null) {
            catalogManager.setCatalogFiles(catalogURL.toString());
        }
        if ((wsdlService = (wsdlDefinition = (wsdlWrapper = new WSDL4JWrapper(wsdlURL = AxisServiceGenerator.getWsdlURL(wsdlFile, configurationBaseUrl, classLoader), this.configurationContext, (JAXWSCatalogManager)catalogManager)).getDefinition()).getService(serviceQName)) == null) {
            throw new Exception("Service '" + serviceQName + "' not found in WSDL");
        }
        Port port = wsdlService.getPort(portQName.getLocalPart());
        if (port == null) {
            throw new Exception("Port '" + portQName.getLocalPart() + "' not found in WSDL");
        }
        String protocolBinding = null;
        protocolBinding = portInfo.getProtocolBinding() != null ? JAXWSUtils.getBindingURI((String)portInfo.getProtocolBinding()) : this.getBindingFromWSDL(port);
        Class<?> endPointClass = classLoader.loadClass(endpointClassName);
        JavaClassToDBCConverter converter = new JavaClassToDBCConverter(endPointClass);
        HashMap dbcMap = converter.produceDBC();
        DescriptionBuilderComposite dbc = (DescriptionBuilderComposite)dbcMap.get(endpointClassName);
        dbc.setClassLoader(classLoader);
        dbc.setWsdlDefinition(wsdlDefinition);
        dbc.setClassName(endpointClassName);
        dbc.setCustomWsdlGenerator((WsdlGenerator)new WSDLGeneratorImpl(wsdlDefinition));
        dbc.setCatalogManager((JAXWSCatalogManager)catalogManager);
        if (dbc.getWebServiceAnnot() != null) {
            WebServiceAnnot serviceAnnot = dbc.getWebServiceAnnot();
            serviceAnnot.setPortName(portQName.getLocalPart());
            serviceAnnot.setServiceName(serviceQName.getLocalPart());
            serviceAnnot.setTargetNamespace(serviceQName.getNamespaceURI());
            this.processServiceBinding(dbc, protocolBinding);
        } else if (dbc.getWebServiceProviderAnnot() != null) {
            WebServiceProviderAnnot serviceProviderAnnot = dbc.getWebServiceProviderAnnot();
            serviceProviderAnnot.setPortName(portQName.getLocalPart());
            serviceProviderAnnot.setServiceName(serviceQName.getLocalPart());
            serviceProviderAnnot.setTargetNamespace(serviceQName.getNamespaceURI());
            this.processServiceBinding(dbc, protocolBinding);
        }
        if (portInfo.isMTOMEnabled() != null) {
            dbc.setIsMTOMEnabled(portInfo.isMTOMEnabled().booleanValue());
        }
        AxisService service = this.getService(dbcMap);
        service.setName(serviceQName.getLocalPart());
        service.setEndpointName(portQName.getLocalPart());
        Iterator opIterator = service.getOperations();
        while (opIterator.hasNext()) {
            AxisOperation operation = (AxisOperation)opIterator.next();
            operation.setMessageReceiver(this.messageReceiver);
            String MEP = operation.getMessageExchangePattern();
            if (WSDLUtil.isOutputPresentForMEP((String)MEP)) continue;
            List mdcList = dbc.getMethodDescriptionComposite(operation.getName().toString());
            for (MethodDescriptionComposite mdc : mdcList) {
                mdc.setOneWayAnnot(true);
            }
        }
        return service;
    }

    private String getBindingFromWSDL(Port port) {
        Binding binding = port.getBinding();
        List extElements = binding.getExtensibilityElements();
        Iterator extElementsIterator = extElements.iterator();
        String bindingS = "http://schemas.xmlsoap.org/wsdl/soap/http";
        while (extElementsIterator.hasNext()) {
            SOAPBinding sp;
            Object o = extElementsIterator.next();
            if (o instanceof SOAPBinding) {
                sp = (SOAPBinding)o;
                if (!sp.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) continue;
                bindingS = "http://schemas.xmlsoap.org/wsdl/soap/http";
                continue;
            }
            if (o instanceof SOAP12Binding) {
                sp = (SOAP12Binding)o;
                if (!sp.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                bindingS = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
                continue;
            }
            if (!(o instanceof HTTPBinding) || !(sp = (HTTPBinding)o).getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/http/")) continue;
            bindingS = "http://www.w3.org/2004/08/wsdl/http";
        }
        return bindingS;
    }

    private void processServiceBinding(DescriptionBuilderComposite dbc, String bindingFromWSDL) {
        if (dbc.getBindingTypeAnnot() == null || bindingFromWSDL == null || bindingFromWSDL.length() == 0) {
            return;
        }
        String bindingFromAnnotation = dbc.getBindingTypeAnnot().value();
        if (bindingFromAnnotation.equals(bindingFromWSDL)) {
            return;
        }
        if (bindingFromWSDL.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            if (!bindingFromAnnotation.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
                dbc.getBindingTypeAnnot().setValue(bindingFromWSDL);
            }
        } else if (bindingFromWSDL.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            if (!bindingFromAnnotation.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
                dbc.getBindingTypeAnnot().setValue(bindingFromWSDL);
            }
        } else {
            dbc.getBindingTypeAnnot().setValue(bindingFromWSDL);
        }
    }

    private AxisService getService(HashMap<String, DescriptionBuilderComposite> dbcMap) {
        return this.getEndpointDescription(dbcMap).getAxisService();
    }

    private EndpointDescription getEndpointDescription(HashMap<String, DescriptionBuilderComposite> dbcMap) {
        List serviceDescList = DescriptionFactory.createServiceDescriptionFromDBCMap(dbcMap, (ConfigurationContext)this.configurationContext);
        if (serviceDescList == null || serviceDescList.isEmpty()) {
            throw new RuntimeException("No service");
        }
        ServiceDescription serviceDescription = (ServiceDescription)serviceDescList.get(0);
        EndpointDescription[] edArray = serviceDescription.getEndpointDescriptions();
        if (edArray == null || edArray.length == 0) {
            throw new RuntimeException("No endpoint");
        }
        return edArray[0];
    }

    public static URL getWsdlURL(String wsdlFile, URL configurationBaseUrl, ClassLoader classLoader) {
        URL wsdlURL;
        block5: {
            wsdlURL = null;
            if (wsdlFile != null) {
                try {
                    wsdlURL = new URL(wsdlFile);
                }
                catch (MalformedURLException e) {
                    wsdlURL = classLoader.getResource(wsdlFile);
                    if (wsdlURL != null || configurationBaseUrl == null) break block5;
                    try {
                        wsdlURL = new URL(configurationBaseUrl, wsdlFile);
                    }
                    catch (MalformedURLException ee) {
                        // empty catch block
                    }
                }
            }
        }
        return wsdlURL;
    }

    public static EndpointDescription getEndpointDescription(AxisService service) {
        Parameter param = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        return param == null ? null : (EndpointDescription)param.getValue();
    }

    public static boolean isSOAP11(AxisService service) {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(service);
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(desc.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(desc.getBindingType());
    }

    public static boolean isHTTP(AxisService service) {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(service);
        return "http://www.w3.org/2004/08/wsdl/http".equals(desc.getBindingType());
    }

    private static class WSDLGeneratorImpl
    implements WsdlGenerator {
        private Definition def;

        public WSDLGeneratorImpl(Definition def) {
            this.def = def;
        }

        public WsdlComposite generateWsdl(String implClass, EndpointDescription endpointDesc) throws WebServiceException {
            WsdlComposite composite = new WsdlComposite();
            composite.setWsdlFileName(implClass);
            HashMap<String, Definition> testMap = new HashMap<String, Definition>();
            testMap.put(composite.getWsdlFileName(), this.def);
            composite.setWsdlDefinition(testMap);
            return composite;
        }
    }
}

