/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.pojo;

import java.net.URL;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis2.pojo.POJOWebServiceContainer;
import org.apache.geronimo.axis2.pojo.POJOWebServiceContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.annotations.AnnotationHolder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.naming.reference.SimpleReference;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;

public class POJOWebServiceContainerFactoryGBean
implements WebServiceContainerFactory {
    private static final Log LOG = LogFactory.getLog(POJOWebServiceContainerFactoryGBean.class);
    private final ClassLoader classLoader;
    private final PortInfo portInfo;
    private final String endpointClassName;
    private URL configurationBaseUrl;
    private Context context;
    private AnnotationHolder holder;
    private String contextRoot;
    public static final GBeanInfo GBEAN_INFO;

    public POJOWebServiceContainerFactoryGBean(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Map componentContext, Kernel kernel, TransactionManager transactionManager, URL configurationBaseUrl, AnnotationHolder holder, String contextRoot) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (componentContext != null) {
            componentContext.put("env/WebServiceContext", new WebServiceContextReference());
            GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
            try {
                this.context = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext, (UserTransaction)userTransaction, (Kernel)kernel, (ClassLoader)classLoader);
            }
            catch (NamingException e) {
                LOG.warn((Object)"Failed to create naming context", (Throwable)e);
            }
        }
        this.portInfo = portInfo;
        this.classLoader = classLoader;
        this.endpointClassName = endpointClassName;
        this.configurationBaseUrl = configurationBaseUrl;
        this.holder = holder;
        this.contextRoot = contextRoot;
    }

    public WebServiceContainer getWebServiceContainer() {
        POJOWebServiceContainer container = new POJOWebServiceContainer(this.portInfo, this.endpointClassName, this.classLoader, this.context, this.configurationBaseUrl, this.holder, this.contextRoot);
        try {
            container.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Failure initializing web service containter", e);
        }
        return container;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(POJOWebServiceContainerFactoryGBean.class, (String)"GBean");
        infoBuilder.addAttribute("portInfo", PortInfo.class, true, true);
        infoBuilder.addAttribute("endpointClassName", String.class, true, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("componentContext", Map.class, true, true);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addReference("TransactionManager", TransactionManager.class, "JTAResource");
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("holder", AnnotationHolder.class, true);
        infoBuilder.addAttribute("contextRoot", String.class, true, true);
        infoBuilder.setConstructor(new String[]{"portInfo", "endpointClassName", "classLoader", "componentContext", "kernel", "TransactionManager", "configurationBaseUrl", "holder", "contextRoot"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private static class WebServiceContextReference
    extends SimpleReference {
        private WebServiceContextReference() {
        }

        public Object getContent() throws NamingException {
            return new POJOWebServiceContext();
        }
    }
}

