/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis2.AnnotationHandlerChainBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.xbeans.javaee.HandlerChainType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoHandlerChainBuilder
extends AnnotationHandlerChainBuilder {
    private static final Log log = LogFactory.getLog(GeronimoHandlerChainBuilder.class);
    private ClassLoader classLoader = null;
    private PortInfo portInfo;

    public GeronimoHandlerChainBuilder(ClassLoader classloader, PortInfo portInfo) {
        this.classLoader = classloader;
        this.portInfo = portInfo;
    }

    public ClassLoader getHandlerClassLoader() {
        return this.classLoader;
    }

    @Override
    protected List<Handler> buildHandlerChain(HandlerChainType hc, ClassLoader classLoader) {
        if (this.matchServiceName(this.portInfo, hc.getServiceNamePattern()) && this.matchPortName(this.portInfo, hc.getPortNamePattern()) && this.matchBinding(this.portInfo, hc.getProtocolBindings())) {
            return super.buildHandlerChain(hc, classLoader);
        }
        return Collections.emptyList();
    }

    private boolean matchServiceName(PortInfo info, String namePattern) {
        return this.match(info == null ? null : info.getServiceName(), namePattern);
    }

    private boolean matchPortName(PortInfo info, String namePattern) {
        return this.match(info == null ? null : info.getPortName(), namePattern);
    }

    private boolean matchBinding(PortInfo info, List bindings) {
        return this.match(info == null ? null : info.getBindingID(), bindings);
    }

    private boolean match(String binding, List bindings) {
        if (binding == null) {
            return bindings == null || bindings.isEmpty();
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        String actualBindingURI = JAXWSUtils.getBindingURI((String)binding);
        for (String bindingToken : bindings) {
            String bindingURI = JAXWSUtils.getBindingURI((String)bindingToken);
            if (!actualBindingURI.equals(bindingURI)) continue;
            return true;
        }
        return false;
    }

    public List<Handler> buildHandlerChainFromConfiguration(HandlerChainType hc) {
        if (null == hc) {
            return null;
        }
        return this.sortHandlers(this.buildHandlerChain(hc, this.getHandlerClassLoader()));
    }

    private boolean match(QName name, String namePattern) {
        if (name == null) {
            return namePattern == null || namePattern.equals("*");
        }
        if (namePattern == null) {
            return true;
        }
        int pos = namePattern.indexOf(58);
        String localNamePattern = pos == -1 ? namePattern : namePattern.substring(pos + 1);
        if ((localNamePattern = localNamePattern.trim()).equals("*")) {
            return true;
        }
        if (localNamePattern.endsWith("*")) {
            localNamePattern = localNamePattern.substring(0, localNamePattern.length() - 1);
            return name.getLocalPart().startsWith(localNamePattern);
        }
        return name.getLocalPart().equals(localNamePattern);
    }
}

