/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.ejb;

import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.xml.ws.Binding;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis2.ejb.EJBEndpointController;
import org.apache.geronimo.axis2.ejb.EJBWebServiceContainer;

public class EJBInterceptor {
    private static final Log LOG = LogFactory.getLog(EJBInterceptor.class);
    private MessageContext requestMsgCtx;
    private EJBWebServiceContainer container;

    public EJBInterceptor(EJBWebServiceContainer container, MessageContext requestCtx) {
        this.container = container;
        this.requestMsgCtx = requestCtx;
    }

    @AroundInvoke
    public Object intercept(InvocationContext invContext) throws Exception {
        this.container.injectHandlers();
        AxisOperation operation = this.requestMsgCtx.getAxisMessageContext().getAxisOperation();
        String mep = operation.getMessageExchangePattern();
        EJBEndpointController controller = new EJBEndpointController(invContext);
        Binding binding = (Binding)this.requestMsgCtx.getAxisMessageContext().getProperty(JAXWSMessageReceiver.PARAM_BINDING);
        org.apache.axis2.jaxws.core.InvocationContext ic = InvocationContextFactory.createInvocationContext((Binding)binding);
        ic.setRequestMessageContext(this.requestMsgCtx);
        controller.invoke(ic);
        MessageContext responseMsgCtx = ic.getResponseMessageContext();
        if (!this.isMepInOnly(mep) || this.hasFault(responseMsgCtx)) {
            org.apache.axis2.context.MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
            MessageUtils.putMessageOnMessageContext((Message)responseMsgCtx.getMessage(), (org.apache.axis2.context.MessageContext)axisResponseMsgCtx);
            OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
            opCtx.addMessageContext(axisResponseMsgCtx);
            if (responseMsgCtx.getMessage().isFault()) {
                throw new AxisFault("An error was detected during JAXWS processing", axisResponseMsgCtx);
            }
            AxisEngine engine = new AxisEngine(axisResponseMsgCtx.getConfigurationContext());
            AxisEngine.send((org.apache.axis2.context.MessageContext)axisResponseMsgCtx);
        }
        return null;
    }

    private boolean hasFault(MessageContext responseMsgCtx) {
        if (responseMsgCtx == null || responseMsgCtx.getMessage() == null) {
            return false;
        }
        return responseMsgCtx.getMessage().isFault();
    }

    private boolean isMepInOnly(String mep) {
        boolean inOnly = mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only");
        return inOnly;
    }
}

