/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.builder;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis2.client.Axis2ConfigGBean;
import org.apache.geronimo.axis2.client.Axis2ServiceReference;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.builder.EndpointInfoBuilder;
import org.apache.geronimo.jaxws.builder.JAXWSServiceRefBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.PortComponentRefType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerChainsType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ServiceRefBuilder
extends JAXWSServiceRefBuilder {
    private static final Log log = LogFactory.getLog(Axis2ServiceRefBuilder.class);
    public static final GBeanInfo GBEAN_INFO;

    public Axis2ServiceRefBuilder(Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment, eeNamespaces);
    }

    public Object createService(ServiceRefType serviceRef, GerServiceRefType gerServiceRef, Module module, ClassLoader cl, Class serviceInterfaceClass, QName serviceQName, URI wsdlURI, Class serviceReferenceType, Map<Class, PortComponentRefType> portComponentRefMap) throws DeploymentException {
        this.registerConfigGBean(module);
        EndpointInfoBuilder builder = new EndpointInfoBuilder(serviceInterfaceClass, gerServiceRef, portComponentRefMap, module.getModuleFile(), wsdlURI, serviceQName);
        builder.build();
        wsdlURI = builder.getWsdlURI();
        serviceQName = builder.getServiceQName();
        Map seiInfoMap = builder.getEndpointInfo();
        String handlerChainsXML = null;
        try {
            handlerChainsXML = Axis2ServiceRefBuilder.getHandlerChainAsString(serviceRef.getHandlerChains());
        }
        catch (IOException e) {
            log.warn((Object)"Failed to serialize handler chains", (Throwable)e);
        }
        String serviceReferenceName = serviceReferenceType == null ? null : serviceReferenceType.getName();
        return new Axis2ServiceReference(serviceInterfaceClass.getName(), serviceReferenceName, wsdlURI, serviceQName, module.getModuleName(), handlerChainsXML, seiInfoMap);
    }

    private static String getHandlerChainAsString(ServiceRefHandlerChainsType handlerChains) throws IOException {
        String xml = null;
        if (handlerChains != null) {
            StringWriter w = new StringWriter();
            XmlOptions options = new XmlOptions();
            options.setSaveSyntheticDocumentElement(new QName("http://java.sun.com/xml/ns/javaee", "handler-chains"));
            handlerChains.save((Writer)w, options);
            xml = w.toString();
        }
        return xml;
    }

    private void registerConfigGBean(Module module) throws DeploymentException {
        EARContext context = module.getEarContext();
        AbstractName containerFactoryName = context.getNaming().createChildName(module.getModuleName(), Axis2ConfigGBean.GBEAN_INFO.getName(), "GBean");
        try {
            context.getGBeanInstance(containerFactoryName);
        }
        catch (GBeanNotFoundException e1) {
            GBeanData configGBeanData = new GBeanData(containerFactoryName, Axis2ConfigGBean.GBEAN_INFO);
            configGBeanData.setAttribute("moduleName", (Object)module.getModuleName());
            try {
                context.addGBean(configGBeanData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Could not add config gbean", (Throwable)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(Axis2ServiceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(ServiceRefBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

