/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.server;

import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import org.apache.axis.Handler;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.geronimo.axis.server.AxisWebServiceContainer;
import org.apache.geronimo.axis.server.ServiceInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.server.axis.EjbContainerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(j2eeType="WSLink")
public class EjbWebServiceGBean
implements GBeanLifecycle {
    private final SoapHandler soapHandler;
    private final URI location;

    public EjbWebServiceGBean(@ParamReference(name="EjbDeployment") EjbDeployment ejbDeploymentContext, @ParamAttribute(name="location") URI location, @ParamAttribute(name="wsdlURI") URI wsdlURI, @ParamAttribute(name="serviceInfo") ServiceInfo serviceInfo, @ParamReference(name="WebServiceContainer") Collection<SoapHandler> webContainers, @ParamAttribute(name="policyContextID") String policyContextID, @ParamReference(name="ConfigurationFactory") ConfigurationFactory configurationFactory, @ParamAttribute(name="realmName") String realmName, @ParamAttribute(name="authMethod") String authMethod, @ParamAttribute(name="virtualHosts") String[] virtualHosts, @ParamAttribute(name="properties") Properties properties) throws Exception {
        this.location = location;
        if (webContainers == null || webContainers.isEmpty()) {
            this.soapHandler = null;
            return;
        }
        this.soapHandler = webContainers.iterator().next();
        EjbContainerProvider provider = new EjbContainerProvider((DeploymentInfo)ejbDeploymentContext.getDeploymentInfo(), serviceInfo.getHandlerInfos());
        SOAPService service = new SOAPService(null, (Handler)provider, null);
        JavaServiceDesc serviceDesc = serviceInfo.getServiceDesc();
        service.setServiceDescription((ServiceDesc)serviceDesc);
        ClassLoader classLoader = ejbDeploymentContext.getClassLoader();
        Class<?> serviceEndpointInterface = classLoader.loadClass(ejbDeploymentContext.getServiceEndpointInterfaceName());
        service.setOption("className", (Object)serviceEndpointInterface.getName());
        serviceDesc.setImplClass(serviceEndpointInterface);
        AxisWebServiceContainer axisContainer = new AxisWebServiceContainer(location, wsdlURI, service, serviceInfo.getWsdlMap(), classLoader);
        if (this.soapHandler != null) {
            this.soapHandler.addWebService(location.getPath(), virtualHosts, (WebServiceContainer)axisContainer, policyContextID, configurationFactory, realmName, authMethod, properties, classLoader);
        }
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        if (this.soapHandler != null) {
            this.soapHandler.removeWebService(this.location.getPath());
        }
    }

    public void doFail() {
    }
}

