/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.encoding.ser.ArrayDeserializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.geronimo.axis.builder.TypeInfoBuilder;
import org.apache.geronimo.axis.client.TypeInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.webservices.builder.SchemaTypeKey;
import org.apache.geronimo.webservices.builder.WSDescriptorParser;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.osgi.framework.Bundle;

public class LightweightTypeInfoBuilder
implements TypeInfoBuilder {
    private final Bundle cl;
    private final Map schemaTypeKeyToSchemaTypeMap;
    private final Set wrapperElementQNames;

    public LightweightTypeInfoBuilder(Bundle bundle, Map schemaTypeKeyToSchemaTypeMap, Set wrapperElementQNames) {
        this.cl = bundle;
        this.schemaTypeKeyToSchemaTypeMap = schemaTypeKeyToSchemaTypeMap;
        this.wrapperElementQNames = wrapperElementQNames;
    }

    @Override
    public List buildTypeInfo(JavaWsdlMapping mapping) throws DeploymentException {
        ArrayList<TypeInfo> typeInfoList = new ArrayList<TypeInfo>();
        for (SchemaTypeKey key : this.schemaTypeKeyToSchemaTypeMap.keySet()) {
            if (key.isElement() || key.isAnonymous()) continue;
            QName typeQName = key.getqName();
            String namespace = typeQName.getNamespaceURI();
            String packageName = WSDescriptorParser.getPackageFromNamespace((String)namespace, (JavaWsdlMapping)mapping);
            String classShortName = typeQName.getLocalPart();
            String className = packageName + "." + classShortName;
            Class clazz = null;
            try {
                clazz = ClassLoading.loadClass((String)className, (Bundle)this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load java type", (Throwable)e);
            }
            Class<BeanSerializerFactory> serializerFactoryClass = BeanSerializerFactory.class;
            Class<BeanDeserializerFactory> deserializerFactoryClass = BeanDeserializerFactory.class;
            if (clazz.isArray()) {
                serializerFactoryClass = ArraySerializerFactory.class;
                deserializerFactoryClass = ArrayDeserializerFactory.class;
            }
            TypeInfo.UpdatableTypeInfo internalTypeInfo = new TypeInfo.UpdatableTypeInfo();
            internalTypeInfo.setClazz(clazz);
            internalTypeInfo.setQName(typeQName);
            internalTypeInfo.setSerializerClass(serializerFactoryClass);
            internalTypeInfo.setDeserializerClass(deserializerFactoryClass);
            this.populateInternalTypeInfo(clazz, typeQName, key, internalTypeInfo);
            typeInfoList.add(internalTypeInfo.buildTypeInfo());
        }
        return typeInfoList;
    }

    private void populateInternalTypeInfo(Class javaClass, QName typeQName, SchemaTypeKey key, TypeInfo.UpdatableTypeInfo typeInfo) throws DeploymentException {
        PropertyDescriptor[] descriptors;
        SchemaType schemaType = (SchemaType)this.schemaTypeKeyToSchemaTypeMap.get(key);
        if (schemaType == null) {
            throw new DeploymentException("Schema type key " + key + " not found in analyzed schema: " + this.schemaTypeKeyToSchemaTypeMap);
        }
        typeInfo.setCanSearchParents(schemaType.getDerivationType() == 1);
        HashMap<QName, SchemaParticle> nameToType = new HashMap<QName, SchemaParticle>();
        if (null != schemaType.getContentModel()) {
            if (3 == schemaType.getContentModel().getParticleType() || 1 == schemaType.getContentModel().getParticleType()) {
                SchemaParticle[] properties = schemaType.getContentModel().getParticleChildren();
                for (int i = 0; i < properties.length; ++i) {
                    SchemaParticle parameter = properties[i];
                    nameToType.put(parameter.getName(), parameter);
                }
            } else if (4 == schemaType.getContentModel().getParticleType()) {
                SchemaParticle parameter = schemaType.getContentModel();
                nameToType.put(parameter.getName(), parameter);
            } else {
                throw new DeploymentException("Only all, choice and sequence particle types are supported. SchemaType name =" + schemaType.getName());
            }
        }
        try {
            descriptors = Introspector.getBeanInfo(javaClass).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new DeploymentException("Class " + javaClass + " is not a valid javabean", (Throwable)e);
        }
        HashMap nameToClass = new HashMap();
        for (int i = 0; i < descriptors.length; ++i) {
            nameToClass.put(descriptors[i].getName(), descriptors[i].getPropertyType());
        }
        int idx = 0;
        FieldDesc[] fields = new FieldDesc[nameToType.size()];
        typeInfo.setFields(fields);
        for (Map.Entry entry : nameToType.entrySet()) {
            QName fieldQName = (QName)entry.getKey();
            String fieldName = fieldQName.getLocalPart();
            SchemaParticle particle = (SchemaParticle)entry.getValue();
            ElementDesc elementDesc = new ElementDesc();
            elementDesc.setFieldName(fieldName);
            Class javaType = (Class)nameToClass.get(fieldName);
            if (null == javaType) {
                throw new DeploymentException("Field " + fieldName + " is not defined by class " + javaClass.getName());
            }
            elementDesc.setNillable(particle.isNillable());
            elementDesc.setXmlName(fieldQName);
            elementDesc.setXmlType(particle.getType().getName());
            if (javaType.isArray()) {
                elementDesc.setMinOccurs(particle.getIntMinOccurs());
                elementDesc.setMaxOccurs(particle.getIntMaxOccurs());
                elementDesc.setMaxOccursUnbounded(particle.getIntMaxOccurs() > 1);
            }
            fields[idx++] = elementDesc;
        }
    }
}

