/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.lang.reflect.Method;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.soap.SOAPConstants;
import org.apache.geronimo.axis.builder.OperationDescBuilder;
import org.apache.geronimo.axis.client.OperationInfo;
import org.apache.geronimo.common.DeploymentException;
import org.objectweb.asm.Type;

public class LightweightOperationDescBuilder
extends OperationDescBuilder {
    private final Method method;

    public LightweightOperationDescBuilder(BindingOperation bindingOperation, Method method) throws DeploymentException {
        super(bindingOperation);
        if (bindingOperation == null) {
            throw new DeploymentException("No BindingOperation supplied for method " + method.getName());
        }
        this.method = method;
        this.operationDesc.setName(this.operationName);
        this.operationDesc.setStyle(Style.RPC);
        this.operationDesc.setUse(Use.ENCODED);
    }

    @Override
    public OperationInfo buildOperationInfo(SOAPConstants soapVersion) throws DeploymentException {
        this.buildOperationDesc();
        String soapActionURI = this.soapOperation.getSoapActionURI();
        boolean usesSOAPAction = soapActionURI != null;
        QName operationQName = this.getOperationNameFromSOAPBody();
        String methodName = this.method.getName();
        String methodDesc = Type.getMethodDescriptor((Method)this.method);
        OperationInfo operationInfo = new OperationInfo(this.operationDesc, usesSOAPAction, soapActionURI, soapVersion, operationQName, methodName, methodDesc);
        return operationInfo;
    }

    @Override
    public OperationDesc buildOperationDesc() throws DeploymentException {
        if (this.built) {
            return this.operationDesc;
        }
        this.built = true;
        this.operationDesc.setMethod(this.method);
        Class<?>[] methodParamTypes = this.method.getParameterTypes();
        List inputParts = this.input.getOrderedParts(null);
        if (methodParamTypes.length != inputParts.size()) {
            throw new DeploymentException("mismatch in parameter counts: method has " + methodParamTypes.length + " whereas the input message has " + inputParts.size());
        }
        int i = 0;
        for (Part part : inputParts) {
            String partName = part.getName();
            QName name = new QName("", partName);
            byte mode = 1;
            QName typeQName = part.getTypeName() == null ? part.getElementName() : part.getTypeName();
            Class<?> javaClass = methodParamTypes[i++];
            ParameterDesc parameter = new ParameterDesc(name, mode, typeQName, javaClass, false, false);
            this.operationDesc.addParameter(parameter);
        }
        if (this.output != null && this.output.getParts().size() > 1) {
            throw new DeploymentException("Lightweight mapping has at most one part in the (optional) output message, not: " + this.output.getParts().size());
        }
        if (this.output != null && this.output.getParts().size() == 1) {
            Part part = (Part)this.output.getParts().values().iterator().next();
            QName returnName = part.getElementName() == null ? new QName(part.getName()) : part.getElementName();
            this.operationDesc.setReturnQName(returnName);
            QName returnType = part.getTypeName() == null ? part.getElementName() : part.getTypeName();
            this.operationDesc.setReturnType(returnType);
            this.operationDesc.setReturnClass(this.method.getReturnType());
        }
        return this.operationDesc;
    }
}

