/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import org.apache.geronimo.axis.server.EjbWebServiceGBean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.jee.oejb2.AuthMethodType;
import org.apache.openejb.jee.oejb2.EnterpriseBean;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb2.SessionBeanType;
import org.apache.openejb.jee.oejb2.WebServiceBindingType;
import org.apache.openejb.jee.oejb2.WebServiceSecurityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisModuleBuilderExtension
implements ModuleBuilderExtension {
    private WebServiceBuilder axisBuilder;
    private Environment defaultEnvironment;
    private AbstractNameQuery listener;
    public static final GBeanInfo GBEAN_INFO;

    public AxisModuleBuilderExtension() {
        this(null, null, null);
    }

    public AxisModuleBuilderExtension(WebServiceBuilder wsBuilder, Environment defaultEnvironment, AbstractNameQuery listener) {
        this.axisBuilder = wsBuilder;
        this.defaultEnvironment = defaultEnvironment;
        this.listener = listener;
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (module.getType() != ConfigurationModuleType.EJB) {
            return;
        }
        EjbModule ejbModule = (EjbModule)module;
        HashMap<String, String> correctedPortLocations = new HashMap<String, String>();
        Map<String, WebServiceBinding> wsBindingMap = this.createWebServiceBindingMap(ejbModule);
        for (Map.Entry<String, WebServiceBinding> entry : wsBindingMap.entrySet()) {
            String location = entry.getValue().getWebServiceAddress();
            if (location == null) continue;
            if (!(location = location.trim()).startsWith("/")) {
                location = "/" + location;
            }
            correctedPortLocations.put(entry.getKey(), location);
        }
        this.axisBuilder.findWebServices(module, true, correctedPortLocations, environment, ejbModule.getSharedContext());
        if (this.defaultEnvironment != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        if (module.getType() != ConfigurationModuleType.EJB) {
            return;
        }
        EjbModule ejbModule = (EjbModule)module;
        Map<String, WebServiceBinding> wsBindingMap = this.createWebServiceBindingMap(ejbModule);
        for (EnterpriseBeanInfo bean : ejbModule.getEjbJarInfo().enterpriseBeans) {
            boolean secured;
            boolean getProtected;
            WebServiceSecurityType wsSecurity;
            if (bean.type != 2) continue;
            String ejbName = bean.ejbName;
            AbstractName sessionName = earContext.getNaming().createChildName(module.getModuleName(), ejbName, "StatelessSessionBean");
            assert (sessionName != null) : "StatelesSessionBean object name is null";
            WebServiceBinding wsBinding = wsBindingMap.get(ejbName);
            if (wsBinding == null || (wsSecurity = wsBinding.getWebServiceSecurity()) == null) continue;
            earContext.setHasSecurity(true);
            String policyContextID = sessionName.toString();
            Properties properties = wsSecurity.getProperties();
            Permissions uncheckedPermissions = new Permissions();
            String transportGuarantee = wsSecurity.getTransportGuarantee().toString().trim();
            boolean bl = getProtected = properties.get("getProtected") == null ? true : Boolean.valueOf((String)properties.get("getProtected"));
            if (getProtected) {
                WebUserDataPermission webUserDataPermission = new WebUserDataPermission("/*", null, transportGuarantee);
                ((PermissionCollection)uncheckedPermissions).add((Permission)webUserDataPermission);
            } else {
                ((PermissionCollection)uncheckedPermissions).add((Permission)new WebUserDataPermission("/*", new String[]{"GET"}, "NONE"));
                ((PermissionCollection)uncheckedPermissions).add((Permission)new WebUserDataPermission("/*", "!GET:" + transportGuarantee));
            }
            HashMap rolePermissions = new HashMap();
            boolean bl2 = secured = wsSecurity.getAuthMethod() != null && AuthMethodType.NONE != wsSecurity.getAuthMethod();
            if (secured) {
                boolean getSecured;
                boolean bl3 = getSecured = properties.get("getSecured") == null ? true : Boolean.valueOf((String)properties.get("getSecured"));
                if (!getSecured) {
                    ((PermissionCollection)uncheckedPermissions).add((Permission)new WebResourcePermission("/*", "GET"));
                }
            } else {
                ((PermissionCollection)uncheckedPermissions).add((Permission)new WebResourcePermission("/*", (String[])null));
            }
            ComponentPermissions permissions = new ComponentPermissions((PermissionCollection)new Permissions(), (PermissionCollection)uncheckedPermissions, rolePermissions);
            earContext.addSecurityContext(policyContextID, (Object)permissions);
        }
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        if (module.getType() != ConfigurationModuleType.EJB) {
            return;
        }
        EjbModule ejbModule = (EjbModule)module;
        Map<String, WebServiceBinding> wsBindingMap = this.createWebServiceBindingMap(ejbModule);
        AbstractNameQuery ejbModuleName = NameFactory.newTypeNameQuery((Artifact)module.getEarContext().getConfigID(), (String)"EJBModule", (String)module.getName());
        for (EnterpriseBeanInfo bean : ejbModule.getEjbJarInfo().enterpriseBeans) {
            if (bean.type != 2) continue;
            String ejbName = bean.ejbName;
            AbstractName sessionName = earContext.getNaming().createChildName(module.getModuleName(), ejbName, "StatelessSessionBean");
            assert (sessionName != null) : "StatelesSessionBean object name is null";
            AbstractName ejbWebServiceName = earContext.getNaming().createChildName(sessionName, ejbName, "WSLink");
            GBeanData ejbWebServiceGBean = new GBeanData(ejbWebServiceName, EjbWebServiceGBean.class);
            ejbWebServiceGBean.setAttribute("ejbName", (Object)ejbName);
            ejbWebServiceGBean.setAttribute("ejbClass", (Object)bean.ejbClass);
            WebServiceBinding wsBinding = wsBindingMap.get(ejbName);
            if (wsBinding != null) {
                WebServiceSecurityType wsSecurity;
                List<String> ddVirtualHosts = wsBinding.getWebServiceVirtualHost();
                if (ddVirtualHosts != null) {
                    String[] virtualHosts = new String[ddVirtualHosts.size()];
                    for (int i = 0; i < ddVirtualHosts.size(); ++i) {
                        virtualHosts[i] = ddVirtualHosts.get(i).trim();
                    }
                    ejbWebServiceGBean.setAttribute("virtualHosts", (Object)virtualHosts);
                }
                if ((wsSecurity = wsBinding.getWebServiceSecurity()) != null) {
                    ejbWebServiceGBean.setReferencePattern("ConfigurationFactory", new AbstractNameQuery(null, Collections.singletonMap("name", wsSecurity.getSecurityRealmName().trim()), ConfigurationFactory.class.getName()));
                    ejbWebServiceGBean.setAttribute("authMethod", (Object)wsSecurity.getAuthMethod().value());
                    if (wsSecurity.getRealmName() != null) {
                        ejbWebServiceGBean.setAttribute("realmName", (Object)wsSecurity.getRealmName().trim());
                    }
                    Properties properties = wsSecurity.getProperties();
                    ejbWebServiceGBean.setAttribute("properties", (Object)properties);
                    String policyContextID = sessionName.toString();
                    ejbWebServiceGBean.setAttribute("policyContextID", (Object)policyContextID);
                }
            }
            ejbWebServiceGBean.addDependency(ejbModuleName);
            if (this.axisBuilder.configureEJB(ejbWebServiceGBean, ejbName, (Module)ejbModule, ejbModule.getSharedContext(), cl)) {
                try {
                    earContext.addGBean(ejbWebServiceGBean);
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new DeploymentException("Could not add axis ejb web service gbean to context", (Throwable)e);
                }
                if (this.listener != null) {
                    ejbWebServiceGBean.setReferencePattern("WebServiceContainer", this.listener);
                }
                ejbWebServiceGBean.setReferencePattern("EjbDeployment", sessionName);
            }
            ejbWebServiceGBean.clearAttribute("ejbName");
            ejbWebServiceGBean.clearAttribute("ejbClass");
        }
    }

    private Map<String, WebServiceBinding> createWebServiceBindingMap(EjbModule ejbModule) {
        HashMap<String, WebServiceBinding> wsBindingMap;
        block3: {
            block2: {
                wsBindingMap = new HashMap<String, WebServiceBinding>();
                Object openejbDD = ejbModule.getEjbModule().getAltDDs().get("openejb-jar.xml");
                if (!(openejbDD instanceof OpenejbJarType)) break block2;
                OpenejbJarType openejb = (OpenejbJarType)openejbDD;
                for (EnterpriseBean bean : openejb.getEnterpriseBeans()) {
                    if (!(bean instanceof SessionBeanType)) continue;
                    SessionBeanType sessioBean = (SessionBeanType)bean;
                    wsBindingMap.put(bean.getEjbName(), new WebServiceBinding(sessioBean));
                }
                break block3;
            }
            GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
            if (geronimoEjbJarType == null) break block3;
            for (WebServiceBindingType bt : geronimoEjbJarType.getWebServiceBinding()) {
                wsBindingMap.put(bt.getEjbName(), new WebServiceBinding(bt));
            }
        }
        return wsBindingMap;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(AxisModuleBuilderExtension.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilderExtension.class);
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("listener", AbstractNameQuery.class, true);
        infoBuilder.setConstructor(new String[]{"WebServiceBuilder", "defaultEnvironment", "listener"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebServiceBinding {
        private String address;
        private List<String> virtualHosts;
        private WebServiceSecurityType security;

        private WebServiceBinding(SessionBeanType bean) {
            this.address = bean.getWebServiceAddress();
            this.virtualHosts = bean.getWebServiceVirtualHost();
            this.security = bean.getWebServiceSecurity();
        }

        private WebServiceBinding(WebServiceBindingType bt) {
            this.address = bt.getWebServiceAddress();
            this.virtualHosts = bt.getWebServiceVirtualHost();
            if (bt.getWebServiceSecurity() != null) {
                this.security = new WebServiceSecurityType();
                this.security.setAuthMethod(bt.getWebServiceSecurity().getAuthMethod());
                this.security.setRealmName(bt.getWebServiceSecurity().getRealmName());
                this.security.setSecurityRealmName(bt.getWebServiceSecurity().getSecurityRealmName());
                this.security.setTransportGuarantee(bt.getWebServiceSecurity().getTransportGuarantee());
            }
        }

        public String getWebServiceAddress() {
            return this.address;
        }

        public List<String> getWebServiceVirtualHost() {
            return this.virtualHosts;
        }

        public WebServiceSecurityType getWebServiceSecurity() {
            return this.security;
        }
    }
}

