/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.axis.server.EjbWebServiceGBean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.WebServiceBindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisModuleBuilderExtension
implements ModuleBuilderExtension {
    private WebServiceBuilder axisBuilder;
    private Environment defaultEnvironment;
    private AbstractNameQuery listener;
    public static final GBeanInfo GBEAN_INFO;

    public AxisModuleBuilderExtension() {
        this(null, null, null);
    }

    public AxisModuleBuilderExtension(WebServiceBuilder wsBuilder, Environment defaultEnvironment, AbstractNameQuery listener) {
        this.axisBuilder = wsBuilder;
        this.defaultEnvironment = defaultEnvironment;
        this.listener = listener;
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (module.getType() != ConfigurationModuleType.EJB) {
            return;
        }
        EjbModule ejbModule = (EjbModule)module;
        HashMap<String, String> correctedPortLocations = new HashMap<String, String>();
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        if (geronimoEjbJarType != null) {
            for (WebServiceBindingType bt : geronimoEjbJarType.getWebServiceBinding()) {
                String location = bt.getWebServiceAddress();
                if (location == null) continue;
                if (!(location = location.trim()).startsWith("/")) {
                    location = "/" + location;
                }
                correctedPortLocations.put(bt.getEjbName(), location);
            }
        }
        this.axisBuilder.findWebServices(module, true, correctedPortLocations, environment, ejbModule.getSharedContext());
        if (this.defaultEnvironment != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        if (module.getType() != ConfigurationModuleType.EJB) {
            return;
        }
        EjbModule ejbModule = (EjbModule)module;
        Map<String, WebServiceBindingType> wsBindingMap = this.createWebServiceBindingMap(ejbModule);
        for (EnterpriseBeanInfo bean : ejbModule.getEjbJarInfo().enterpriseBeans) {
            if (bean.type != 2) continue;
            String ejbName = bean.ejbName;
            AbstractName sessionName = earContext.getNaming().createChildName(module.getModuleName(), ejbName, "StatelessSessionBean");
            assert (sessionName != null) : "StatelesSessionBean object name is null";
            AbstractName ejbWebServiceName = earContext.getNaming().createChildName(sessionName, ejbName, "WSLink");
            GBeanData ejbWebServiceGBean = new GBeanData(ejbWebServiceName, EjbWebServiceGBean.GBEAN_INFO);
            ejbWebServiceGBean.setAttribute("ejbName", (Object)ejbName);
            ejbWebServiceGBean.setAttribute("ejbClass", (Object)bean.ejbClass);
            WebServiceBindingType wsBinding = wsBindingMap.get(ejbName);
            if (wsBinding != null) {
                WebServiceBindingType.WebServiceSecurityType wsSecurity;
                List ddVirtualHosts = wsBinding.getWebServiceVirtualHost();
                if (ddVirtualHosts != null) {
                    String[] virtualHosts = new String[ddVirtualHosts.size()];
                    for (int i = 0; i < ddVirtualHosts.size(); ++i) {
                        virtualHosts[i] = ((String)ddVirtualHosts.get(i)).trim();
                    }
                    ejbWebServiceGBean.setAttribute("virtualHosts", (Object)virtualHosts);
                }
                if ((wsSecurity = wsBinding.getWebServiceSecurity()) != null) {
                    ejbWebServiceGBean.setAttribute("securityRealmName", (Object)wsSecurity.getSecurityRealmName().trim());
                    ejbWebServiceGBean.setAttribute("transportGuarantee", (Object)wsSecurity.getTransportGuarantee().toString());
                    ejbWebServiceGBean.setAttribute("authMethod", (Object)wsSecurity.getAuthMethod().value());
                    if (wsSecurity.getRealmName() != null) {
                        ejbWebServiceGBean.setAttribute("realmName", (Object)wsSecurity.getRealmName().trim());
                    }
                }
            }
            if (this.axisBuilder.configureEJB(ejbWebServiceGBean, ejbName, (Module)ejbModule, ejbModule.getSharedContext(), cl)) {
                try {
                    earContext.addGBean(ejbWebServiceGBean);
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new DeploymentException("Could not add axis ejb web service gbean to context", (Throwable)e);
                }
                if (this.listener != null) {
                    ejbWebServiceGBean.setReferencePattern("WebServiceContainer", this.listener);
                }
                ejbWebServiceGBean.setReferencePattern("EjbDeployment", sessionName);
            }
            ejbWebServiceGBean.clearAttribute("ejbName");
            ejbWebServiceGBean.clearAttribute("ejbClass");
        }
    }

    private Map<String, WebServiceBindingType> createWebServiceBindingMap(EjbModule ejbModule) {
        HashMap<String, WebServiceBindingType> wsBindingMap = new HashMap<String, WebServiceBindingType>();
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        if (geronimoEjbJarType != null) {
            for (WebServiceBindingType bt : geronimoEjbJarType.getWebServiceBinding()) {
                wsBindingMap.put(bt.getEjbName(), bt);
            }
        }
        return wsBindingMap;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(AxisModuleBuilderExtension.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilderExtension.class);
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("listener", AbstractNameQuery.class, true);
        infoBuilder.setConstructor(new String[]{"WebServiceBuilder", "defaultEnvironment", "listener"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

