/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.description.AttributeDesc;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DefaultJAXRPC11TypeMappingImpl;
import org.apache.axis.encoding.DefaultSOAPEncodingTypeMappingImpl;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.ArrayDeserializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.EnumDeserializerFactory;
import org.apache.axis.encoding.ser.EnumSerializerFactory;
import org.apache.axis.encoding.ser.SimpleListDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleListSerializerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis.builder.TypeInfoBuilder;
import org.apache.geronimo.axis.client.ArrayTypeInfo;
import org.apache.geronimo.axis.client.TypeInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.webservices.builder.SchemaTypeKey;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingType;
import org.apache.geronimo.xbeans.j2ee.JavaXmlTypeMappingType;
import org.apache.geronimo.xbeans.j2ee.VariableMappingType;
import org.apache.xmlbeans.SchemaLocalAttribute;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.soap.SOAPArrayType;
import org.apache.xmlbeans.soap.SchemaWSDLArrayType;

public class HeavyweightTypeInfoBuilder
implements TypeInfoBuilder {
    private static final String SOAP_ENCODING_NS = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final Log log = LogFactory.getLog((Class)HeavyweightTypeInfoBuilder.class);
    private final ClassLoader cl;
    private final Map schemaTypeKeyToSchemaTypeMap;
    private final Set wrapperElementQNames;
    private final Collection operations;
    private final boolean hasEncoded;

    public HeavyweightTypeInfoBuilder(ClassLoader cl, Map schemaTypeKeyToSchemaTypeMap, Set wrapperElementQNames, Collection operations, boolean hasEncoded) {
        this.cl = cl;
        this.schemaTypeKeyToSchemaTypeMap = schemaTypeKeyToSchemaTypeMap;
        this.wrapperElementQNames = wrapperElementQNames;
        this.operations = operations;
        this.hasEncoded = hasEncoded;
    }

    public List buildTypeInfo(JavaWsdlMappingType mapping) throws DeploymentException {
        QName typeQName;
        SchemaTypeKey key;
        ArrayList<TypeInfo> typeInfoList = new ArrayList<TypeInfo>();
        HashSet<QName> mappedTypeQNames = new HashSet<QName>();
        JavaXmlTypeMappingType[] javaXmlTypeMappings = mapping.getJavaXmlTypeMappingArray();
        for (int j = 0; j < javaXmlTypeMappings.length; ++j) {
            SchemaType schemaType;
            JavaXmlTypeMappingType javaXmlTypeMapping = javaXmlTypeMappings[j];
            boolean isElement = javaXmlTypeMapping.getQnameScope().getStringValue().equals("element");
            boolean isSimpleType = javaXmlTypeMapping.getQnameScope().getStringValue().equals("simpleType");
            if (javaXmlTypeMapping.isSetRootTypeQname()) {
                QName typeQName2 = javaXmlTypeMapping.getRootTypeQname().getQNameValue();
                key = new SchemaTypeKey(typeQName2, isElement, isSimpleType, false, null);
                if (this.wrapperElementQNames.contains(typeQName2)) {
                    continue;
                }
            } else if (javaXmlTypeMapping.isSetAnonymousTypeQname()) {
                String anonTypeQNameString = javaXmlTypeMapping.getAnonymousTypeQname().getStringValue();
                int pos = anonTypeQNameString.lastIndexOf(":");
                if (pos == -1) {
                    throw new DeploymentException("anon QName is invalid, no final ':' " + anonTypeQNameString);
                }
                typeQName = new QName(anonTypeQNameString.substring(0, pos), anonTypeQNameString.substring(pos + 1));
                key = new SchemaTypeKey(typeQName, isElement, isSimpleType, true, null);
                if (this.wrapperElementQNames.contains(new QName(anonTypeQNameString.substring(0, pos), anonTypeQNameString.substring(pos + 2)))) {
                    continue;
                }
            } else {
                throw new DeploymentException("either root type qname or anonymous type qname must be set");
            }
            if ((schemaType = (SchemaType)this.schemaTypeKeyToSchemaTypeMap.get(key)) == null) {
                if (null != TypeMappingLookup.getFactoryPair(key.getqName())) continue;
                log.warn((Object)("Schema type key " + key + " not found in analyzed schema: " + this.schemaTypeKeyToSchemaTypeMap));
                continue;
            }
            mappedTypeQNames.add(key.getqName());
            String className = javaXmlTypeMapping.getJavaType().getStringValue().trim();
            Class clazz = null;
            try {
                clazz = ClassLoading.loadClass((String)className, (ClassLoader)this.cl);
            }
            catch (ClassNotFoundException e2) {
                throw new DeploymentException("Could not load java type", (Throwable)e2);
            }
            TypeInfo.UpdatableTypeInfo internalTypeInfo = this.defineSerializerPair(schemaType, clazz);
            this.populateInternalTypeInfo(clazz, key, schemaType, javaXmlTypeMapping, internalTypeInfo);
            typeInfoList.add(internalTypeInfo.buildTypeInfo());
        }
        HashMap<QName, SchemaTypeKey> qNameToKey = new HashMap<QName, SchemaTypeKey>();
        Iterator<Object> iter = this.schemaTypeKeyToSchemaTypeMap.keySet().iterator();
        while (iter.hasNext()) {
            key = (SchemaTypeKey)iter.next();
            qNameToKey.put(key.getqName(), key);
        }
        iter = this.operations.iterator();
        while (iter.hasNext()) {
            OperationDesc operationDesc = (OperationDesc)iter.next();
            ArrayList<ParameterDesc> parameters = new ArrayList<ParameterDesc>(operationDesc.getParameters());
            ParameterDesc returnParameterDesc = operationDesc.getReturnParamDesc();
            if (null != returnParameterDesc.getTypeQName() && !returnParameterDesc.getTypeQName().equals(XMLType.AXIS_VOID)) {
                parameters.add(returnParameterDesc);
            }
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
                typeQName = parameterDesc.getTypeQName();
                if (null == typeQName || mappedTypeQNames.contains(typeQName) || typeQName.getNamespaceURI().equals(XML_SCHEMA_NS) || typeQName.getNamespaceURI().equals(SOAP_ENCODING_NS)) continue;
                SchemaTypeKey key2 = (SchemaTypeKey)qNameToKey.get(typeQName);
                if (null == key2) {
                    log.warn((Object)("Type QName [" + typeQName + "] defined by operation [" + operationDesc + "] has not been found in schema: " + this.schemaTypeKeyToSchemaTypeMap));
                    continue;
                }
                SchemaType schemaType = (SchemaType)this.schemaTypeKeyToSchemaTypeMap.get(key2);
                mappedTypeQNames.add(key2.getqName());
                if (!schemaType.isSimpleType() && !parameterDesc.getJavaType().isArray()) {
                    if (mappedTypeQNames.contains(schemaType.getName())) continue;
                    log.warn((Object)("Operation [" + operationDesc + "] uses XML type [" + schemaType + "], whose mapping is not declared by the jaxrpc mapping file.\n Continuing deployment; " + "yet, the deployment is not-portable."));
                    continue;
                }
                Class clazz = parameterDesc.getJavaType();
                TypeInfo.UpdatableTypeInfo internalTypeInfo = this.defineSerializerPair(schemaType, clazz);
                this.setTypeQName(internalTypeInfo, key2);
                internalTypeInfo.setFields(new FieldDesc[0]);
                typeInfoList.add(internalTypeInfo.buildTypeInfo());
            }
        }
        return typeInfoList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeInfo.UpdatableTypeInfo defineSerializerPair(SchemaType schemaType, Class clazz) throws DeploymentException {
        TypeInfo.UpdatableTypeInfo internalTypeInfo = new TypeInfo.UpdatableTypeInfo();
        Class serializerFactoryClass = null;
        Class deserializerFactoryClass = null;
        if (schemaType.isSimpleType()) {
            if (1 == schemaType.getSimpleVariety()) {
                if (clazz.isArray()) {
                    internalTypeInfo = new ArrayTypeInfo.UpdatableArrayTypeInfo();
                    serializerFactoryClass = ArraySerializerFactory.class;
                    deserializerFactoryClass = ArrayDeserializerFactory.class;
                } else if (null != schemaType.getEnumerationValues()) {
                    serializerFactoryClass = EnumSerializerFactory.class;
                    deserializerFactoryClass = EnumDeserializerFactory.class;
                } else {
                    QName typeQName = schemaType.getPrimitiveType().getName();
                    FactoryPair pair = TypeMappingLookup.getFactoryPair(typeQName);
                    if (null == pair) {
                        throw new DeploymentException("Primitive type [" + typeQName + "] is not registered.");
                    }
                    serializerFactoryClass = pair.serializerFactoryClass;
                    deserializerFactoryClass = pair.deserializerFactoryClass;
                }
            } else {
                if (3 != schemaType.getSimpleVariety()) throw new DeploymentException("Schema type [" + schemaType + "] is invalid.");
                serializerFactoryClass = SimpleListSerializerFactory.class;
                deserializerFactoryClass = SimpleListDeserializerFactory.class;
            }
        } else if (clazz.isArray()) {
            internalTypeInfo = new ArrayTypeInfo.UpdatableArrayTypeInfo();
            serializerFactoryClass = ArraySerializerFactory.class;
            deserializerFactoryClass = ArrayDeserializerFactory.class;
            QName componentType = null;
            SchemaLocalAttribute arrayTypeAttribute = schemaType.getAttributeModel().getAttribute(new QName(SOAP_ENCODING_NS, "arrayType"));
            if (arrayTypeAttribute != null) {
                SchemaWSDLArrayType wsdlArrayType = (SchemaWSDLArrayType)arrayTypeAttribute;
                SOAPArrayType soapArrayType = wsdlArrayType.getWSDLArrayType();
                if (soapArrayType != null) {
                    componentType = soapArrayType.getQName();
                    log.debug((Object)("extracted componentType " + componentType + " from schemaType " + schemaType));
                } else {
                    log.info((Object)("no SOAPArrayType for component from schemaType " + schemaType));
                }
            } else {
                log.warn((Object)("No soap array info for schematype: " + schemaType));
            }
            if (componentType == null && schemaType.getBaseType().getName().equals(new QName(SOAP_ENCODING_NS, "Array"))) {
                SchemaProperty[] properties = schemaType.getDerivedProperties();
                if (properties.length != 1) {
                    throw new DeploymentException("more than one element inside array definition: " + schemaType);
                }
                componentType = properties[0].getType().getName();
                log.debug((Object)"determined component type from element type");
            }
            ((ArrayTypeInfo.UpdatableArrayTypeInfo)internalTypeInfo).setComponentType(componentType);
        } else {
            QName typeQName;
            if (2 == schemaType.getContentType()) {
                typeQName = schemaType.getBaseType().getName();
            } else {
                if (1 != schemaType.getContentType() && 3 != schemaType.getContentType() && 4 != schemaType.getContentType()) throw new DeploymentException("Schema type [" + schemaType + "] is invalid.");
                typeQName = schemaType.getName();
            }
            FactoryPair pair = TypeMappingLookup.getFactoryPair(typeQName);
            if (null != pair) {
                serializerFactoryClass = pair.serializerFactoryClass;
                deserializerFactoryClass = pair.deserializerFactoryClass;
            } else {
                serializerFactoryClass = BeanSerializerFactory.class;
                deserializerFactoryClass = BeanDeserializerFactory.class;
            }
        }
        internalTypeInfo.setClazz(clazz);
        internalTypeInfo.setSerializerClass(serializerFactoryClass);
        internalTypeInfo.setDeserializerClass(deserializerFactoryClass);
        return internalTypeInfo;
    }

    private void setTypeQName(TypeInfo.UpdatableTypeInfo typeInfo, SchemaTypeKey key) {
        QName axisKey = key.getElementQName();
        if (axisKey == null) {
            axisKey = key.getqName();
        }
        typeInfo.setQName(axisKey);
    }

    private void populateInternalTypeInfo(Class javaClass, SchemaTypeKey key, SchemaType schemaType, JavaXmlTypeMappingType javaXmlTypeMapping, TypeInfo.UpdatableTypeInfo typeInfo) throws DeploymentException {
        int i;
        String ns = key.getqName().getNamespaceURI();
        typeInfo.setCanSearchParents(schemaType.getDerivationType() == 1);
        this.setTypeQName(typeInfo, key);
        HashMap<QName, SchemaParticle> paramNameToType = new HashMap<QName, SchemaParticle>();
        if (null != schemaType.getContentModel()) {
            if (3 == schemaType.getContentModel().getParticleType() || 1 == schemaType.getContentModel().getParticleType()) {
                SchemaParticle[] properties = schemaType.getContentModel().getParticleChildren();
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    SchemaParticle parameter = properties[i2];
                    paramNameToType.put(parameter.getName(), parameter);
                }
            } else if (4 == schemaType.getContentModel().getParticleType()) {
                SchemaParticle parameter = schemaType.getContentModel();
                paramNameToType.put(parameter.getName(), parameter);
            } else {
                throw new DeploymentException("Only element, sequence, and all particle types are supported. SchemaType name =" + schemaType.getName());
            }
        }
        HashMap<String, SchemaLocalAttribute> attNameToType = new HashMap<String, SchemaLocalAttribute>();
        if (null != schemaType.getAttributeModel()) {
            SchemaLocalAttribute[] attributes = schemaType.getAttributeModel().getAttributes();
            for (int i3 = 0; i3 < attributes.length; ++i3) {
                SchemaLocalAttribute attribute = attributes[i3];
                SchemaLocalAttribute old = attNameToType.put(attribute.getName().getLocalPart(), attribute);
                if (old == null) continue;
                throw new DeploymentException("Complain to your expert group member, spec does not support attributes with the same local name and differing namespaces: original: " + old + ", duplicate local name: " + attribute);
            }
        }
        VariableMappingType[] variableMappings = javaXmlTypeMapping.getVariableMappingArray();
        if (javaClass.isArray()) {
            if (0 != variableMappings.length) {
                log.warn((Object)("Ignoring variable-mapping defined for class " + javaClass + " which is an array."));
            }
            typeInfo.setFields(new FieldDesc[0]);
            return;
        }
        FieldDesc[] fields = new FieldDesc[variableMappings.length];
        typeInfo.setFields(fields);
        PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[]{};
        try {
            propertyDescriptors = Introspector.getBeanInfo(javaClass).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new DeploymentException("Class " + javaClass + " is not a valid javabean", (Throwable)e);
        }
        HashMap properties = new HashMap();
        for (i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            properties.put(propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
        }
        for (i = 0; i < variableMappings.length; ++i) {
            QName xmlName;
            SchemaParticle particle;
            Class<?> javaType;
            VariableMappingType variableMapping = variableMappings[i];
            String fieldName = variableMapping.getJavaVariableName().getStringValue().trim();
            if (variableMapping.isSetXmlAttributeName()) {
                AttributeDesc attributeDesc = new AttributeDesc();
                attributeDesc.setFieldName(fieldName);
                javaType = (Class<?>)properties.get(fieldName);
                if (javaType == null) {
                    throw new DeploymentException("field name " + fieldName + " not found in " + properties);
                }
                String attributeLocalName = variableMapping.getXmlAttributeName().getStringValue().trim();
                QName xmlName2 = new QName("", attributeLocalName);
                attributeDesc.setXmlName(xmlName2);
                SchemaLocalAttribute attribute = (SchemaLocalAttribute)attNameToType.get(attributeLocalName);
                if (null == attribute) {
                    throw new DeploymentException("attribute " + xmlName2 + " not found in schema " + schemaType.getName());
                }
                attributeDesc.setXmlType(attribute.getType().getName());
                fields[i] = attributeDesc;
                continue;
            }
            ElementDesc elementDesc = new ElementDesc();
            elementDesc.setFieldName(fieldName);
            javaType = (Class)properties.get(fieldName);
            if (javaType == null) {
                try {
                    Field field = javaClass.getField(fieldName);
                    javaType = field.getType();
                }
                catch (NoSuchFieldException e) {
                    throw new DeploymentException("field name " + fieldName + " not found in " + properties);
                }
            }
            if (null == (particle = (SchemaParticle)paramNameToType.get(xmlName = new QName("", variableMapping.getXmlElementName().getStringValue().trim())))) {
                xmlName = new QName(ns, variableMapping.getXmlElementName().getStringValue().trim());
                particle = (SchemaParticle)paramNameToType.get(xmlName);
                if (null == particle) {
                    throw new DeploymentException("element " + xmlName + " not found in schema " + schemaType.getName());
                }
            } else if (4 != particle.getParticleType()) {
                throw new DeploymentException(xmlName + " is not an element in schema " + schemaType.getName());
            }
            elementDesc.setNillable(particle.isNillable() || this.hasEncoded);
            elementDesc.setXmlName(xmlName);
            if (null != particle.getType().getName()) {
                elementDesc.setXmlType(particle.getType().getName());
            } else {
                QName anonymousName = key.isAnonymous() ? new QName(key.getqName().getNamespaceURI(), key.getqName().getLocalPart() + ">" + particle.getName().getLocalPart()) : new QName(key.getqName().getNamespaceURI(), ">" + key.getqName().getLocalPart() + ">" + particle.getName().getLocalPart());
                elementDesc.setXmlType(anonymousName);
            }
            if (javaType.isArray()) {
                elementDesc.setMinOccurs(particle.getIntMinOccurs());
                elementDesc.setMaxOccurs(particle.getIntMaxOccurs());
                elementDesc.setMaxOccursUnbounded(particle.getIntMaxOccurs() > 1);
            }
            fields[i] = elementDesc;
        }
    }

    private static class FactoryPair {
        private final Class serializerFactoryClass;
        private final Class deserializerFactoryClass;

        private FactoryPair(Class serializerFactoryClass, Class deserializerFactoryClass) {
            this.serializerFactoryClass = serializerFactoryClass;
            this.deserializerFactoryClass = deserializerFactoryClass;
        }
    }

    private static class TypeMappingLookup {
        private static final TypeMappingImpl SOAP_TM = DefaultSOAPEncodingTypeMappingImpl.getSingleton();
        private static final TypeMappingImpl JAXRPC_TM = DefaultJAXRPC11TypeMappingImpl.getSingleton();

        private TypeMappingLookup() {
        }

        public static FactoryPair getFactoryPair(QName xmlType) {
            DeserializerFactory df;
            SerializerFactory sf;
            Class clazz = SOAP_TM.getClassForQName(xmlType, null, null);
            if (null != clazz) {
                sf = SOAP_TM.getSerializer(clazz, xmlType);
                df = SOAP_TM.getDeserializer(clazz, xmlType, null);
            } else {
                clazz = JAXRPC_TM.getClassForQName(xmlType, null, null);
                if (null == clazz) {
                    return null;
                }
                sf = JAXRPC_TM.getSerializer(clazz, xmlType);
                df = JAXRPC_TM.getDeserializer(clazz, xmlType, null);
            }
            return new FactoryPair(sf.getClass(), df.getClass());
        }
    }
}

