/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import [Ljava.lang.String;;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.axis.builder.AxisBuilder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.HandlerInfoInfo;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.PortComponentRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefHandlerType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.geronimo.xbeans.j2ee.XsdQNameType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public class AxisServiceRefBuilder
extends AbstractNamingBuilder {
    private final QNameSet serviceRefQNameSet;
    private static final QName GER_SERVICE_REF_QNAME = GerServiceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_SERVICE_REF_QNAME_SET = QNameSet.singleton((QName)GER_SERVICE_REF_QNAME);
    private final AxisBuilder axisBuilder;
    public static final GBeanInfo GBEAN_INFO;

    public AxisServiceRefBuilder(Environment defaultEnvironment, String[] eeNamespaces, AxisBuilder axisBuilder) {
        super(defaultEnvironment);
        this.axisBuilder = axisBuilder;
        this.serviceRefQNameSet = AxisServiceRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"service-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.serviceRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] serviceRefsUntyped = AxisServiceRefBuilder.convert((XmlObject[])specDD.selectChildren(this.serviceRefQNameSet), (NamespaceElementConverter)J2EE_CONVERTER, (SchemaType)ServiceRefType.type);
        XmlObject[] gerServiceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_SERVICE_REF_QNAME_SET);
        Map serviceRefMap = AxisServiceRefBuilder.mapServiceRefs(gerServiceRefsUntyped);
        ClassLoader cl = module.getEarContext().getClassLoader();
        for (int i = 0; i < serviceRefsUntyped.length; ++i) {
            Class<?> serviceInterface;
            ServiceRefType serviceRef = (ServiceRefType)serviceRefsUntyped[i];
            String name = AxisServiceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceRefName());
            GerServiceRefType serviceRefType = (GerServiceRefType)serviceRefMap.get(name);
            String serviceInterfaceName = AxisServiceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceInterface());
            AxisServiceRefBuilder.assureInterface((String)serviceInterfaceName, (String)"javax.xml.rpc.Service", (String)"[Web]Service", (ClassLoader)cl);
            try {
                serviceInterface = cl.loadClass(serviceInterfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load service interface class: " + serviceInterfaceName, (Throwable)e);
            }
            URI wsdlURI = null;
            if (serviceRef.isSetWsdlFile()) {
                try {
                    wsdlURI = new URI(serviceRef.getWsdlFile().getStringValue().trim());
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("could not construct wsdl uri from " + serviceRef.getWsdlFile().getStringValue(), (Throwable)e);
                }
            }
            URI jaxrpcMappingURI = null;
            if (serviceRef.isSetJaxrpcMappingFile()) {
                try {
                    jaxrpcMappingURI = new URI(AxisServiceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getJaxrpcMappingFile()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct jaxrpc mapping uri from " + serviceRef.getJaxrpcMappingFile(), (Throwable)e);
                }
            }
            QName serviceQName = null;
            if (serviceRef.isSetServiceQname()) {
                serviceQName = serviceRef.getServiceQname().getQNameValue();
            }
            HashMap portComponentRefMap = new HashMap();
            PortComponentRefType[] portComponentRefs = serviceRef.getPortComponentRefArray();
            if (portComponentRefs != null) {
                for (int j = 0; j < portComponentRefs.length; ++j) {
                    Class<?> serviceEndpointClass;
                    PortComponentRefType portComponentRef = portComponentRefs[j];
                    String portComponentLink = AxisServiceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)portComponentRef.getPortComponentLink());
                    String serviceEndpointInterfaceType = AxisServiceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)portComponentRef.getServiceEndpointInterface());
                    AxisServiceRefBuilder.assureInterface((String)serviceEndpointInterfaceType, (String)"java.rmi.Remote", (String)"ServiceEndpoint", (ClassLoader)cl);
                    try {
                        serviceEndpointClass = cl.loadClass(serviceEndpointInterfaceType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentException("could not load service endpoint class " + serviceEndpointInterfaceType, (Throwable)e);
                    }
                    portComponentRefMap.put(serviceEndpointClass, portComponentLink);
                }
            }
            ServiceRefHandlerType[] handlers = serviceRef.getHandlerArray();
            List handlerInfos = AxisServiceRefBuilder.buildHandlerInfoList(handlers, cl);
            Object ref = this.axisBuilder.createService(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, (Object)serviceRefType, module, cl);
            this.getJndiContextMap(componentContext).put("env/" + name, ref);
        }
    }

    public QNameSet getSpecQNameSet() {
        return this.serviceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_SERVICE_REF_QNAME_SET;
    }

    private static List buildHandlerInfoList(ServiceRefHandlerType[] handlers, ClassLoader classLoader) throws DeploymentException {
        ArrayList<HandlerInfoInfo> handlerInfos = new ArrayList<HandlerInfoInfo>();
        for (int i = 0; i < handlers.length; ++i) {
            Class handlerClass;
            ServiceRefHandlerType handler = handlers[i];
            org.apache.geronimo.xbeans.j2ee.String[] portNameArray = handler.getPortNameArray();
            ArrayList<String> portNames = new ArrayList<String>();
            for (int j = 0; j < portNameArray.length; ++j) {
                portNames.add(portNameArray[j].getStringValue().trim());
            }
            String handlerClassName = handler.getHandlerClass().getStringValue().trim();
            try {
                handlerClass = ClassLoading.loadClass((String)handlerClassName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load handler class", (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            ParamValueType[] paramValues = handler.getInitParamArray();
            for (int j = 0; j < paramValues.length; ++j) {
                ParamValueType paramValue = paramValues[j];
                String paramName = paramValue.getParamName().getStringValue().trim();
                String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headerQNames = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headerQNames[j] = soapHeaderQName.getQNameValue();
            }
            HashSet<String> soapRoles = new HashSet<String>();
            for (int j = 0; j < handler.getSoapRoleArray().length; ++j) {
                String soapRole = handler.getSoapRoleArray(j).getStringValue().trim();
                soapRoles.add(soapRole);
            }
            HandlerInfoInfo handlerInfoInfo = new HandlerInfoInfo(new HashSet(portNames), handlerClass, config, headerQNames, soapRoles);
            handlerInfos.add(handlerInfoInfo);
        }
        return handlerInfos;
    }

    private static Map mapServiceRefs(XmlObject[] refs) {
        HashMap<String, GerServiceRefType> refMap = new HashMap<String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = (GerServiceRefType)refs[i].copy().changeType(GerServiceRefType.type);
                String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)AxisServiceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("eeNamespaces", String;.class, true, true);
        infoBuilder.addReference("AxisBuilder", AxisBuilder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces", "AxisBuilder"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

