/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationEvent;
import org.apache.aries.application.management.AriesApplicationListener;
import org.apache.aries.application.management.BundleInfo;
import org.apache.geronimo.aries.ApplicationGBean;
import org.apache.geronimo.aries.EBAArtifactTypeHandler;
import org.apache.geronimo.aries.GeronimoApplicationEvent;
import org.apache.geronimo.aries.GeronimoApplicationManager;
import org.apache.geronimo.aries.WebApplicationTracker;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.AbstractRepository;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.BundleUtil;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ApplicationInstaller
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationInstaller.class);
    private Kernel kernel;
    private BundleContext bundleContext;
    private AbstractName abstractName;
    private ServiceRegistration registration;
    private ConfigurationManager configurationManager;
    private WebApplicationTracker webApplicationTracker;
    private Collection<? extends Repository> repositories;
    private Collection<ConfigurationStore> configurationStores;
    private Environment defaultEnvironment;
    private GeronimoApplicationManager applicationManager;
    private Map<Artifact, AriesApplication> applicationMap;

    public ApplicationInstaller(@ParamReference(name="Store", namingType="ConfigurationStore") Collection<ConfigurationStore> configurationStores, @ParamReference(name="Repositories", namingType="Repository") Collection<? extends Repository> repositories, @ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName) throws GBeanNotFoundException {
        this.kernel = kernel;
        this.bundleContext = bundleContext;
        this.abstractName = abstractName;
        this.repositories = repositories;
        this.configurationStores = configurationStores;
        this.configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        this.defaultEnvironment = defaultEnvironment;
        this.webApplicationTracker = new WebApplicationTracker(bundleContext);
        this.applicationManager = new GeronimoApplicationManager(bundleContext);
        this.applicationMap = Collections.synchronizedMap(new HashMap());
    }

    public void doStart() throws Exception {
        this.registration = this.bundleContext.registerService(ApplicationInstaller.class.getName(), (Object)this, null);
        this.webApplicationTracker.start();
        this.applicationManager.doStart();
        for (Repository repository : this.repositories) {
            if (!(repository instanceof AbstractRepository)) continue;
            ((AbstractRepository)repository).setTypeHandler("eba", (ArtifactTypeHandler)new EBAArtifactTypeHandler(this));
        }
    }

    public void doStop() {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.webApplicationTracker.stop();
        this.applicationManager.doStop();
    }

    public void doFail() {
        this.doStop();
    }

    public GeronimoApplicationManager getGeronimoApplicationManager() {
        return this.applicationManager;
    }

    protected ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    protected WebApplicationTracker getWebApplicationTracker() {
        return this.webApplicationTracker;
    }

    protected void registerApplication(Artifact id, AriesApplication app) {
        this.applicationMap.put(id, app);
    }

    protected AriesApplication unregisterApplication(Artifact id) {
        AriesApplication app = this.applicationMap.remove(id);
        return app;
    }

    protected AriesApplication lookupApplication(Artifact id) {
        AriesApplication app = this.applicationMap.get(id);
        return app;
    }

    public DeploymentContext startInstall(AriesApplication app, File inPlaceLocation, ConfigurationStore targetConfigurationStore) throws ConfigurationAlreadyExistsException, IOException, DeploymentException {
        Artifact configId = ApplicationInstaller.getConfigId(app.getApplicationMetadata());
        targetConfigurationStore.createNewConfigurationDir(configId);
        Environment environment = new Environment();
        environment.setConfigId(configId);
        EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        Naming naming = this.kernel.getNaming();
        AbstractName moduleName = naming.createRootName(configId, configId.toString(), "AriesApplication");
        File tempDirectory = FileUtils.createTempDir();
        try {
            EBADeploymentContext context = new EBADeploymentContext(tempDirectory, null, environment, moduleName, ConfigurationModuleType.EBA, naming, this.configurationManager, null, this.bundleContext);
            context.flush();
            context.initializeConfiguration();
            if (inPlaceLocation == null) {
                this.registerApplication(configId, app);
            } else {
                this.storeInPlaceApplication(app, inPlaceLocation);
            }
            AbstractName name = naming.createChildName(moduleName, "AriesApplication", "GBean");
            GBeanData data = new GBeanData(name, ApplicationGBean.class);
            data.setAttribute("configId", (Object)configId);
            data.setAttribute("location", (Object)inPlaceLocation);
            data.setReferencePattern("Installer", this.abstractName);
            context.addGBean(data);
            return context;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Error deploying application", (Throwable)e);
        }
    }

    private static boolean getUnpackApplicationBundles() {
        String property = System.getProperty("org.apache.geronimo.aries.unpackApplicationBundles", "true");
        return Boolean.parseBoolean(property);
    }

    protected void storeApplication(AriesApplication app, File directory) throws IOException {
        this.storeApplication(app, directory, ApplicationInstaller.getUnpackApplicationBundles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeApplication(AriesApplication app, File directory, boolean unpack) throws IOException {
        ApplicationMetadata appMetadata = app.getApplicationMetadata();
        appMetadata.store(new File(directory, "META-INF/APPLICATION.MF"));
        DeploymentMetadata deploymentMetadata = app.getDeploymentMetadata();
        if (deploymentMetadata != null) {
            deploymentMetadata.store(new File(directory, "META-INF/DEPLOYMENT.MF"));
        }
        for (BundleInfo bi : app.getBundleInfo()) {
            InputStream in;
            block11: {
                String bundleLocation = bi.getLocation();
                String bundleFileName = bundleLocation.substring(bundleLocation.lastIndexOf(47) + 1);
                in = null;
                try {
                    URL bundleURL = new URL(bundleLocation);
                    in = bundleURL.openStream();
                    File target = new File(directory, bundleFileName);
                    if (unpack) {
                        target.mkdirs();
                        ZipInputStream zipIn = new ZipInputStream(in);
                        try {
                            JarUtils.unzipToDirectory((ZipInputStream)zipIn, (File)target);
                            break block11;
                        }
                        finally {
                            IOUtils.close((Closeable)zipIn);
                        }
                    }
                    FileOutputStream fileOut = new FileOutputStream(target);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)fileOut);
                    }
                    finally {
                        IOUtils.close((Closeable)fileOut);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(in);
                    throw throwable;
                }
            }
            IOUtils.close((Closeable)in);
        }
    }

    private void storeInPlaceApplication(AriesApplication app, File inPlaceLocation) throws IOException {
        DeploymentMetadata deploymentMetadata;
        File deploymentMF = new File(inPlaceLocation, "META-INF/DEPLOYMENT.MF");
        if (!deploymentMF.exists() && (deploymentMetadata = app.getDeploymentMetadata()) != null) {
            deploymentMetadata.store(deploymentMF);
        }
    }

    public ConfigurationData finishInstall(DeploymentContext context, ConfigurationStore targetConfigurationStore) throws ConfigurationAlreadyExistsException, DeploymentException {
        try {
            ConfigurationData configurationData = context.getConfigurationData();
            targetConfigurationStore.install(configurationData);
            ConfigurationData configurationData2 = configurationData;
            return configurationData2;
        }
        catch (Exception e) {
            throw new DeploymentException("Error installing application", (Throwable)e);
        }
        finally {
            try {
                context.close();
            }
            catch (IOException e) {}
        }
    }

    public void install(AriesApplication app) throws ConfigurationAlreadyExistsException, IOException, DeploymentException {
        ConfigurationStore store = this.configurationStores.iterator().next();
        if (store == null) {
            throw new DeploymentException("No ConfigurationStore");
        }
        DeploymentContext context = this.startInstall(app, null, store);
        ConfigurationData configurationData = this.finishInstall(context, store);
        try {
            this.configurationManager.loadConfiguration(configurationData.getId());
            this.configurationManager.startConfiguration(configurationData.getId());
        }
        catch (Exception e) {
            throw new DeploymentException("Error installing application", (Throwable)e);
        }
    }

    public static Artifact getConfigId(ApplicationMetadata metadata) {
        return BundleUtil.createArtifact((String)"application", (String)metadata.getApplicationSymbolicName(), (Version)metadata.getApplicationVersion());
    }

    protected File getApplicationLocation(Artifact artifactId) {
        for (Repository repository : this.repositories) {
            if (!repository.contains(artifactId)) continue;
            return repository.getLocation(artifactId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireApplicationEvent(AriesApplication application, AriesApplicationContext.ApplicationState state) {
        Collection references = null;
        try {
            references = this.bundleContext.getServiceReferences(AriesApplicationListener.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new Error(e);
        }
        if (references != null && !references.isEmpty()) {
            GeronimoApplicationEvent event = new GeronimoApplicationEvent(application, state);
            for (ServiceReference reference : references) {
                AriesApplicationListener listener = (AriesApplicationListener)this.bundleContext.getService(reference);
                if (listener == null) continue;
                try {
                    listener.applicationChanged((AriesApplicationEvent)event);
                }
                catch (Exception e) {
                    LOG.debug("Error calling AriesApplicationListener", (Throwable)e);
                }
                finally {
                    this.bundleContext.ungetService(reference);
                }
            }
        }
    }

    private class EBADeploymentContext
    extends DeploymentContext {
        public EBADeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection<Repository> repositories, BundleContext bundleContext) throws DeploymentException {
            super(baseDir, inPlaceConfigurationDir, environment, moduleName, moduleType, naming, configurationManager, repositories, bundleContext);
        }

        public void close() throws IOException, DeploymentException {
            super.close();
            ApplicationInstaller.this.unregisterApplication(this.moduleName.getArtifact());
        }
    }
}

