/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationContextManager;
import org.apache.aries.application.management.AriesApplicationResolver;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.geronimo.aries.ApplicationInstaller;
import org.apache.geronimo.aries.GeronimoApplication;
import org.apache.geronimo.aries.GeronimoApplicationContext;
import org.apache.geronimo.aries.GeronimoApplicationContextManager;
import org.apache.geronimo.aries.ResolverErrorAnalyzer;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ApplicationGBean
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationGBean.class);
    private final Bundle bundle;
    private final ApplicationInstaller installer;
    private final Artifact configId;
    private GeronimoApplication application;
    private AriesApplicationContext.ApplicationState applicationState;
    private Set<Bundle> applicationBundles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="configId") Artifact configId, @ParamReference(name="Installer") ApplicationInstaller installer) throws Exception {
        this.bundle = bundle;
        this.installer = installer;
        this.configId = configId;
        BundleContext bundleContext = bundle.getBundleContext();
        DeploymentMetadataFactory deploymentFactory = null;
        ApplicationMetadataFactory applicationFactory = null;
        ServiceReference deploymentFactoryReference = bundleContext.getServiceReference(DeploymentMetadataFactory.class.getName());
        ServiceReference applicationFactoryReference = bundleContext.getServiceReference(ApplicationMetadataFactory.class.getName());
        try {
            deploymentFactory = this.getService(deploymentFactoryReference, DeploymentMetadataFactory.class);
            applicationFactory = this.getService(applicationFactoryReference, ApplicationMetadataFactory.class);
            this.application = new GeronimoApplication(bundle, applicationFactory, deploymentFactory);
            this.install(deploymentFactory);
        }
        finally {
            if (deploymentFactory != null) {
                bundleContext.ungetService(deploymentFactoryReference);
            }
            if (applicationFactory != null) {
                bundleContext.ungetService(applicationFactoryReference);
            }
        }
        ServiceReference applicationManagerReference = bundleContext.getServiceReference(AriesApplicationContextManager.class.getName());
        GeronimoApplicationContextManager applicationManager = this.getService(applicationManagerReference, GeronimoApplicationContextManager.class);
        try {
            applicationManager.registerApplicationContext(new GeronimoApplicationContext(this));
        }
        finally {
            bundleContext.ungetService(applicationManagerReference);
        }
    }

    public long[] getApplicationContentBundleIds() {
        long[] ids = new long[this.applicationBundles.size()];
        int i = 0;
        for (Bundle content : this.applicationBundles) {
            ids[i++] = content.getBundleId();
        }
        return ids;
    }

    private Bundle getBundle(long bundleId) {
        for (Bundle content : this.applicationBundles) {
            if (content.getBundleId() != bundleId) continue;
            return content;
        }
        return null;
    }

    public String getApplicationContentBundleSymbolicName(long bundleId) {
        Bundle bundle = this.getBundle(bundleId);
        return bundle != null ? bundle.getSymbolicName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateApplicationContent(long bundleId, File bundleFile) throws Exception {
        ServiceReference reference;
        BundleContext context;
        block16: {
            Bundle targetBundle = this.getBundle(bundleId);
            if (targetBundle == null) {
                throw new IllegalArgumentException("Could not find bundle with id " + bundleId + " in the application");
            }
            String applicationName = this.application.getApplicationMetadata().getApplicationScope();
            String bundleName = targetBundle.getSymbolicName();
            LOG.info("Updating {} bundle in {} application", (Object)bundleName, (Object)applicationName);
            context = this.bundle.getBundleContext();
            reference = null;
            RefreshListener refreshListener = null;
            try {
                targetBundle.stop();
                FileInputStream fi = null;
                try {
                    fi = new FileInputStream(bundleFile);
                    targetBundle.update((InputStream)fi);
                }
                catch (Throwable throwable) {
                    IOUtils.close(fi);
                    throw throwable;
                }
                IOUtils.close((Closeable)fi);
                reference = context.getServiceReference(PackageAdmin.class.getName());
                PackageAdmin packageAdmin = (PackageAdmin)context.getService(reference);
                Bundle[] bundles = new Bundle[]{targetBundle};
                if (!packageAdmin.resolveBundles(bundles)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Updated ").append(bundleName).append(" bundle cannot be resolved.");
                    ResolverErrorAnalyzer errorAnalyzer = new ResolverErrorAnalyzer(context);
                    String resolverErrors = errorAnalyzer.getErrorsAsString(Arrays.asList(bundles));
                    if (resolverErrors != null) {
                        builder.append(" ").append(resolverErrors);
                    }
                    throw new BundleException(builder.toString());
                }
                HashSet<Bundle> dependents = new HashSet<Bundle>();
                this.collectDependentBundles(packageAdmin, dependents, targetBundle);
                if (!dependents.isEmpty()) {
                    String bundleListString = ApplicationGBean.bundleCollectionToString(dependents);
                    LOG.info("Update of {} bundle will cause the following bundles to be refreshed: {}", (Object)bundleName, (Object)bundleListString);
                }
                refreshListener = new RefreshListener();
                context.addFrameworkListener((FrameworkListener)refreshListener);
                packageAdmin.refreshPackages(bundles);
                try {
                    this.updateArchive(targetBundle, bundleFile);
                }
                catch (Exception e) {
                    LOG.warn("Error updating application archive with the new contents. Changes made might be gone next time the application or server is restarted.", (Object)e.getMessage());
                }
                refreshListener.waitForRefresh(10000);
                if (BundleUtils.canStart((Bundle)targetBundle)) {
                    targetBundle.start(1);
                }
                LOG.info("Bundle {} was successfully updated in {} application", (Object)bundleName, (Object)applicationName);
                if (refreshListener == null) break block16;
            }
            catch (Exception e) {
                try {
                    LOG.error("Error updating " + bundleName + " bundle in " + applicationName + " application", (Throwable)e);
                    throw new Exception("Error updating application: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    if (refreshListener != null) {
                        context.removeFrameworkListener(refreshListener);
                    }
                    if (reference != null) {
                        context.ungetService(reference);
                    }
                    throw throwable;
                }
            }
            context.removeFrameworkListener((FrameworkListener)refreshListener);
        }
        if (reference != null) {
            context.ungetService(reference);
        }
    }

    private void collectDependentBundles(PackageAdmin packageAdmin, Set<Bundle> dependents, Bundle bundle) {
        ExportedPackage[] exportedPackages = packageAdmin.getExportedPackages(bundle);
        if (exportedPackages != null) {
            for (ExportedPackage exportedPackage : exportedPackages) {
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (dependents.contains(importingBundle)) continue;
                    dependents.add(importingBundle);
                    this.collectDependentBundles(packageAdmin, dependents, importingBundle);
                }
            }
        }
    }

    private static String bundleCollectionToString(Collection<Bundle> bundles) {
        StringBuilder builder = new StringBuilder();
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            builder.append(bundle.getSymbolicName());
            builder.append(" [").append(bundle.getBundleId()).append("]");
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateArchive(Bundle bundle, File bundleFile) throws IOException {
        File newEbaArchive;
        File ebaArchive;
        block28: {
            ZipOutputStream newZipFile;
            ZipFile oldZipFile;
            block26: {
                ebaArchive = this.installer.getApplicationLocation(this.configId);
                if (ebaArchive == null || !ebaArchive.exists()) {
                    throw new IOException("Cannot locate application archive for " + this.configId);
                }
                newEbaArchive = new File(ebaArchive.getAbsoluteFile() + ".new");
                URI bundleLocation = URI.create(bundle.getLocation());
                String bundleNameInApp = bundleLocation.getPath();
                if (bundleNameInApp.startsWith("/")) {
                    bundleNameInApp = bundleNameInApp.substring(1);
                }
                LOG.debug("Updating {} application archive with new contents for {}", (Object)ebaArchive, (Object)bundleNameInApp);
                oldZipFile = null;
                newZipFile = null;
                newZipFile = new ZipOutputStream(new FileOutputStream(newEbaArchive));
                oldZipFile = new ZipFile(ebaArchive);
                Enumeration<? extends ZipEntry> entries = oldZipFile.entries();
                byte[] buffer = new byte[4096];
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    InputStream in = null;
                    if (entry.getName().equals(bundleNameInApp)) {
                        in = new FileInputStream(bundleFile);
                        LOG.debug("Updating contents of {} with {}", (Object)bundleNameInApp, (Object)bundleFile.getAbsolutePath());
                    } else {
                        in = oldZipFile.getInputStream(entry);
                    }
                    try {
                        newZipFile.putNextEntry(new ZipEntry(entry.getName()));
                        try {
                            int count;
                            while ((count = in.read(buffer)) > 0) {
                                newZipFile.write(buffer, 0, count);
                            }
                        }
                        finally {
                            newZipFile.closeEntry();
                        }
                    }
                    finally {
                        IOUtils.close((Closeable)in);
                    }
                }
                if (oldZipFile == null) break block26;
                try {
                    oldZipFile.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            IOUtils.close((Closeable)newZipFile);
            break block28;
            catch (IOException e) {
                block27: {
                    try {
                        LOG.debug("Error updating application archive", (Throwable)e);
                        if (oldZipFile == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (oldZipFile != null) {
                            try {
                                oldZipFile.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                        }
                        IOUtils.close(newZipFile);
                        throw throwable;
                    }
                    try {
                        oldZipFile.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                IOUtils.close((Closeable)newZipFile);
            }
        }
        if (ebaArchive.delete()) {
            if (!newEbaArchive.renameTo(ebaArchive)) {
                throw new IOException("Error renaming application archive");
            }
        } else {
            throw new IOException("Error deleting existing application archive");
        }
        LOG.debug("Application archive was successfully updated.");
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    protected AriesApplication getAriesApplication() {
        return this.application;
    }

    protected Set<Bundle> getApplicationContent() {
        return new HashSet<Bundle>(this.applicationBundles);
    }

    protected AriesApplicationContext.ApplicationState getApplicationState() {
        return this.applicationState;
    }

    private DeploymentMetadata getDeploymentMetadata(AriesApplicationResolver resolver, DeploymentMetadataFactory deploymentFactory) throws ResolverException {
        DeploymentMetadata meta = this.application.getDeploymentMetadata();
        if (meta == null) {
            LOG.debug("Resolving {} application.", (Object)this.application.getApplicationMetadata().getApplicationScope());
            Set requiredBundles = resolver.resolve((AriesApplication)this.application, new ResolveConstraint[0]);
            meta = deploymentFactory.createDeploymentMetadata((AriesApplication)this.application, requiredBundles);
            LOG.debug("Resolved application bundles: {} ", (Object)requiredBundles);
        } else {
            LOG.debug("Application {} is resolved.", (Object)this.application.getApplicationMetadata().getApplicationScope());
        }
        return meta;
    }

    private void install(DeploymentMetadataFactory deploymentFactory) throws Exception {
        BundleContext bundleContext = this.bundle.getBundleContext();
        AriesApplicationResolver resolver = null;
        PackageAdmin packageAdmin = null;
        ServiceReference resolverRef = bundleContext.getServiceReference(AriesApplicationResolver.class.getName());
        ServiceReference packageAdminRef = bundleContext.getServiceReference(PackageAdmin.class.getName());
        this.applicationBundles = new HashSet<Bundle>();
        try {
            resolver = this.getService(resolverRef, AriesApplicationResolver.class);
            DeploymentMetadata meta = this.getDeploymentMetadata(resolver, deploymentFactory);
            List deploymentContentsBundles = meta.getApplicationDeploymentContents();
            List provisionBundles = meta.getApplicationProvisionBundles();
            ArrayList bundlesToInstall = new ArrayList();
            bundlesToInstall.addAll(deploymentContentsBundles);
            bundlesToInstall.addAll(provisionBundles);
            packageAdmin = this.getService(packageAdminRef, PackageAdmin.class);
            for (DeploymentContent content : bundlesToInstall) {
                Version bundleVersion;
                String bundleSymbolicName = content.getContentName();
                Bundle contentBundle = this.findBundleInFramework(packageAdmin, bundleSymbolicName, bundleVersion = content.getExactVersion());
                if (contentBundle != null) {
                    for (DeploymentContent deploymentContent : deploymentContentsBundles) {
                        if (!deploymentContent.getContentName().equals(bundleSymbolicName) || !deploymentContent.getExactVersion().equals((Object)bundleVersion)) continue;
                        this.applicationBundles.add(contentBundle);
                    }
                    continue;
                }
                BundleInfo bundleInfo = this.findBundleInfoInApplication(bundleSymbolicName, bundleVersion);
                if (bundleInfo == null) {
                    bundleInfo = this.findBundleInfoUsingResolver(resolver, bundleSymbolicName, bundleVersion);
                }
                if (bundleInfo == null) {
                    throw new ManagementException("Cound not find bundles: " + bundleSymbolicName + "_" + bundleVersion);
                }
                contentBundle = bundleContext.installBundle(bundleInfo.getLocation());
                this.applicationBundles.add(contentBundle);
            }
        }
        catch (BundleException be) {
            for (Bundle bundle : this.applicationBundles) {
                bundle.uninstall();
            }
            this.applicationBundles.clear();
            throw be;
        }
        finally {
            if (resolver != null) {
                bundleContext.ungetService(resolverRef);
            }
            if (packageAdmin != null) {
                bundleContext.ungetService(packageAdminRef);
            }
        }
        this.applicationState = AriesApplicationContext.ApplicationState.INSTALLED;
    }

    private Bundle findBundleInFramework(PackageAdmin admin, String symbolicName, Version version) {
        String exactVersion = "[" + version + "," + version + "]";
        Bundle[] bundles = admin.getBundles(symbolicName, exactVersion);
        if (bundles != null && bundles.length == 1) {
            return bundles[0];
        }
        return null;
    }

    private BundleInfo findBundleInfoInApplication(String symbolicName, Version version) {
        for (BundleInfo info : this.application.getBundleInfo()) {
            if (!info.getSymbolicName().equals(symbolicName) || !info.getVersion().equals((Object)version)) continue;
            return info;
        }
        return null;
    }

    private BundleInfo findBundleInfoUsingResolver(AriesApplicationResolver resolver, String symbolicName, Version version) {
        return resolver.getBundleInfo(symbolicName, version);
    }

    private <T> T getService(ServiceReference ref, Class<T> type) throws ManagementException {
        Object service = null;
        if (ref != null) {
            service = this.bundle.getBundleContext().getService(ref);
        }
        if (service == null) {
            throw new ManagementException((Exception)new ServiceException(type.getName(), 1));
        }
        return type.cast(service);
    }

    private static boolean getFailOnStartError() {
        String property = System.getProperty("org.apache.geronimo.aries.failApplicationOnStartError", "false");
        return Boolean.parseBoolean(property);
    }

    public void doStart() throws Exception {
        LOG.debug("Starting {} application.", (Object)this.application.getApplicationMetadata().getApplicationScope());
        this.applicationState = AriesApplicationContext.ApplicationState.STARTING;
        try {
            this.startApplicationBundles();
            this.applicationState = AriesApplicationContext.ApplicationState.ACTIVE;
            LOG.debug("Application {} started successfully.", (Object)this.application.getApplicationMetadata().getApplicationScope());
        }
        catch (BundleException be) {
            this.applicationState = AriesApplicationContext.ApplicationState.INSTALLED;
            BundleException rootException = be;
            String rootMessage = be.getMessage();
            ResolverErrorAnalyzer errorAnalyzer = new ResolverErrorAnalyzer(this.bundle.getBundleContext());
            String resolverErrors = errorAnalyzer.getErrorsAsString(this.applicationBundles);
            if (resolverErrors != null) {
                rootException = null;
                rootMessage = resolverErrors;
            }
            String message = MessageFormat.format("Error starting {0} application. {1}", this.application.getApplicationMetadata().getApplicationScope(), rootMessage);
            if (ApplicationGBean.getFailOnStartError()) {
                throw new BundleException(message, (Throwable)rootException);
            }
            LOG.error(message, (Throwable)rootException);
        }
    }

    private void startApplicationBundles() throws BundleException {
        ArrayList<Bundle> bundlesWeStarted = new ArrayList<Bundle>();
        try {
            for (Bundle b : this.applicationBundles) {
                if (!BundleUtils.canStart((Bundle)b)) continue;
                LOG.debug("Starting {} application bundle.", (Object)b);
                b.start(1);
                bundlesWeStarted.add(b);
            }
        }
        catch (BundleException be) {
            for (Bundle b : bundlesWeStarted) {
                try {
                    b.stop();
                }
                catch (BundleException be2) {}
            }
            throw be;
        }
    }

    public void doStop() {
        LOG.debug("Stopping {} application.", (Object)this.application.getApplicationMetadata().getApplicationScope());
        for (Bundle bundle : this.applicationBundles) {
            try {
                bundle.uninstall();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.applicationBundles.clear();
        this.applicationState = AriesApplicationContext.ApplicationState.RESOLVED;
    }

    public void doFail() {
        this.doStop();
    }

    protected void applicationStart() throws BundleException {
        try {
            this.installer.getConfigurationManager().loadConfiguration(this.configId);
            this.installer.getConfigurationManager().startConfiguration(this.configId);
        }
        catch (Exception e) {
            throw new BundleException("Failed to start application", (Throwable)e);
        }
    }

    protected void applicationStop() throws BundleException {
        try {
            this.installer.getConfigurationManager().unloadConfiguration(this.configId);
        }
        catch (Exception e) {
            throw new BundleException("Failed to start application", (Throwable)e);
        }
    }

    protected void applicationUninstall() {
        LOG.debug("Uninstalling {} application.", (Object)this.application.getApplicationMetadata().getApplicationScope());
        try {
            this.installer.getConfigurationManager().unloadConfiguration(this.configId);
            this.installer.getConfigurationManager().uninstallConfiguration(this.configId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applicationState = AriesApplicationContext.ApplicationState.UNINSTALLED;
    }

    private class RefreshListener
    implements FrameworkListener {
        public CountDownLatch latch = new CountDownLatch(1);

        private RefreshListener() {
        }

        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == 4) {
                this.latch.countDown();
            }
        }

        public void waitForRefresh(int timeout) {
            try {
                this.latch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

