/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationResolver;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.geronimo.aries.resolver.generator.RepositoryDescriptorGenerator;
import org.apache.geronimo.aries.resolver.impl.ApplicationResourceImpl;
import org.apache.geronimo.aries.resolver.impl.OBRBundleInfo;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class GeronimoOBRResolver
implements AriesApplicationResolver {
    private static Logger log = LoggerFactory.getLogger(GeronimoOBRResolver.class);
    private final RepositoryAdmin repositoryAdmin;
    private boolean includeOptional = true;

    public GeronimoOBRResolver(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public void setIncludeOptional(boolean includeOptional) {
        this.includeOptional = includeOptional;
    }

    public Set<BundleInfo> resolve(AriesApplication app, ResolveConstraint ... constraints) throws ResolverException {
        Repository[] userRepositories;
        log.trace("resolving {}", (Object)app);
        ApplicationMetadata appMeta = app.getApplicationMetadata();
        String appName = appMeta.getApplicationSymbolicName();
        Version appVersion = appMeta.getApplicationVersion();
        List appContent = appMeta.getApplicationContents();
        Repository appRepository = null;
        try {
            Document doc = RepositoryDescriptorGenerator.generateRepositoryDescriptor(appName + "_" + appVersion, app.getBundleInfo());
            File f = File.createTempFile(appName + "_" + appVersion, "repository.xml");
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(f));
            appRepository = this.repositoryAdmin.getHelper().repository(f.toURI().toURL());
            f.delete();
        }
        catch (Exception e) {
            throw new ResolverException(e);
        }
        ArrayList<Repository> appRepositories = new ArrayList<Repository>();
        appRepositories.add(this.repositoryAdmin.getSystemRepository());
        appRepositories.add(this.repositoryAdmin.getLocalRepository());
        appRepositories.add(appRepository);
        for (Repository userRepository : userRepositories = this.repositoryAdmin.listRepositories()) {
            appRepositories.add(userRepository);
        }
        Resolver obrResolver = this.repositoryAdmin.resolver(appRepositories.toArray(new Repository[appRepositories.size()]));
        try {
            obrResolver.add((Resource)new ApplicationResourceImpl(this.repositoryAdmin, appName, appVersion, appContent));
        }
        catch (InvalidSyntaxException e) {
            throw new ResolverException((Exception)((Object)e));
        }
        if (obrResolver.resolve()) {
            BundleInfo bundleInfo;
            HashSet<BundleInfo> result = new HashSet<BundleInfo>();
            for (Resource resource : obrResolver.getRequiredResources()) {
                bundleInfo = this.toBundleInfo(resource, false);
                result.add(bundleInfo);
            }
            if (this.includeOptional) {
                for (Resource resource : obrResolver.getOptionalResources()) {
                    bundleInfo = this.toBundleInfo(resource, true);
                    result.add(bundleInfo);
                }
            }
            return result;
        }
        throw new ResolverException("Could not resolve requirements: " + this.getUnsatisfiedRequirements(obrResolver));
    }

    public BundleInfo getBundleInfo(String bundleSymbolicName, Version bundleVersion) {
        Resource[] resources;
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("version", bundleVersion.toString());
        String filterString = ManifestHeaderProcessor.generateFilter((String)"symbolicname", (String)bundleSymbolicName, attribs);
        try {
            resources = this.repositoryAdmin.discoverResources(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (resources != null && resources.length > 0) {
            return this.toBundleInfo(resources[0], false);
        }
        return null;
    }

    private String getUnsatisfiedRequirements(Resolver resolver) {
        Reason[] reasons = resolver.getUnsatisfiedRequirements();
        if (reasons != null) {
            StringBuilder sb = new StringBuilder();
            for (int reqIdx = 0; reqIdx < reasons.length; ++reqIdx) {
                sb.append("   " + reasons[reqIdx].getRequirement().getFilter()).append("\n");
                Resource resource = reasons[reqIdx].getResource();
                if (resource == null) continue;
                sb.append("      " + resource.getPresentationName()).append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    private BundleInfo toBundleInfo(Resource resource, boolean optional) {
        HashMap<String, String> directives = null;
        if (optional) {
            directives = new HashMap<String, String>();
            directives.put("resolution", "optional");
        }
        String location = resource.getURI();
        return new OBRBundleInfo(resource.getSymbolicName(), resource.getVersion(), location, null, null, null, null, null, null, directives, null);
    }
}

