/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.builder;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.geronimo.aries.builder.ApplicationGBean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ApplicationInstaller
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationInstaller.class);
    private Kernel kernel;
    private BundleContext bundleContext;
    private AbstractName abstractName;
    private ServiceRegistration registration;
    private ConfigurationManager configurationManager;
    private Collection<ConfigurationStore> configurationStores;

    public ApplicationInstaller(@ParamReference(name="Store", namingType="ConfigurationStore") Collection<ConfigurationStore> configurationStores, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName) throws GBeanNotFoundException {
        this.kernel = kernel;
        this.bundleContext = bundleContext;
        this.abstractName = abstractName;
        this.configurationStores = configurationStores;
        this.configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
    }

    public void doStart() throws Exception {
        this.registration = this.bundleContext.registerService(ApplicationInstaller.class.getName(), (Object)this, null);
    }

    public void doStop() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public void doFail() {
        this.doStop();
    }

    protected ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public DeploymentContext startInstall(AriesApplication app, ConfigurationStore targetConfigurationStore) throws ConfigurationAlreadyExistsException, IOException, DeploymentException {
        Artifact configId = ApplicationInstaller.getConfigId(app.getApplicationMetadata());
        targetConfigurationStore.createNewConfigurationDir(configId);
        Environment environment = new Environment();
        environment.setConfigId(configId);
        Naming naming = this.kernel.getNaming();
        AbstractName moduleName = naming.createRootName(configId, configId.toString(), "AriesApplication");
        File tempDirectory = FileUtils.createTempDir();
        try {
            DeploymentContext context = new DeploymentContext(tempDirectory, null, environment, moduleName, ConfigurationModuleType.SERVICE, naming, this.configurationManager, null, this.bundleContext);
            context.flush();
            context.initializeConfiguration();
            app.store(tempDirectory);
            AbstractName name = naming.createChildName(moduleName, "AriesApplication", "GBean");
            GBeanData data = new GBeanData(name, ApplicationGBean.class);
            data.setAttribute("configId", (Object)configId);
            data.setReferencePattern("Installer", this.abstractName);
            context.addGBean(data);
            return context;
        }
        catch (DeploymentException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("", (Throwable)e);
        }
    }

    public ConfigurationData finishInstall(DeploymentContext context, ConfigurationStore targetConfigurationStore) throws ConfigurationAlreadyExistsException, DeploymentException {
        try {
            ConfigurationData configurationData = context.getConfigurationData();
            targetConfigurationStore.install(configurationData);
            ConfigurationData configurationData2 = configurationData;
            return configurationData2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("", (Throwable)e);
        }
        finally {
            try {
                context.close();
            }
            catch (IOException e) {}
        }
    }

    public void install(AriesApplication app) throws ConfigurationAlreadyExistsException, IOException, DeploymentException {
        ConfigurationStore store = this.configurationStores.iterator().next();
        if (store == null) {
            throw new DeploymentException("No ConfigurationStore");
        }
        DeploymentContext context = this.startInstall(app, store);
        ConfigurationData configurationData = this.finishInstall(context, store);
        try {
            this.configurationManager.loadConfiguration(configurationData.getId());
            this.configurationManager.startConfiguration(configurationData.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("", (Throwable)e);
        }
    }

    public static Artifact getConfigId(ApplicationMetadata metadata) {
        return ApplicationInstaller.createArtifact("application", metadata.getApplicationSymbolicName(), metadata.getApplicationVersion());
    }

    private static Artifact createArtifact(String group, String symbolicName, Version version) {
        return new Artifact(group, symbolicName, ApplicationInstaller.getVersion(version), "eba");
    }

    private static String getVersion(Version version) {
        String str = version.getMajor() + "." + version.getMinor() + "." + version.getMinor();
        String qualifier = version.getQualifier();
        if (qualifier != null && qualifier.trim().length() > 0) {
            str = str + "-" + version.getQualifier().trim();
        }
        return str;
    }
}

