/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.activemq.ActiveMQConnector;
import org.apache.geronimo.activemq.BrokerServiceGBean;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GConstructorInfo;

public class TransportConnectorGBeanImpl
implements GBeanLifecycle,
ActiveMQConnector {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private TransportConnector transportConnector;
    private BrokerServiceGBean brokerServiceGBean;
    private String protocol;
    private String host;
    private int port;
    private String path;
    private String query;
    private String urlAsStarted;
    private ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;

    public TransportConnectorGBeanImpl(BrokerServiceGBean brokerServiceGBean, String protocol, String host, int port) {
        this.brokerServiceGBean = brokerServiceGBean;
        this.protocol = protocol;
        this.host = host.equalsIgnoreCase("localhost") ? "127.0.0.1" : host;
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getUrl() {
        try {
            return new URI(this.protocol, null, this.host, this.port, this.path, this.query, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Attributes don't form a valid URI: " + this.protocol + "://" + this.host + ":" + this.port + "/" + this.path + "?" + this.query, e);
        }
    }

    public InetSocketAddress getListenAddress() {
        try {
            return this.transportConnector.getServer().getSocketAddress();
        }
        catch (Throwable e) {
            this.log.debug((Object)("Failure to determine ListenAddress: " + e), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            if (this.transportConnector == null) {
                this.urlAsStarted = this.getUrl();
                this.transportConnector = this.createBrokerConnector(this.urlAsStarted);
                this.transportConnector.start();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void doStop() throws Exception {
        if (this.transportConnector != null) {
            TransportConnector temp = this.transportConnector;
            this.transportConnector = null;
            temp.stop();
        }
    }

    public synchronized void doFail() {
        if (this.transportConnector != null) {
            TransportConnector temp = this.transportConnector;
            this.transportConnector = null;
            try {
                temp.stop();
            }
            catch (Exception e) {
                this.log.info((Object)("Caught while closing due to failure: " + e), (Throwable)e);
            }
        }
    }

    protected TransportConnector createBrokerConnector(String url) throws Exception {
        return this.brokerServiceGBean.getBrokerContainer().addConnector(url);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"ActiveMQ Transport Connector", TransportConnectorGBeanImpl.class, (String)"JMSConnector");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("url", String.class.getName(), false);
        infoBuilder.addReference("brokerService", BrokerServiceGBean.class);
        infoBuilder.addInterface(ActiveMQConnector.class, new String[]{"host", "port", "protocol", "path", "query"}, new String[]{"host", "port"});
        infoBuilder.setConstructor(new GConstructorInfo(new String[]{"brokerService", "protocol", "host", "port"}));
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

