/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.plugin.LocalOpenResult;
import org.apache.geronimo.system.plugin.OpenResult;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.PluginXmlUtil;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoSourceRepository
implements SourceRepository {
    private final Collection<? extends Repository> repos;
    private final ArtifactResolver artifactResolver;

    public GeronimoSourceRepository(Collection<? extends Repository> repos, ArtifactResolver artifactResolver) {
        this.repos = repos;
        this.artifactResolver = artifactResolver;
    }

    @Override
    public PluginListType getPluginList() {
        HashMap<PluginType, PluginType> pluginMap = new HashMap<PluginType, PluginType>();
        for (Repository repository : this.repos) {
            if (!(repository instanceof ListableRepository)) continue;
            SortedSet artifacts = ((ListableRepository)repository).list();
            for (Artifact artifact : artifacts) {
                File location = repository.getLocation(artifact);
                PluginType data = GeronimoSourceRepository.extractPluginMetadata(location);
                if (data == null) continue;
                PluginType key = PluginInstallerGBean.toKey(data);
                PluginType existing = (PluginType)pluginMap.get(key);
                if (existing == null) {
                    pluginMap.put(key, data);
                    continue;
                }
                existing.getPluginArtifact().addAll(data.getPluginArtifact());
            }
        }
        PluginListType pluginList = new PluginListType();
        pluginList.getPlugin().addAll(pluginMap.values());
        return pluginList;
    }

    @Override
    public OpenResult open(Artifact artifact, FileWriteMonitor monitor) throws IOException, FailedLoginException {
        try {
            artifact = this.artifactResolver.resolveInClassLoader(artifact);
        }
        catch (MissingDependencyException e) {
            return null;
        }
        for (Repository repository : this.repos) {
            if (!repository.contains(artifact)) continue;
            File location = repository.getLocation(artifact);
            if (location.isFile()) {
                return new LocalOpenResult(artifact, location);
            }
            if (!location.isDirectory()) continue;
            return new ZipOpenResult(artifact, repository);
        }
        return null;
    }

    PluginType extractPluginMetadata(Artifact artifact) {
        for (Repository repository : this.repos) {
            if (!repository.contains(artifact)) continue;
            File location = repository.getLocation(artifact);
            return GeronimoSourceRepository.extractPluginMetadata(location);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    static PluginType extractPluginMetadata(File dir) {
        try {
            if (dir.isDirectory()) {
                File meta = new File(dir, "META-INF");
                if (!meta.isDirectory() || !meta.canRead()) {
                    return null;
                }
                File xml = new File(meta, "geronimo-plugin.xml");
                if (!xml.isFile() || !xml.canRead() || xml.length() == 0L) {
                    return null;
                }
                FileInputStream in = new FileInputStream(xml);
                try {
                    PluginType pluginType = PluginXmlUtil.loadPluginMetadata(in);
                    return pluginType;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            if (!dir.isFile() || !dir.canRead()) {
                throw new IllegalStateException("Cannot read configuration " + dir.getAbsolutePath());
            }
            JarFile jar = new JarFile(dir);
            try {
                PluginType pluginType;
                ZipEntry entry = jar.getEntry("META-INF/geronimo-plugin.xml");
                if (entry == null) {
                    PluginType in = null;
                    return in;
                }
                InputStream in = jar.getInputStream(entry);
                try {
                    pluginType = PluginXmlUtil.loadPluginMetadata(in);
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
                in.close();
                return pluginType;
            }
            finally {
                jar.close();
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private class ZipOpenResult
    implements OpenResult {
        private final Artifact artifact;
        private final Repository repo;
        File location;

        private ZipOpenResult(Artifact artifact, Repository repo) {
            this.artifact = artifact;
            this.repo = repo;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public File getFile() throws IOException {
            this.location = File.createTempFile("geronimo-plugin-download-", ".tmp");
            FileOutputStream output = new FileOutputStream(this.location);
            RepoWrapper writableRepo = new RepoWrapper(this.repo);
            RepositoryConfigurationStore store = new RepositoryConfigurationStore((WritableListableRepository)writableRepo);
            try {
                store.exportConfiguration(this.artifact, (OutputStream)output);
            }
            catch (NoSuchConfigException e) {
                throw (IOException)new IOException("Could not locate artefact " + this.artifact).initCause(e);
            }
            return this.location;
        }

        public void install(WriteableRepository repo, FileWriteMonitor monitor) throws IOException {
            File file = this.getFile();
            repo.copyToRepository(file, this.artifact, monitor);
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepoWrapper
    implements WritableListableRepository {
        private final Repository repo;

        private RepoWrapper(Repository repo) {
            this.repo = repo;
        }

        public void copyToRepository(File source, Artifact destination, FileWriteMonitor monitor) throws IOException {
        }

        public void copyToRepository(InputStream source, int size, Artifact destination, FileWriteMonitor monitor) throws IOException {
        }

        public boolean contains(Artifact artifact) {
            return this.repo.contains(artifact);
        }

        public File getLocation(Artifact artifact) {
            return this.repo.getLocation(artifact);
        }

        public LinkedHashSet<Artifact> getDependencies(Artifact artifact) {
            return null;
        }

        public SortedSet<Artifact> list() {
            return null;
        }

        public SortedSet<Artifact> list(Artifact query) {
            return null;
        }
    }
}

