/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.IOUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.plugin.ServerArchiver;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public class ArchiverGBean
implements ServerArchiver {
    private final ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;

    public ArchiverGBean(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public File archive(String sourcePath, String destPath, Artifact artifact) throws ArchiverException, IOException {
        TarArchiver archiver;
        File source = this.serverInfo.resolve(sourcePath);
        File dest = this.serverInfo.resolve(destPath);
        String serverName = artifact.getArtifactId() + "-" + artifact.getVersion();
        dest = new File(dest, serverName + "-bin." + artifact.getType());
        if ("tar.gz".equals(artifact.getType())) {
            archiver = new TarArchiver();
            TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
            tarCompressionMethod.setValue("gzip");
            archiver.setCompression(tarCompressionMethod);
            TarLongFileMode fileMode = new TarLongFileMode();
            fileMode.setValue("gnu");
            archiver.setLongfile(fileMode);
        } else if ("zip".equals(artifact.getType())) {
            archiver = new ZipArchiver();
        } else {
            throw new IllegalArgumentException("Unknown target type: " + artifact.getType());
        }
        archiver.setIncludeEmptyDirs(true);
        archiver.setDestFile(dest);
        Map all = IOUtil.listAllFileNames((File)source);
        for (Map.Entry entry : all.entrySet()) {
            String destFileName = serverName + "/" + (String)entry.getKey();
            File sourceFile = (File)entry.getValue();
            if (!sourceFile.isFile()) continue;
            archiver.addFile(sourceFile, destFileName, 420);
        }
        File bin = new File(source, "bin");
        if (bin.exists()) {
            Map includes = IOUtil.listAllFileNames((File)bin);
            for (Map.Entry entry : includes.entrySet()) {
                String destFileName = serverName + "/bin/" + (String)entry.getKey();
                File sourceFile = (File)entry.getValue();
                if (destFileName.endsWith(".bat") || !sourceFile.isFile()) continue;
                archiver.addFile(sourceFile, destFileName, 493);
            }
        }
        archiver.createArchive();
        return dest;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ArchiverGBean.class);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

