/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.plugin.DownloadPoller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadResults
implements Serializable,
DownloadPoller {
    private List<Artifact> removedConfigIDs = new ArrayList<Artifact>();
    private List<Artifact> restartedConfigIDs = new ArrayList<Artifact>();
    private List<Artifact> installedConfigIDs = new ArrayList<Artifact>();
    private List<Artifact> dependenciesPresent = new ArrayList<Artifact>();
    private List<Artifact> dependenciesInstalled = new ArrayList<Artifact>();
    private List<MissingDependencyException> skippedPlugins = new ArrayList<MissingDependencyException>();
    private String currentFile;
    private String currentMessage;
    private int currentFileProgress = -1;
    private Exception failure;
    private boolean finished;
    private long totalDownloadBytes = 0L;

    public synchronized DownloadResults duplicate() {
        DownloadResults other = new DownloadResults();
        other.removedConfigIDs.addAll(this.removedConfigIDs);
        other.restartedConfigIDs.addAll(this.restartedConfigIDs);
        other.installedConfigIDs.addAll(this.installedConfigIDs);
        other.dependenciesPresent.addAll(this.dependenciesPresent);
        other.dependenciesInstalled.addAll(this.dependenciesInstalled);
        other.skippedPlugins.addAll(this.skippedPlugins);
        other.currentFile = this.currentFile;
        other.currentMessage = this.currentMessage;
        other.currentFileProgress = this.currentFileProgress;
        other.failure = this.failure;
        other.finished = this.finished;
        other.totalDownloadBytes = this.totalDownloadBytes;
        return other;
    }

    @Override
    public synchronized void addInstalledConfigID(Artifact dep) {
        this.installedConfigIDs.add(dep);
    }

    @Override
    public synchronized void addRemovedConfigID(Artifact obsolete) {
        this.removedConfigIDs.add(obsolete);
    }

    @Override
    public synchronized void addRestartedConfigID(Artifact target) {
        this.restartedConfigIDs.add(target);
    }

    @Override
    public void addSkippedConfigID(MissingDependencyException e) {
        this.skippedPlugins.add(e);
    }

    @Override
    public synchronized void addDependencyPresent(Artifact dep) {
        this.dependenciesPresent.add(dep);
    }

    @Override
    public synchronized void addDependencyInstalled(Artifact dep) {
        this.dependenciesInstalled.add(dep);
    }

    @Override
    public synchronized void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
    }

    @Override
    public synchronized void setCurrentMessage(String currentMessage) {
        this.currentMessage = currentMessage;
    }

    @Override
    public synchronized void setCurrentFilePercent(int currentFileProgress) {
        this.currentFileProgress = currentFileProgress;
    }

    @Override
    public synchronized void setFailure(Exception failure) {
        this.failure = failure;
    }

    @Override
    public synchronized void setFinished() {
        this.finished = true;
    }

    @Override
    public synchronized void addDownloadBytes(long bytes) {
        this.totalDownloadBytes += bytes;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public long getTotalDownloadBytes() {
        return this.totalDownloadBytes;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public List<Artifact> getInstalledConfigIDs() {
        return Collections.unmodifiableList(this.installedConfigIDs);
    }

    public List<Artifact> getRemovedConfigIDs() {
        return Collections.unmodifiableList(this.removedConfigIDs);
    }

    public List<Artifact> getRestartedConfigIDs() {
        return Collections.unmodifiableList(this.restartedConfigIDs);
    }

    public List<MissingDependencyException> getSkippedPlugins() {
        return Collections.unmodifiableList(this.skippedPlugins);
    }

    public List<Artifact> getDependenciesPresent() {
        return Collections.unmodifiableList(this.dependenciesPresent);
    }

    public List<Artifact> getDependenciesInstalled() {
        return Collections.unmodifiableList(this.dependenciesInstalled);
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public String getCurrentMessage() {
        return this.currentMessage;
    }

    public int getCurrentFilePercent() {
        return this.currentFileProgress;
    }
}

