/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gjndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.WritableContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelContextGBean
extends WritableContext
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(KernelContextGBean.class);
    private final Kernel kernel;
    private final AbstractNameQuery abstractNameQuery;
    private final LifecycleListener listener = new ContextLifecycleListener();
    private final Map<AbstractName, Set<Name>> bindingsByAbstractName = new HashMap<AbstractName, Set<Name>>();
    private Map<Name, LinkedHashMap<AbstractName, Object>> bindingsByName = new HashMap<Name, LinkedHashMap<AbstractName, Object>>();
    public static final GBeanInfo GBEAN_INFO;

    public KernelContextGBean(String nameInNamespace, AbstractNameQuery abstractNameQuery, Kernel kernel) throws NamingException {
        super(nameInNamespace, Collections.EMPTY_MAP, ContextAccess.MODIFIABLE, false);
        this.abstractNameQuery = abstractNameQuery;
        this.kernel = kernel;
    }

    public synchronized void doStart() {
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, this.abstractNameQuery);
        Set set = this.kernel.listGBeans(this.abstractNameQuery);
        for (AbstractName abstractName : set) {
            try {
                if (!this.kernel.isRunning(abstractName)) continue;
                this.addBinding(abstractName);
            }
            catch (NamingException e) {
                log.error("Error adding binding for " + abstractName, (Throwable)e);
            }
        }
    }

    public void doStop() {
        this.destroy();
    }

    public void doFail() {
        this.destroy();
    }

    private synchronized void destroy() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        HashSet<AbstractName> abstractNames = new HashSet<AbstractName>(this.bindingsByAbstractName.keySet());
        for (AbstractName abstractName : abstractNames) {
            this.removeBinding(abstractName);
        }
        this.bindingsByAbstractName.clear();
    }

    protected synchronized void addBinding(AbstractName abstractName) throws NamingException {
        Object instance;
        if (this.bindingsByAbstractName.containsKey(abstractName)) {
            return;
        }
        try {
            instance = this.kernel.getGBean(abstractName);
        }
        catch (GBeanNotFoundException e) {
            throw (NamingException)new NamingException("GBean not found: " + abstractName).initCause(e);
        }
        Map<Name, Object> bindings = this.createBindings(abstractName, instance);
        if (bindings == null || bindings.isEmpty()) {
            return;
        }
        for (Map.Entry<Name, Object> entry : bindings.entrySet()) {
            Name name = entry.getKey();
            Object value = entry.getValue();
            this.addBinding(abstractName, name, value);
        }
        this.bindingsByAbstractName.put(abstractName, bindings.keySet());
    }

    private synchronized void addBinding(AbstractName abstractName, Name name, Object value) throws NamingException {
        LinkedHashMap<Object, Object> bindings = this.bindingsByName.get(name);
        if (bindings == null) {
            this.addDeepBinding(name, value, true, true);
            bindings = new LinkedHashMap();
            bindings.put(abstractName, value);
            this.bindingsByName.put(name, bindings);
            log.info("bound gbean " + abstractName + " at name " + name);
        } else {
            bindings.put(abstractName, value);
        }
    }

    protected synchronized void removeBinding(AbstractName abstractName) {
        Set<Name> bindingNames = this.bindingsByAbstractName.remove(abstractName);
        if (bindingNames == null) {
            return;
        }
        for (Name name : bindingNames) {
            LinkedHashMap<AbstractName, Object> bindings = this.bindingsByName.get(name);
            if (bindings == null) continue;
            if (KernelContextGBean.first(bindings).getKey().equals((Object)abstractName)) {
                bindings.remove(abstractName);
                Map.Entry<AbstractName, Object> newEntry = KernelContextGBean.first(bindings);
                if (newEntry != null) {
                    Object newValue = newEntry.getValue();
                    try {
                        this.addDeepBinding(name, newValue, true, true);
                    }
                    catch (NamingException e) {
                        boolean logged = false;
                        try {
                            this.removeDeepBinding(name, true);
                        }
                        catch (NamingException e1) {
                            logged = true;
                            log.error("Unable to remove binding " + name + " to " + abstractName, (Throwable)e);
                        }
                        if (logged) continue;
                        log.error("Unable to rebind binding " + name + " to " + newEntry.getKey());
                    }
                    continue;
                }
                this.bindingsByName.remove(name);
                try {
                    this.removeDeepBinding(name, true, true);
                }
                catch (ContextNotEmptyException e) {
                }
                catch (NamingException e) {
                    log.error("Unable to remove binding " + name + " to " + abstractName, (Throwable)e);
                }
                log.info("unbound gbean " + abstractName + " at name " + name);
                continue;
            }
            bindings.remove(abstractName);
        }
    }

    private static Map.Entry<AbstractName, Object> first(LinkedHashMap<AbstractName, Object> map) {
        if (map.isEmpty()) {
            return null;
        }
        return map.entrySet().iterator().next();
    }

    protected Map<Name, Object> createBindings(AbstractName abstractName, Object value) throws NamingException {
        Name name = this.createBindingName(abstractName, value);
        if (name == null) {
            return null;
        }
        if ((value = this.preprocessVaue(abstractName, name, value)) == null) {
            return null;
        }
        return Collections.singletonMap(name, value);
    }

    protected Name createBindingName(AbstractName abstractName, Object value) throws NamingException {
        String shortName = (String)abstractName.getName().get("name");
        return this.getNameParser().parse(shortName);
    }

    protected Object preprocessVaue(AbstractName abstractName, Name name, Object value) throws NamingException {
        return value;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(KernelContextGBean.class, (String)"Context");
        builder.addAttribute("nameInNamespace", String.class, true);
        builder.addAttribute("abstractNameQuery", AbstractNameQuery.class, true);
        builder.setConstructor(new String[]{"nameInNamespace", "abstractNameQuery", "kernel"});
        GBEAN_INFO = builder.getBeanInfo();
    }

    private class ContextLifecycleListener
    extends LifecycleAdapter {
        private ContextLifecycleListener() {
        }

        public void running(AbstractName abstractName) {
            try {
                KernelContextGBean.this.addBinding(abstractName);
            }
            catch (NamingException e) {
                log.error("Error adding binding for " + abstractName);
            }
        }

        public void stopping(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }

        public void stopped(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }

        public void failed(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }

        public void unloaded(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }
    }
}

