/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBeanSingleReference
extends AbstractGBeanReference {
    private static final Logger log = LoggerFactory.getLogger(GBeanSingleReference.class);
    private final AbstractName targetName;

    public GBeanSingleReference(GBeanInstance gbeanInstance, GReferenceInfo referenceInfo, Kernel kernel, ReferencePatterns referencePatterns) throws InvalidConfigurationException {
        super(gbeanInstance, referenceInfo, kernel, referencePatterns != null && referencePatterns.getAbstractName() != null);
        this.targetName = referencePatterns != null ? referencePatterns.getAbstractName() : null;
    }

    public AbstractName getTargetName() {
        return this.targetName;
    }

    public final synchronized void online() {
    }

    public final synchronized void offline() {
        this.stop();
    }

    public synchronized boolean start() {
        if (this.targetName == null) {
            return true;
        }
        AbstractName abstractName = this.getGBeanInstance().getAbstractName();
        if (!this.isRunning(this.getKernel(), this.targetName)) {
            log.debug("Waiting to start " + abstractName + " because no targets are running for reference " + this.getName() + " matching the patterns " + this.targetName);
            return false;
        }
        if (this.getProxy() != null) {
            return true;
        }
        if (NO_PROXY) {
            try {
                this.setProxy(this.getKernel().getGBean(this.targetName));
            }
            catch (GBeanNotFoundException e) {
                log.debug("Waiting to start " + abstractName + " because no targets are running for reference " + this.getName() + " matching the patterns " + this.targetName);
                return false;
            }
        } else {
            this.setProxy(this.getKernel().getProxyManager().createProxy(this.targetName, this.getReferenceType()));
        }
        log.debug("Started {}", (Object)abstractName);
        return true;
    }

    public synchronized void stop() {
        Object proxy = this.getProxy();
        if (proxy != null) {
            this.getKernel().getProxyManager().destroyProxy(proxy);
            this.setProxy(null);
        }
    }
}

