/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectionNotification;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.jmxremoting.Credentials;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;

public class Authenticator
implements JMXAuthenticator,
NotificationListener {
    private final String configName;
    private final ClassLoader cl;
    private ThreadLocal<LoginContext> threadContext = new ThreadLocal();
    private Map<String, LoginContext> contextMap = new ConcurrentHashMap<String, LoginContext>();

    public Authenticator(String configName, ClassLoader cl) {
        this.configName = configName;
        this.cl = cl;
    }

    @Override
    public Subject authenticate(Object o) throws SecurityException {
        if (!(o instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + (o == null ? null : o.getClass().getName()));
        }
        String[] params = (String[])o;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldCL = thread.getContextClassLoader();
        Credentials credentials = new Credentials(params[0], params[1]);
        try {
            thread.setContextClassLoader(this.cl);
            LoginContext context = new LoginContext(this.configName, credentials);
            context.login();
            this.threadContext.set(context);
            Subject sub = context.getSubject();
            Set<GeronimoGroupPrincipal> pricipalsGroup = sub.getPrincipals(GeronimoGroupPrincipal.class);
            boolean isAllowedGroups = false;
            for (Object principal : pricipalsGroup) {
                if (!principal.getName().equals("admin") && !principal.getName().equals("monitor")) continue;
                isAllowedGroups = true;
                break;
            }
            if (!isAllowedGroups) {
                throw new LoginException("Only users in admin group or monitor group are allowed");
            }
            Iterator<Principal> it = sub.getPrincipals().iterator();
            while (it.hasNext()) {
                Object principal;
                principal = it.next();
                if (!(principal instanceof GeronimoUserPrincipal)) continue;
                it.remove();
            }
            Subject subject = sub;
            return subject;
        }
        catch (LoginException e) {
            throw new SecurityException("Invalid login");
        }
        finally {
            credentials.clear();
            thread.setContextClassLoader(oldCL);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object o) {
        if (notification instanceof JMXConnectionNotification) {
            JMXConnectionNotification cxNotification = (JMXConnectionNotification)notification;
            String type = cxNotification.getType();
            String connectionId = cxNotification.getConnectionId();
            if ("jmx.remote.connection.opened".equals(type)) {
                LoginContext context = this.threadContext.get();
                this.threadContext.set(null);
                this.contextMap.put(connectionId, context);
            } else {
                LoginContext context = this.contextMap.remove(connectionId);
                if (context != null) {
                    try {
                        context.logout();
                    }
                    catch (LoginException e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

