/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.main.CommandLineManifest;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployer
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(Deployer.class);
    private final int REAPER_INTERVAL = 60000;
    public static final String CLEAN_UP_ON_START_KEY = "org.apache.geronimo.deployer.cleanupOnStart";
    private final boolean CLEAN_UP_ON_START = System.getProperty("org.apache.geronimo.deployer.cleanupOnStart") == null ? true : Boolean.getBoolean("org.apache.geronimo.deployer.cleanupOnStart");
    private DeployerReaper reaper;
    private final String remoteDeployAddress;
    private final Collection<ConfigurationBuilder> builders;
    private final Collection<ConfigurationStore> stores;
    private final Collection<DeploymentWatcher> watchers;
    private final ArtifactResolver artifactResolver;
    private final Kernel kernel;
    private static final URI PLAN_LOCATION = URI.create("META-INF/plan.xml");
    public static final GBeanInfo GBEAN_INFO;
    private static final String DEPLOYER = "Deployer";

    public Deployer(String remoteDeployAddress, Collection<ConfigurationBuilder> builders, Collection<ConfigurationStore> stores, Collection<DeploymentWatcher> watchers, Kernel kernel) throws GBeanNotFoundException {
        this(remoteDeployAddress, builders, stores, watchers, Deployer.getArtifactResolver(kernel), kernel);
    }

    private static ArtifactResolver getArtifactResolver(Kernel kernel) throws GBeanNotFoundException {
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        return configurationManager.getArtifactResolver();
    }

    public Deployer(String remoteDeployAddress, Collection<ConfigurationBuilder> builders, Collection<ConfigurationStore> stores, Collection<DeploymentWatcher> watchers, ArtifactResolver artifactResolver, Kernel kernel) {
        this.remoteDeployAddress = remoteDeployAddress;
        this.builders = builders;
        this.stores = stores;
        this.watchers = watchers;
        this.artifactResolver = artifactResolver;
        this.kernel = kernel;
        this.reaper = new DeployerReaper(60000);
    }

    public List<String> deploy(boolean inPlace, File moduleFile, File planFile) throws DeploymentException {
        return this.deploy(inPlace, moduleFile, planFile, null);
    }

    public List<String> deploy(boolean inPlace, File moduleFile, File planFile, String targetConfigStore) throws DeploymentException {
        File originalModuleFile = moduleFile;
        File tmpDir = null;
        if (moduleFile != null && !moduleFile.isDirectory()) {
            boolean cleanup = true;
            try {
                tmpDir = File.createTempFile("geronimo-deployer", ".tmpdir");
                tmpDir.delete();
                tmpDir.mkdir();
                File tmpFile = new File(tmpDir, moduleFile.getName());
                FileUtils.copyFile((File)moduleFile, (File)tmpFile);
                moduleFile = tmpFile;
                cleanup = false;
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
            finally {
                if (cleanup && tmpDir != null && !FileUtils.recursiveDelete((File)tmpDir)) {
                    this.reaper.delete(tmpDir.getAbsolutePath(), "delete");
                }
            }
        }
        try {
            List<String> cleanup = this.deploy(inPlace, moduleFile, planFile, null, true, null, null, null, null, null, null, null, targetConfigStore);
            return cleanup;
        }
        catch (DeploymentException e) {
            log.debug("Deployment failed: plan=" + planFile + ", module=" + originalModuleFile, (Throwable)e);
            throw e.cleanse();
        }
        finally {
            if (tmpDir != null && !FileUtils.recursiveDelete(tmpDir)) {
                this.reaper.delete(tmpDir.getAbsolutePath(), "delete");
            }
        }
    }

    public String getRemoteDeployUploadURL() {
        Set set = this.kernel.listGBeans(new AbstractNameQuery("org.apache.geronimo.deployment.remote.RemoteDeployToken"));
        if (set.size() == 0) {
            return null;
        }
        AbstractName token = (AbstractName)set.iterator().next();
        ObjectName config = null;
        for (AbstractName name : this.kernel.getDependencyManager().getParents(token)) {
            if (!Configuration.isConfigurationObjectName((ObjectName)name.getObjectName())) continue;
            config = name.getObjectName();
            break;
        }
        if (config == null) {
            log.warn("Unable to find remote deployment configuration; is the remote deploy web application running?");
            return null;
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("J2EEApplication", token.getObjectName().getKeyProperty("J2EEApplication"));
        hash.put("j2eeType", "WebModule");
        try {
            hash.put("name", Configuration.getConfigurationID((ObjectName)config).toString());
            Set names = this.kernel.listGBeans(new AbstractNameQuery(null, hash));
            if (names.size() != 1) {
                log.error("Unable to look up remote deploy upload URL");
                return null;
            }
            AbstractName module = (AbstractName)names.iterator().next();
            String contextPath = (String)this.kernel.getAttribute(module, "contextPath");
            if (null == contextPath) {
                throw new IllegalStateException("Cannot find contextPath attribute for [" + module + "]");
            }
            String temp = this.remoteDeployAddress + "/" + contextPath + "/upload";
            return URI.create(temp).normalize().toString();
        }
        catch (Exception e) {
            log.error("Unable to look up remote deploy upload URL", (Throwable)e);
            return null;
        }
    }

    public List<String> deploy(boolean inPlace, File moduleFile, File planFile, File targetFile, boolean install, String mainClass, String mainGBean, String mainMethod, String manifestConfigurations, String classPath, String endorsedDirs, String extensionDirs, String targetConfigurationStore) throws DeploymentException {
        List tempFiles;
        List<String> list;
        if (planFile == null && moduleFile == null) {
            throw new DeploymentException("No plan or module specified");
        }
        if (this.stores.isEmpty()) {
            throw new DeploymentException("No ConfigurationStores!");
        }
        this.validatePlanFile(planFile);
        ModuleIDBuilder idBuilder = new ModuleIDBuilder();
        DeploymentContext context = null;
        JarFile module = null;
        try {
            module = this.getModule(inPlace, moduleFile);
            this.validateModuleFile(module);
            FileUtils.beginRecordTempFiles();
            Object plan = null;
            ConfigurationBuilder builder = null;
            for (ConfigurationBuilder candidate : this.builders) {
                plan = candidate.getDeploymentPlan(planFile, module, idBuilder);
                if (plan == null) continue;
                builder = candidate;
                break;
            }
            if (builder == null) {
                throw new DeploymentException("Cannot deploy the requested application module because no deployer is able to handle it.  This can happen if you have omitted the J2EE deployment descriptor, disabled a deployer module, or if, for example, you are trying to deploy an EJB module on a minimal Geronimo server that does not have EJB support installed.  (" + (planFile == null ? "" : "planFile=" + planFile.getAbsolutePath()) + (moduleFile == null ? "" : (planFile == null ? "" : ", ") + "moduleFile=" + moduleFile.getAbsolutePath()) + ")");
            }
            Artifact configID = this.getConfigID(module, idBuilder, plan, builder);
            ConfigurationStore store = this.getConfigurationStore(targetConfigurationStore);
            context = builder.buildConfiguration(inPlace, configID, plan, module, this.stores, this.artifactResolver, store);
            if (planFile != null && !context.getTargetFile(PLAN_LOCATION).exists()) {
                context.addFile(PLAN_LOCATION, planFile);
            }
            Manifest manifest = this.createManifest(mainClass, mainGBean, mainMethod, manifestConfigurations, classPath, endorsedDirs, extensionDirs);
            list = this.install(targetFile, install, manifest, store, context);
        }
        catch (Throwable e) {
            try {
                if (e instanceof Error) {
                    log.error("Deployment failed due to ", e);
                    throw (Error)e;
                }
                if (e instanceof DeploymentException) {
                    throw (DeploymentException)e;
                }
                if (e instanceof Exception) {
                    log.error("Deployment failed due to ", e);
                    throw new DeploymentException(e);
                }
                throw new Error(e);
            }
            catch (Throwable throwable) {
                List tempFiles2;
                JarUtils.close(module);
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if ((tempFiles2 = FileUtils.endRecordTempFiles()) != null) {
                    this.cleanUpTemporaryDirectories(tempFiles2);
                }
                throw throwable;
            }
        }
        JarUtils.close((JarFile)module);
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((tempFiles = FileUtils.endRecordTempFiles()) != null) {
            this.cleanUpTemporaryDirectories(tempFiles);
        }
        return list;
    }

    private void validateModuleFile(JarFile module) throws DeploymentException {
        if (module != null && module.getEntry("META-INF/config.ser") != null) {
            throw new DeploymentException("The target applicaiton is an Geronimo plugin as config.ser was found in the META-INF directory, please use the install-plugin command.");
        }
    }

    private ConfigurationStore getConfigurationStore(String targetConfigurationStore) throws URISyntaxException, GBeanNotFoundException {
        if (targetConfigurationStore != null) {
            AbstractName targetStoreName = new AbstractName(new URI(targetConfigurationStore));
            return (ConfigurationStore)this.kernel.getGBean(targetStoreName);
        }
        return this.stores.iterator().next();
    }

    private Artifact getConfigID(JarFile module, ModuleIDBuilder idBuilder, Object plan, ConfigurationBuilder builder) throws IOException, DeploymentException, InvalidConfigException {
        Artifact configID = builder.getConfigurationID(plan, module, idBuilder);
        if (!configID.isResolved()) {
            configID = idBuilder.resolve(configID, "car");
        }
        try {
            this.kernel.getGBeanState(Configuration.getConfigurationAbstractName((Artifact)configID));
            throw new DeploymentException("Module " + configID + " already exists in the server.  Try to undeploy it first or use the redeploy command.");
        }
        catch (GBeanNotFoundException e) {
            return configID;
        }
    }

    private List<String> install(File targetFile, boolean install, Manifest manifest, ConfigurationStore store, DeploymentContext context) throws DeploymentException {
        ArrayList<ConfigurationData> configurationDatas = new ArrayList<ConfigurationData>();
        boolean configsCleanupRequired = false;
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        thread.setContextClassLoader((ClassLoader)new BundleClassLoader(context.getConfiguration().getBundle()));
        try {
            ArrayList<String> deployedURIs;
            try {
                configurationDatas.add(context.getConfigurationData());
            }
            catch (DeploymentException e) {
                Configuration configuration = context.getConfiguration();
                if (configuration != null) {
                    ConfigurationData dumbConfigurationData = new ConfigurationData(null, null, null, configuration.getEnvironment(), context.getBaseDir(), null, context.getNaming());
                    configurationDatas.add(dumbConfigurationData);
                }
                configurationDatas.addAll(context.getAdditionalDeployment());
                throw e;
            }
            configurationDatas.addAll(context.getAdditionalDeployment());
            if (configurationDatas.isEmpty()) {
                throw new DeploymentException("Deployer did not create any configurations");
            }
            if (targetFile != null) {
                if (configurationDatas.size() > 1) {
                    throw new DeploymentException("Deployer created more than one configuration");
                }
                ConfigurationData configurationData = (ConfigurationData)configurationDatas.get(0);
                ExecutableConfigurationUtil.createExecutableConfiguration((ConfigurationData)configurationData, (Manifest)manifest, (File)targetFile);
            }
            if (install) {
                deployedURIs = new ArrayList();
                for (ConfigurationData configurationData : configurationDatas) {
                    store.install(configurationData);
                    deployedURIs.add(configurationData.getId().toString());
                }
                this.notifyWatchers(deployedURIs);
                ArrayList<String> arrayList = deployedURIs;
                return arrayList;
            }
            configsCleanupRequired = true;
            deployedURIs = Collections.emptyList();
            return deployedURIs;
        }
        catch (DeploymentException e) {
            configsCleanupRequired = true;
            throw e;
        }
        catch (Throwable e) {
            configsCleanupRequired = true;
            throw new DeploymentException(e);
        }
        finally {
            thread.setContextClassLoader(oldCl);
            if (configsCleanupRequired) {
                this.cleanupConfigurations(configurationDatas);
            }
        }
    }

    private Manifest createManifest(String mainClass, String mainGBean, String mainMethod, String manifestConfigurations, String classPath, String endorsedDirs, String extensionDirs) {
        if (mainClass == null) {
            return null;
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        if (mainClass != null) {
            mainAttributes.putValue(Attributes.Name.MAIN_CLASS.toString(), mainClass);
        }
        if (mainGBean != null) {
            mainAttributes.putValue(CommandLineManifest.MAIN_GBEAN.toString(), mainGBean);
        }
        if (mainMethod != null) {
            mainAttributes.putValue(CommandLineManifest.MAIN_METHOD.toString(), mainMethod);
        }
        if (manifestConfigurations != null) {
            mainAttributes.putValue(CommandLineManifest.CONFIGURATIONS.toString(), manifestConfigurations);
        }
        if (classPath != null) {
            mainAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), classPath);
        }
        if (endorsedDirs != null) {
            mainAttributes.putValue(CommandLineManifest.ENDORSED_DIRS.toString(), endorsedDirs);
        }
        if (extensionDirs != null) {
            mainAttributes.putValue(CommandLineManifest.EXTENSION_DIRS.toString(), extensionDirs);
        }
        return manifest;
    }

    private JarFile getModule(boolean inPlace, File moduleFile) throws DeploymentException {
        if (moduleFile != null) {
            if (inPlace && !moduleFile.isDirectory()) {
                throw new DeploymentException("In place deployment is not allowed for packed module");
            }
            if (!moduleFile.exists()) {
                throw new DeploymentException("Module file does not exist: " + moduleFile.getAbsolutePath());
            }
            try {
                return JarUtils.createJarFile((File)moduleFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not open module file: " + moduleFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return null;
    }

    private void validatePlanFile(File planFile) throws DeploymentException {
        if (planFile != null) {
            if (!planFile.exists()) {
                throw new DeploymentException("Plan file does not exist: " + planFile.getAbsolutePath());
            }
            if (!planFile.isFile()) {
                throw new DeploymentException("Plan file is not a regular file: " + planFile.getAbsolutePath());
            }
        }
    }

    private void cleanUpTemporaryDirectories(List<File> temporaryDirectories) {
        for (File temporaryDirectory : temporaryDirectories) {
            this.reaper.delete(temporaryDirectory.getAbsolutePath(), "delete");
        }
    }

    private void notifyWatchers(List<String> list) {
        Artifact[] arts = new Artifact[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            arts[i] = Artifact.create((String)s);
        }
        for (DeploymentWatcher watcher : this.watchers) {
            for (int i = 0; i < arts.length; ++i) {
                Artifact art = arts[i];
                watcher.deployed(art);
            }
        }
    }

    private void cleanupConfigurations(List<ConfigurationData> configurations) {
        for (ConfigurationData configurationData : configurations) {
            File configurationDir = configurationData.getConfigurationDir();
            if (FileUtils.recursiveDelete((File)configurationDir)) continue;
            this.reaper.delete(configurationDir.getAbsolutePath(), "delete");
        }
    }

    public void doStart() throws Exception {
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStop() throws Exception {
        if (this.reaper != null) {
            this.reaper.close();
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(Deployer.class, (String)DEPLOYER);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("remoteDeployAddress", String.class, true, true);
        infoFactory.addAttribute("remoteDeployUploadURL", String.class, false);
        infoFactory.addReference("Builders", ConfigurationBuilder.class, "ConfigBuilder");
        infoFactory.addReference("Store", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.addReference("Watchers", DeploymentWatcher.class);
        infoFactory.setConstructor(new String[]{"remoteDeployAddress", "Builders", "Store", "Watchers", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    class DeployerReaper
    implements Runnable {
        private final int reaperInterval;
        private final Properties pendingDeletionIndex = new Properties();
        private volatile boolean done = false;
        private Thread thread;

        public DeployerReaper(int reaperInterval) {
            this.reaperInterval = reaperInterval;
            this.thread = new Thread((Runnable)this, "Geronimo Config Store Reaper");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void delete(String dir, String type) {
            this.pendingDeletionIndex.setProperty(dir, type);
            if (log.isDebugEnabled()) {
                log.debug("Queued deployment directory to be reaped " + dir);
            }
        }

        public void close() {
            this.done = true;
        }

        @Override
        public void run() {
            log.debug("ConfigStoreReaper started");
            this.reapBacklog();
            while (!this.done) {
                try {
                    Thread.sleep(this.reaperInterval);
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.reap();
            }
        }

        private void reapBacklog() {
            File deleteDir;
            String[] backlog;
            File tempDir;
            File tempFile;
            if (!Deployer.this.CLEAN_UP_ON_START) {
                return;
            }
            try {
                tempFile = File.createTempFile("geronimo-deployer", ".tmpdir");
                tempDir = tempFile.getParentFile();
                tempFile.delete();
                for (String dir : backlog = tempDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("geronimo-deployer") && name.endsWith(".tmpdir") && new File(dir, name).isDirectory();
                    }
                })) {
                    deleteDir = new File(tempDir, dir);
                    FileUtils.recursiveDelete((File)deleteDir);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Reaped deployment directory from previous runs " + deleteDir);
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                tempFile = FileUtils.createTempFile();
                tempDir = tempFile.getParentFile();
                tempFile.delete();
                for (String dir : backlog = tempDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        File file = new File(dir, name);
                        boolean validTempFile = name.startsWith("geronimo-fileutils") && (file.isDirectory() && name.endsWith(".tmpdir") || file.isFile());
                        return validTempFile && file.lastModified() < FileUtils.FILE_UTILS_INITIALIZATION_TIME_MILL;
                    }
                })) {
                    deleteDir = new File(tempDir, dir);
                    FileUtils.recursiveDelete((File)deleteDir);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Reaped deployment directory from previous runs " + deleteDir);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void reap() {
            if (this.pendingDeletionIndex.size() == 0) {
                return;
            }
            Enumeration<?> list = this.pendingDeletionIndex.propertyNames();
            while (list.hasMoreElements()) {
                String dirName = (String)list.nextElement();
                File deleteDir = new File(dirName);
                if (!FileUtils.recursiveDelete((File)deleteDir)) continue;
                this.pendingDeletionIndex.remove(dirName);
                if (!log.isDebugEnabled()) continue;
                log.debug("Reaped deployment directory " + deleteDir);
            }
        }
    }
}

