/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiBuildContext {
    private static final Logger logger = LoggerFactory.getLogger(OSGiBuildContext.class);
    private List<String> hiddenImportPackageNamePrefixes;
    private Set<String> hiddenImportPackageNames;
    private DependencyManager dependencyManager;
    private Environment environment;
    private boolean inverseClassLoading;
    private boolean clientModule;
    private ArtifactResolver clientArtifactResolver;
    private Map<String, Object> mergeAttributes = new HashMap<String, Object>();

    public OSGiBuildContext(Environment environment, List<String> hiddenImportPackageNamePrefixes, Set<String> hiddenImportPackageNames, DependencyManager dependencyManager, boolean inverseClassLoading) {
        this.hiddenImportPackageNamePrefixes = hiddenImportPackageNamePrefixes;
        this.hiddenImportPackageNames = hiddenImportPackageNames;
        this.dependencyManager = dependencyManager;
        this.environment = environment;
        this.inverseClassLoading = inverseClassLoading;
    }

    public Object getAttribute(String name) {
        return this.mergeAttributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.mergeAttributes.put(name, value);
    }

    public boolean isInverseClassLoading() {
        return this.inverseClassLoading;
    }

    public boolean isHiddenExportPackage(BundleDescription.ExportPackage exportPackage) {
        String packageName = exportPackage.getName();
        if (this.hiddenImportPackageNames.contains(packageName)) {
            return true;
        }
        for (String hiddenImportPackageNamePrefix : this.hiddenImportPackageNamePrefixes) {
            if (!packageName.startsWith(hiddenImportPackageNamePrefix)) continue;
            return true;
        }
        return false;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Set<BundleDescription.ExportPackage> getEffectExportPackages(Long bundleId) {
        HashSet<BundleDescription.ExportPackage> exportPackages = new HashSet<BundleDescription.ExportPackage>(this.dependencyManager.getExportedPackages(bundleId));
        Iterator it = exportPackages.iterator();
        while (it.hasNext()) {
            BundleDescription.ExportPackage exportPackage = (BundleDescription.ExportPackage)it.next();
            if (!this.isHiddenExportPackage(exportPackage) && exportPackage.getDirectives().get("mandatory") == null) continue;
            it.remove();
        }
        return exportPackages;
    }

    public Artifact resolveArtifact(Artifact artifact) {
        if (this.clientModule) {
            try {
                return this.clientArtifactResolver.resolveInClassLoader(artifact);
            }
            catch (MissingDependencyException e) {
                logger.warn("Fail to resovle artifact " + artifact + " with client artifact resolver", (Throwable)e);
                return null;
            }
        }
        return artifact;
    }

    public Set<Long> getFullDependentBundleIds(Bundle bundle) {
        if (this.clientModule) {
            return this.getFullClientDependentBundleIds(bundle.getBundleId());
        }
        return this.dependencyManager.getFullDependentBundleIds(bundle);
    }

    private Set<Long> getFullClientDependentBundleIds(long bundleId) {
        Artifact artifact = this.dependencyManager.getArtifact(bundleId);
        if (artifact == null) {
            return Collections.emptySet();
        }
        Artifact resolvedDependentArtifact = this.resolveArtifact(artifact);
        if (resolvedDependentArtifact == null) {
            return Collections.emptySet();
        }
        HashSet<Long> dependentBundleIds = new HashSet<Long>();
        this.searchFullClientDependentBundleIds(resolvedDependentArtifact, dependentBundleIds);
        return dependentBundleIds;
    }

    private void searchFullClientDependentBundleIds(Artifact resolvedClientArtifact, Set<Long> dependentBundleIds) {
        if (resolvedClientArtifact == null) {
            return;
        }
        Bundle resolvedBundle = this.dependencyManager.getBundle(resolvedClientArtifact);
        if (resolvedBundle == null || dependentBundleIds.contains(resolvedBundle.getBundleId())) {
            return;
        }
        PluginArtifactType pluginArtifact = this.dependencyManager.getCachedPluginMetadata(resolvedBundle);
        if (pluginArtifact != null) {
            for (DependencyType dependency : pluginArtifact.getDependency()) {
                Artifact resolvedDependentArtifact = this.resolveArtifact(dependency.toArtifact());
                if (resolvedDependentArtifact == null) continue;
                this.searchFullClientDependentBundleIds(resolvedDependentArtifact, dependentBundleIds);
            }
        }
        dependentBundleIds.add(resolvedBundle.getBundleId());
    }

    public boolean isClientModule() {
        return this.clientModule;
    }

    public void setClientModule(boolean clientModule) {
        this.clientModule = clientModule;
    }

    public ArtifactResolver getClientArtifactResolver() {
        return this.clientArtifactResolver;
    }

    public void setClientArtifactResolver(ArtifactResolver clientArtifactResolver) {
        this.clientArtifactResolver = clientArtifactResolver;
    }
}

