/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;

public class CommandUninstallBundle
extends AbstractCommand {
    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        if (!this.isOffline(connection)) {
            long bundleId = Long.parseLong(commandArgs.getArgs()[0]);
            DeploymentManager dmgr = connection.getDeploymentManager();
            if (dmgr instanceof GeronimoDeploymentManager) {
                GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
                try {
                    mgr.eraseUninstall(bundleId);
                    consoleReader.printString(DeployUtils.reformat("Uninstalled and erased bundle: " + bundleId, 4, 72));
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to erase bundle: " + bundleId, (Throwable)e);
                }
            }
            throw new DeploymentException("Unable to uninstall bundle using " + dmgr.getClass().getName() + " deployment manager");
        }
        try {
            consoleReader.printString(DeployUtils.reformat("Uninstall bundle offline is not supported!", 4, 72));
        }
        catch (IOException e) {
            throw new DeploymentException("Uninstall bundle offline is not supported!");
        }
    }
}

