/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.deployment.ModuleConfigurer;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.deployment.plugin.remote.DistributeCommand;
import org.apache.geronimo.deployment.plugin.remote.RedeployCommand;
import org.apache.geronimo.deployment.plugin.remote.RemoteDeployUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.jmx.KernelDelegate;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.plugin.ServerArchiver;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.codehaus.plexus.archiver.ArchiverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeploymentManager
extends JMXDeploymentManager
implements GeronimoDeploymentManager,
ServerArchiver {
    private static final Log log = LogFactory.getLog(RemoteDeploymentManager.class);
    private JMXConnector jmxConnector;
    private boolean isSameMachine;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_MODULE_CONFIGURERS = "ModuleConfigurers";

    public RemoteDeploymentManager(Collection<ModuleConfigurer> moduleConfigurers) {
        super(moduleConfigurers);
    }

    public void init(JMXConnector jmxConnector, String hostname) throws IOException {
        this.jmxConnector = jmxConnector;
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        this.initialize((Kernel)new KernelDelegate(mbServerConnection));
        this.checkSameMachine(hostname);
    }

    public boolean isSameMachine() {
        return this.isSameMachine;
    }

    private void checkSameMachine(String hostname) {
        this.isSameMachine = false;
        if (hostname.equals("localhost") || hostname.equals("127.0.0.1")) {
            this.isSameMachine = true;
            return;
        }
        try {
            InetAddress dest = InetAddress.getByName(hostname);
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                Enumeration<InetAddress> ine = iface.getInetAddresses();
                while (ine.hasMoreElements()) {
                    InetAddress address = ine.nextElement();
                    if (!address.equals(dest)) continue;
                    this.isSameMachine = true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to look up host name '" + hostname + "'; assuming it is a different machine, but this may not get very far."), (Throwable)e);
        }
    }

    @Override
    public void release() {
        super.release();
        try {
            this.jmxConnector.close();
            this.jmxConnector = null;
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException("Unable to close connection").initCause(e);
        }
    }

    @Override
    protected org.apache.geronimo.deployment.plugin.local.DistributeCommand createDistributeCommand(Target[] targetList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        }
        return new DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    @Override
    protected org.apache.geronimo.deployment.plugin.local.DistributeCommand createDistributeCommand(Target[] targetList, ModuleType moduleType, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleType, moduleArchive, deploymentPlan);
        }
        return new DistributeCommand(this.kernel, targetList, moduleType, moduleArchive, deploymentPlan);
    }

    @Override
    protected org.apache.geronimo.deployment.plugin.local.RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    @Override
    protected org.apache.geronimo.deployment.plugin.local.RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginListType listPlugins(URL mavenRepository, String username, String password) throws FailedLoginException, IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginListType pluginListType = installer.listPlugins(mavenRepository, username, password);
            return pluginListType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePlugin(PluginType plugin) throws MissingDependencyException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.validatePlugin(plugin);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dependency[] checkPrerequisites(PluginType plugin) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Dependency[] dependencyArray = installer.checkPrerequisites(plugin);
            return dependencyArray;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults install(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.install(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.install(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password, poller);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startInstall(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Object object = installer.startInstall(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password);
            return object;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startInstall(File carFile, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        File[] args = new File[]{carFile};
        if (!this.isSameMachine) {
            AbstractDeployCommand progress = new AbstractDeployCommand(CommandType.DISTRIBUTE, this.kernel, null, null, null, null, null, false){

                public void run() {
                }
            };
            progress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    log.info((Object)event.getDeploymentStatus().getMessage());
                }
            });
            progress.setCommandContext(this.commandContext);
            RemoteDeployUtil.uploadFilesToServer(args, progress);
        }
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Object object = installer.startInstall(carFile, defaultRepository, restrictToDefaultRepository, username, password);
            return object;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults checkOnInstall(Object key) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.checkOnInstall(key);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    private PluginInstaller getPluginInstaller() {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator i$ = set.iterator();
        if (i$.hasNext()) {
            AbstractName name = (AbstractName)i$.next();
            return (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
        }
        throw new IllegalStateException("No plugin installer found");
    }

    private ServerArchiver getServerArchiver() {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(ServerArchiver.class.getName()));
        Iterator i$ = set.iterator();
        if (i$.hasNext()) {
            AbstractName name = (AbstractName)i$.next();
            return (ServerArchiver)this.kernel.getProxyManager().createProxy(name, ServerArchiver.class);
        }
        throw new IllegalStateException("No plugin installer found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginListType createPluginListForRepositories(String repo) throws NoSuchStoreException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginListType pluginListType = installer.createPluginListForRepositories(repo);
            return pluginListType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getInstalledPlugins() {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Map map = installer.getInstalledPlugins();
            return map;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginType getPluginMetadata(Artifact configId) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginType pluginType = installer.getPluginMetadata(configId);
            return pluginType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePluginMetadata(PluginType metadata) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.updatePluginMetadata(metadata);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    @Override
    public URL[] getRepositories() {
        ArrayList list = new ArrayList();
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginRepositoryList.class.getName()));
        for (AbstractName name : set) {
            PluginRepositoryList repo = (PluginRepositoryList)this.kernel.getProxyManager().createProxy(name, PluginRepositoryList.class);
            list.addAll(repo.getRepositories());
            this.kernel.getProxyManager().destroyProxy((Object)repo);
        }
        return list.toArray(new URL[list.size()]);
    }

    public Artifact installLibrary(File libFile, String groupId) throws IOException {
        Set set;
        Iterator i$;
        File[] args = new File[]{libFile};
        if (!this.isSameMachine) {
            AbstractDeployCommand progress = new AbstractDeployCommand(CommandType.DISTRIBUTE, this.kernel, null, null, null, null, null, false){

                public void run() {
                }
            };
            progress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    log.info((Object)event.getDeploymentStatus().getMessage());
                }
            });
            progress.setCommandContext(this.commandContext);
            RemoteDeployUtil.uploadFilesToServer(args, progress);
        }
        if ((i$ = (set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()))).iterator()).hasNext()) {
            AbstractName name = (AbstractName)i$.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            Artifact artifact = installer.installLibrary(libFile, groupId);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return artifact;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults installPluginList(String targetRepositoryPath, String relativeTargetServerPath, PluginListType pluginList) throws Exception {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.installPluginList(targetRepositoryPath, relativeTargetServerPath, pluginList);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File archive(String sourcePath, String destPath, Artifact artifact) throws ArchiverException, IOException {
        ServerArchiver archiver = this.getServerArchiver();
        try {
            File file = archiver.archive(sourcePath, destPath, artifact);
            return file;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)archiver);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(RemoteDeploymentManager.class, (String)"RemoteDeploymentManager");
        infoFactory.addInterface(GeronimoDeploymentManager.class);
        infoFactory.addReference(GBEAN_REF_MODULE_CONFIGURERS, ModuleConfigurer.class);
        infoFactory.setConstructor(new String[]{GBEAN_REF_MODULE_CONFIGURERS});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

