/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.osgi;

import java.io.IOException;
import java.net.URL;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class FrameworkUtils {
    private static final String USE_URL_CLASSLOADER = "org.apache.geronimo.equinox.useURLClassLoader";
    private static final String USE_URL_CLASSLOADER_LOCAL = "org.apache.geronimo.kernel.osgi.useURLClassLoader";
    private static final boolean useURLClassLoader = FrameworkUtils.initUseURLClassLoader();
    private static final boolean isEquinox = FrameworkUtils.initIsEquinox();
    private static final Object urlConverter = FrameworkUtils.initUrlConverter();

    private static boolean initUseURLClassLoader() {
        String property = System.getProperty(USE_URL_CLASSLOADER);
        if (property == null) {
            property = System.getProperty(USE_URL_CLASSLOADER_LOCAL, "true");
        }
        return Boolean.parseBoolean(property);
    }

    private static boolean initIsEquinox() {
        Bundle bundle = FrameworkUtil.getBundle(FrameworkUtils.class);
        return bundle != null && (bundle = bundle.getBundleContext().getBundle(0L)).getSymbolicName().startsWith("org.eclipse.osgi");
    }

    private static Object initUrlConverter() {
        Bundle bundle;
        BundleContext context;
        ServiceReference<?> reference;
        if (isEquinox && (reference = (context = (bundle = FrameworkUtil.getBundle(FrameworkUtils.class)).getBundleContext()).getServiceReference(URLConverter.class.getName())) != null) {
            return context.getService(reference);
        }
        return null;
    }

    public static boolean isEquinox() {
        return isEquinox;
    }

    public static boolean useURLClassLoader() {
        return useURLClassLoader;
    }

    public static URL convertURL(URL bundleURL) {
        if (urlConverter != null && bundleURL != null) {
            try {
                return ((URLConverter)urlConverter).resolve(bundleURL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bundleURL;
    }
}

