/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;

public class DefaultArtifactManager
implements ArtifactManager {
    private final Map<Artifact, Set<Artifact>> artifactsByLoader = new HashMap<Artifact, Set<Artifact>>();
    private final Map<String, List<Artifact>> artifactsByArtifact = new HashMap<String, List<Artifact>>();
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadArtifacts(Artifact loader, Set<Artifact> artifacts) {
        if (!loader.isResolved()) {
            throw new IllegalArgumentException("loader is not a resolved artifact: " + loader);
        }
        for (Artifact artifact : artifacts) {
            if (artifact.isResolved()) continue;
            throw new IllegalArgumentException("artifact is not a resolved artifact: " + artifact);
        }
        DefaultArtifactManager defaultArtifactManager = this;
        synchronized (defaultArtifactManager) {
            if (this.artifactsByLoader.containsKey(loader)) {
                throw new IllegalArgumentException("loader has already declared artifacts: " + loader);
            }
            this.artifactsByLoader.put(loader, artifacts);
            this.processArtifact(loader);
            for (Artifact artifact : artifacts) {
                this.processArtifact(artifact);
            }
        }
    }

    private void processArtifact(Artifact artifact) {
        List<Artifact> values = this.artifactsByArtifact.get(artifact.getArtifactId());
        if (values == null) {
            values = new ArrayList<Artifact>();
            this.artifactsByArtifact.put(artifact.getArtifactId(), values);
        }
        values.add(artifact);
    }

    @Override
    public synchronized void unloadAllArtifacts(Artifact loader) {
        this.removeArtifact(loader);
        Set<Artifact> artifacts = this.artifactsByLoader.remove(loader);
        if (artifacts == null) {
            return;
        }
        for (Artifact artifact : artifacts) {
            this.removeArtifact(artifact);
        }
    }

    private void removeArtifact(Artifact artifact) {
        List<Artifact> values = this.artifactsByArtifact.get(artifact.getArtifactId());
        if (values != null) {
            values.remove(artifact);
            if (values.isEmpty()) {
                this.artifactsByArtifact.remove(artifact.getArtifactId());
            }
        }
    }

    @Override
    public SortedSet<Artifact> getLoadedArtifacts(Artifact query) {
        List<Artifact> values = this.artifactsByArtifact.get(query.getArtifactId());
        TreeSet<Artifact> results = new TreeSet<Artifact>();
        if (values != null) {
            for (Artifact test : values) {
                if (!query.matches(test)) continue;
                results.add(test);
            }
        }
        return results;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DefaultArtifactManager.class, "ArtifactManager");
        infoFactory.addInterface(ArtifactManager.class);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

