/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.management;

import java.io.Serializable;

public final class State
implements Serializable {
    public static final int STARTING_INDEX = 0;
    public static final int RUNNING_INDEX = 1;
    public static final int STOPPING_INDEX = 2;
    public static final int STOPPED_INDEX = 3;
    public static final int FAILED_INDEX = 4;
    public static final State STARTING = new State("starting", 0, "j2ee.state.starting");
    public static final State RUNNING = new State("running", 1, "j2ee.state.running");
    public static final State STOPPING = new State("stopping", 2, "j2ee.state.stopping");
    public static final State STOPPED = new State("stopped", 3, "j2ee.state.stopped");
    public static final State FAILED = new State("failed", 4, "j2ee.state.failed");
    private static final State[] fromInt = new State[]{STARTING, RUNNING, STOPPING, STOPPED, FAILED};
    private final String name;
    private final int index;
    private final String eventTypeValue;

    public static State fromInt(int index) {
        if (index < 0 || index >= fromInt.length) {
            return null;
        }
        return fromInt[index];
    }

    public static State fromInteger(Integer index) {
        return State.fromInt(index);
    }

    public static String toString(int state) {
        if (state < 0 || state >= fromInt.length) {
            throw new IllegalArgumentException("State must be between 0 and " + fromInt.length);
        }
        return State.fromInt[state].name;
    }

    private State(String name, int index, String anEventTypeValue) {
        this.name = name;
        this.index = index;
        this.eventTypeValue = anEventTypeValue;
    }

    public int toInt() {
        return this.index;
    }

    public String getEventTypeValue() {
        return this.eventTypeValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRunning() {
        return this == RUNNING;
    }

    public boolean isStopped() {
        return this == STOPPED;
    }

    public boolean isFailed() {
        return this == FAILED;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        return fromInt[this.index];
    }
}

