/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.geronimo.kernel.ClassLoading;
import org.osgi.framework.Bundle;

public class ObjectInputStreamExt
extends ObjectInputStream {
    private Bundle bundle;

    public ObjectInputStreamExt(InputStream in, Bundle bundle) throws IOException {
        super(in);
        this.bundle = bundle;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        return ClassLoading.loadClass(classDesc.getName(), this.bundle);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.bundle.loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(null, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

