/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.KernelGetAttributeInvoker;
import org.apache.geronimo.kernel.basic.KernelOperationInvoker;
import org.apache.geronimo.kernel.basic.KernelSetAttributeInvoker;
import org.apache.geronimo.kernel.basic.ProxyInvoker;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.proxy.DeadProxyException;
import org.apache.geronimo.kernel.proxy.GeronimoManagedBean;

public class JMXProxyMethodInterceptor
implements MethodInterceptor {
    private final Class proxyType;
    private final AbstractName objectName;
    private ProxyInvoker[] gbeanInvokers;

    public JMXProxyMethodInterceptor(Class proxyType, Kernel kernel, AbstractName targetName) {
        assert (proxyType != null);
        assert (kernel != null);
        assert (targetName != null);
        this.proxyType = proxyType;
        this.objectName = targetName;
        this.gbeanInvokers = this.createGBeanInvokers(kernel);
    }

    public synchronized void destroy() {
        this.gbeanInvokers = null;
    }

    public AbstractName getAbstractName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        ProxyInvoker gbeanInvoker;
        int interfaceIndex = proxy.getSuperIndex();
        JMXProxyMethodInterceptor jMXProxyMethodInterceptor = this;
        synchronized (jMXProxyMethodInterceptor) {
            if (this.gbeanInvokers == null) {
                throw new DeadProxyException("Proxy is no longer valid");
            }
            gbeanInvoker = this.gbeanInvokers[interfaceIndex];
        }
        if (gbeanInvoker == null) {
            throw new UnsupportedOperationException("No implementation method: objectName=" + this.objectName + ", method=" + method);
        }
        return gbeanInvoker.invoke(this.objectName, args);
    }

    private ProxyInvoker[] createGBeanInvokers(Kernel kernel) {
        Method[] methods;
        FastClass fastClass = FastClass.create(this.proxyType);
        ProxyInvoker[] invokers = new ProxyInvoker[fastClass.getMaxIndex() + 1];
        for (Method method : methods = this.proxyType.getMethods()) {
            int interfaceIndex = JMXProxyMethodInterceptor.getSuperIndex(this.proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createProxyInvoker(kernel, method);
        }
        try {
            invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"equals", new Class[]{Object.class}))] = new EqualsInvoke(kernel);
            invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"hashCode", (Class[])null))] = new HashCodeInvoke();
            invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"toString", (Class[])null))] = new ToStringInvoke(this.proxyType.getName());
            if (GeronimoManagedBean.class.isAssignableFrom(this.proxyType)) {
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getState", (Class[])null))] = new GetStateInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getStateInstance", (Class[])null))] = new GetStateInstanceInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"start", (Class[])null))] = new StartInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"startRecursive", (Class[])null))] = new StartRecursiveInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"stop", (Class[])null))] = new StopInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getStartTime", (Class[])null))] = new GetStartTimeInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getObjectName", (Class[])null))] = new GetObjectNameInvoke();
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return invokers;
    }

    private ProxyInvoker createProxyInvoker(Kernel kernel, Method method) {
        String methodName = method.getName();
        if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
            if (methodName.length() > 3 && methodName.startsWith("get") && !methodName.equals("getClass")) {
                String propertyName = JMXProxyMethodInterceptor.decapitalizePropertyName(methodName.substring(3));
                return new KernelGetAttributeInvoker(kernel, propertyName);
            }
            if (methodName.length() > 2 && methodName.startsWith("is")) {
                String propertyName = JMXProxyMethodInterceptor.decapitalizePropertyName(methodName.substring(2));
                return new KernelGetAttributeInvoker(kernel, propertyName);
            }
        }
        if (method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && methodName.length() > 3 && methodName.startsWith("set")) {
            String propertyName = JMXProxyMethodInterceptor.decapitalizePropertyName(methodName.substring(3));
            return new KernelSetAttributeInvoker(kernel, propertyName);
        }
        return new KernelOperationInvoker(kernel, method);
    }

    private static int getSuperIndex(Class proxyType, Method method) {
        Signature signature = new Signature(method.getName(), Type.getReturnType(method), Type.getArgumentTypes(method));
        MethodProxy methodProxy = MethodProxy.find(proxyType, signature);
        if (methodProxy != null) {
            return methodProxy.getSuperIndex();
        }
        return -1;
    }

    private static String decapitalizePropertyName(String propertyName) {
        if (Character.isUpperCase(propertyName.charAt(0))) {
            return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
        }
        return propertyName;
    }

    static final class GetObjectNameInvoke
    implements ProxyInvoker {
        GetObjectNameInvoke() {
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return abstractName.getObjectName().getCanonicalName();
        }
    }

    static final class StopInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StopInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            this.kernel.stopGBean(abstractName);
            return null;
        }
    }

    static final class GetStartTimeInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStartTimeInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return this.kernel.getGBeanStartTime(abstractName);
        }
    }

    static final class StartRecursiveInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StartRecursiveInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            this.kernel.startRecursiveGBean(abstractName);
            return null;
        }
    }

    static final class StartInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StartInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            this.kernel.startGBean(abstractName);
            return null;
        }
    }

    static final class GetStateInstanceInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStateInstanceInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return State.fromInt(this.kernel.getGBeanState(abstractName));
        }
    }

    static final class GetStateInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStateInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return this.kernel.getGBeanState(abstractName);
        }
    }

    static final class ToStringInvoke
    implements ProxyInvoker {
        private final String interfaceName;

        public ToStringInvoke(String interfaceName) {
            this.interfaceName = "[" + interfaceName + ": ";
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return this.interfaceName + abstractName + "]";
        }
    }

    static final class EqualsInvoke
    implements ProxyInvoker {
        private final Kernel kernel;

        public EqualsInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            AbstractName proxyTarget = this.kernel.getAbstractNameFor(arguments[0]);
            return abstractName.equals(proxyTarget);
        }
    }

    static final class HashCodeInvoke
    implements ProxyInvoker {
        HashCodeInvoke() {
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return abstractName.hashCode();
        }
    }
}

